/*
 * Decompiled with CFR 0.152.
 */
package io.adtrace.sdk.scheduler;

import io.adtrace.sdk.AdTraceFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ThreadFactoryWrapper
implements ThreadFactory {
    private String source;

    public ThreadFactoryWrapper(String source) {
        this.source = source;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setPriority(9);
        thread.setName("AdTrace-" + thread.getName() + "-" + this.source);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable tr) {
                AdTraceFactory.getLogger().error("Thread [%s] with error [%s]", th.getName(), tr.getMessage());
            }
        });
        return thread;
    }
}

