/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ArchiveEventCode;
import io.aeron.agent.ArchiveEventLogger;
import io.aeron.agent.ArchiveInterceptor;
import io.aeron.agent.ComponentLogger;
import io.aeron.agent.ControlInterceptor;
import io.aeron.agent.EventCodeType;
import io.aeron.agent.EventConfiguration;
import io.aeron.shadow.net.bytebuddy.agent.builder.AgentBuilder;
import io.aeron.shadow.net.bytebuddy.asm.Advice;
import io.aeron.shadow.net.bytebuddy.matcher.ElementMatchers;
import java.util.EnumSet;
import java.util.Map;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Object2ObjectHashMap;

public class ArchiveComponentLogger
implements ComponentLogger {
    static final EnumSet<ArchiveEventCode> ENABLED_EVENTS = EnumSet.noneOf(ArchiveEventCode.class);
    private static final Object2ObjectHashMap<String, EnumSet<ArchiveEventCode>> SPECIAL_EVENTS = new Object2ObjectHashMap();

    @Override
    public int typeCode() {
        return EventCodeType.ARCHIVE.getTypeCode();
    }

    @Override
    public void decode(MutableDirectBuffer buffer, int offset, int eventCodeId, StringBuilder builder) {
        ArchiveEventCode.get(eventCodeId).decode(buffer, offset, builder);
    }

    @Override
    public AgentBuilder addInstrumentation(AgentBuilder agentBuilder, Map<String, String> configOptions) {
        ENABLED_EVENTS.clear();
        ENABLED_EVENTS.addAll(ArchiveComponentLogger.getArchiveEventCodes(configOptions.get("aeron.event.archive.log")));
        ENABLED_EVENTS.removeAll(ArchiveComponentLogger.getArchiveEventCodes(configOptions.get("aeron.event.archive.log.disable")));
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = ArchiveComponentLogger.addArchiveControlSessionDemuxerInstrumentation(tempBuilder);
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.CMD_OUT_RESPONSE, "ControlResponseProxy", ControlInterceptor.ControlResponse.class, "logSendResponse");
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.RECORDING_SIGNAL, "ControlResponseProxy", ControlInterceptor.RecordingSignal.class, "logSendSignal");
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.REPLAY_SESSION_STATE_CHANGE, "ReplaySession", ArchiveInterceptor.ReplaySessionStateChange.class, "logStateChange");
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.RECORDING_SESSION_STATE_CHANGE, "RecordingSession", ArchiveInterceptor.RecordingSessionStateChange.class, "logStateChange");
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.REPLICATION_SESSION_STATE_CHANGE, "ReplicationSession", ArchiveInterceptor.ReplicationSessionStateChange.class, "logStateChange");
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.REPLICATION_SESSION_DONE, "ReplicationSession", ArchiveInterceptor.ReplicationSessionDone.class, "logReplicationSessionDone");
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.CONTROL_SESSION_STATE_CHANGE, "ControlSession", ArchiveInterceptor.ControlSessionStateChange.class, "logStateChange");
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.REPLAY_SESSION_ERROR, "ReplaySession", ArchiveInterceptor.ReplaySession.class, "onPendingError");
        tempBuilder = ArchiveComponentLogger.addEventInstrumentation(tempBuilder, ArchiveEventCode.CATALOG_RESIZE, "Catalog", ArchiveInterceptor.Catalog.class, "catalogResized");
        return tempBuilder;
    }

    @Override
    public void reset() {
        ENABLED_EVENTS.clear();
    }

    private static EnumSet<ArchiveEventCode> getArchiveEventCodes(String enabledEventCodes) {
        return EventConfiguration.parseEventCodes(ArchiveEventCode.class, enabledEventCodes, SPECIAL_EVENTS, ArchiveEventCode::get, ArchiveEventCode::valueOf);
    }

    private static AgentBuilder addArchiveControlSessionDemuxerInstrumentation(AgentBuilder agentBuilder) {
        if (ArchiveEventLogger.CONTROL_REQUEST_EVENTS.stream().noneMatch(ENABLED_EVENTS::contains)) {
            return agentBuilder;
        }
        return agentBuilder.type(ElementMatchers.nameEndsWith("ControlSessionDemuxer")).transform((builder, typeDescription, classLoader, module, protectionDomain) -> builder.visit(Advice.to(ControlInterceptor.ControlRequest.class).on(ElementMatchers.named("onFragment"))));
    }

    private static AgentBuilder addEventInstrumentation(AgentBuilder agentBuilder, ArchiveEventCode code, String typeName, Class<?> interceptorClass, String interceptorMethod) {
        if (!ENABLED_EVENTS.contains(code)) {
            return agentBuilder;
        }
        return agentBuilder.type(ElementMatchers.nameEndsWith(typeName)).transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> builder.visit(Advice.to(interceptorClass).on(ElementMatchers.named(interceptorMethod))));
    }

    static {
        SPECIAL_EVENTS.put("all", EnumSet.allOf(ArchiveEventCode.class));
    }
}

