/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.CommonEventEncoder;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

final class ArchiveEventEncoder {
    private ArchiveEventEncoder() {
    }

    static <E extends Enum<E>> int encodeReplaySessionStateChange(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, E from, E to, long id, long recordingId, long position, String reason) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, id, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), recordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), position, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 8;
        encodedLength += CommonEventEncoder.encodeStateChange(encodingBuffer, offset + encodedLength, from, to);
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, captureLength + 16 - encodedLength, reason);
        return encodedLength;
    }

    static <E extends Enum<E>> int replaySessionStateChangeLength(E from, E to, String reason) {
        return CommonEventEncoder.stateTransitionStringLength(from, to) + 24 + (4 + reason.length());
    }

    static <E extends Enum<E>> int encodeRecordingSessionStateChange(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, E from, E to, long recordingId, long position, String reason) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, recordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), position, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 8;
        encodedLength += CommonEventEncoder.encodeStateChange(encodingBuffer, offset + encodedLength, from, to);
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, captureLength + 16 - encodedLength, reason);
        return encodedLength;
    }

    static <E extends Enum<E>> int recordingSessionStateChangeLength(E from, E to, String reason) {
        return CommonEventEncoder.stateTransitionStringLength(from, to) + 16 + (4 + reason.length());
    }

    static <E extends Enum<E>> int encodeReplicationSessionStateChange(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, E from, E to, long replicationId, long srcRecordingId, long dstRecordingId, long position, String reason) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, replicationId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), srcRecordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), dstRecordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), position, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 8;
        encodedLength += CommonEventEncoder.encodeStateChange(encodingBuffer, offset + encodedLength, from, to);
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, captureLength + 16 - encodedLength, reason);
        return encodedLength;
    }

    static <E extends Enum<E>> int replicationSessionStateChangeLength(E from, E to, String reason) {
        return CommonEventEncoder.stateTransitionStringLength(from, to) + 32 + (4 + reason.length());
    }

    static <E extends Enum<E>> int encodeSessionStateChange(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, E from, E to, long id) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, id, ByteOrder.LITTLE_ENDIAN);
        return CommonEventEncoder.encodeTrailingStateChange(encodingBuffer, offset, encodedLength += 8, captureLength, from, to);
    }

    static <E extends Enum<E>> int sessionStateChangeLength(E from, E to) {
        return CommonEventEncoder.stateTransitionStringLength(from, to) + 8;
    }

    static void encodeReplaySessionError(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, long sessionId, long recordingId, String errorMessage) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, sessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), recordingId, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + (encodedLength += 8), captureLength - 8, errorMessage);
    }

    static void encodeCatalogResize(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, long catalogLength, long newCatalogLength) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, catalogLength, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), newCatalogLength, ByteOrder.LITTLE_ENDIAN);
    }

    static int replicationSessionDoneLength() {
        return 67;
    }

    static void encodeReplicationSessionDone(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, long controlSessionId, long replicationId, long srcRecordingId, long replayPosition, long srcStopPosition, long dstRecordingId, long dstStopPosition, long position, boolean isClosed, boolean isEndOfStream, boolean isSynced) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, controlSessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), replicationId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), srcRecordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), replayPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), srcStopPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), dstRecordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), dstStopPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), position, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putByte(bodyOffset + (bodyLength += 8), (byte)(isClosed ? 1 : 0));
        encodingBuffer.putByte(bodyOffset + ++bodyLength, (byte)(isEndOfStream ? 1 : 0));
        encodingBuffer.putByte(bodyOffset + ++bodyLength, (byte)(isSynced ? 1 : 0));
    }
}

