/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ArchiveEventLogger;
import io.aeron.shadow.net.bytebuddy.asm.Advice;

class ArchiveInterceptor {
    ArchiveInterceptor() {
    }

    static class Catalog {
        Catalog() {
        }

        @Advice.OnMethodEnter
        static void catalogResized(long catalogLength, long newCatalogLength) {
            ArchiveEventLogger.LOGGER.logCatalogResize(catalogLength, newCatalogLength);
        }
    }

    static class ReplaySession {
        ReplaySession() {
        }

        @Advice.OnMethodEnter
        static void onPendingError(long sessionId, long recordingId, String errorMessage) {
            ArchiveEventLogger.LOGGER.logReplaySessionError(sessionId, recordingId, errorMessage);
        }
    }

    static class ControlSessionStateChange {
        ControlSessionStateChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logStateChange(E oldState, E newState, long controlSessionId) {
            ArchiveEventLogger.LOGGER.logControlSessionStateChange(oldState, newState, controlSessionId);
        }
    }

    static class ReplicationSessionDone {
        ReplicationSessionDone() {
        }

        @Advice.OnMethodEnter
        static void logReplicationSessionDone(long controlSessionId, long replicationId, long srcRecordingId, long replayPosition, long srcStopPosition, long dstRecordingId, long dstStopPosition, long position, boolean isClosed, boolean isEndOfStream, boolean isSynced) {
            ArchiveEventLogger.LOGGER.logReplicationSessionDone(controlSessionId, replicationId, srcRecordingId, replayPosition, srcStopPosition, dstRecordingId, dstStopPosition, position, isClosed, isEndOfStream, isSynced);
        }
    }

    static class ReplicationSessionStateChange {
        ReplicationSessionStateChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logStateChange(E oldState, E newState, long replicationId, long srcRecordingId, long dstRecordingId, long position, String reason) {
            ArchiveEventLogger.LOGGER.logReplicationSessionStateChange(oldState, newState, replicationId, srcRecordingId, dstRecordingId, position, reason);
        }
    }

    static class RecordingSessionStateChange {
        RecordingSessionStateChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logStateChange(E oldState, E newState, long recordingId, long position, String reason) {
            ArchiveEventLogger.LOGGER.logRecordingSessionStateChange(oldState, newState, recordingId, position, reason);
        }
    }

    static class ReplaySessionStateChange {
        ReplaySessionStateChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logStateChange(E oldState, E newState, long sessionId, long recordingId, long position, String reason) {
            ArchiveEventLogger.LOGGER.logReplaySessionStateChange(oldState, newState, sessionId, recordingId, position, reason);
        }
    }
}

