/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.DriverEventCode;
import io.aeron.agent.DriverEventLogger;
import io.aeron.driver.media.ImageConnection;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.shadow.net.bytebuddy.asm.Advice;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class ChannelEndpointInterceptor {
    ChannelEndpointInterceptor() {
    }

    static class ReceiveChannelEndpointInterceptor {
        ReceiveChannelEndpointInterceptor() {
        }

        static class SendNakMessage {
            SendNakMessage() {
            }

            @Advice.OnMethodEnter
            static void sendNakMessage(ImageConnection[] connections, int sessionId, int streamId, int termId, int termOffset, int length, @Advice.This Object thisObject) {
                if (null == connections || null == thisObject) {
                    return;
                }
                ReceiveChannelEndpoint endpoint = (ReceiveChannelEndpoint)thisObject;
                String channel = endpoint.originalUriString();
                for (ImageConnection connection : connections) {
                    if (null == connection) continue;
                    DriverEventLogger.LOGGER.logSendNakMessage(connection.controlAddress, sessionId, streamId, termId, termOffset, length, channel);
                }
            }
        }
    }

    static class UdpChannelTransport {
        UdpChannelTransport() {
        }

        static class ResendHook {
            ResendHook() {
            }

            @Advice.OnMethodEnter
            static void resendHook(int sessionId, int streamId, int termId, int termOffset, int length, @Advice.This Object thisObject) {
                io.aeron.driver.media.UdpChannelTransport transport = (io.aeron.driver.media.UdpChannelTransport)thisObject;
                DriverEventLogger.LOGGER.logResend(sessionId, streamId, termId, termOffset, length, transport.udpChannel().originalUriString());
            }
        }

        static class ReceiveHook {
            ReceiveHook() {
            }

            @Advice.OnMethodEnter
            static void receiveHook(UnsafeBuffer buffer, int length, InetSocketAddress address) {
                DriverEventLogger.LOGGER.logFrameIn(buffer, 0, length, address);
            }
        }

        static class SendHook {
            SendHook() {
            }

            @Advice.OnMethodEnter
            static void sendHook(ByteBuffer buffer, InetSocketAddress address) {
                DriverEventLogger.LOGGER.logFrameOut(buffer, address);
            }
        }
    }

    static class ReceiverProxy {
        ReceiverProxy() {
        }

        static class CloseReceiveChannelEndpoint {
            CloseReceiveChannelEndpoint() {
            }

            @Advice.OnMethodEnter
            static void closeReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
                DriverEventLogger.LOGGER.logString(DriverEventCode.RECEIVE_CHANNEL_CLOSE, channelEndpoint.udpChannel().description());
            }
        }

        static class RegisterReceiveChannelEndpoint {
            RegisterReceiveChannelEndpoint() {
            }

            @Advice.OnMethodEnter
            static void registerReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
                DriverEventLogger.LOGGER.logString(DriverEventCode.RECEIVE_CHANNEL_CREATION, channelEndpoint.udpChannel().description());
            }
        }
    }

    static class SenderProxy {
        SenderProxy() {
        }

        static class CloseSendChannelEndpoint {
            CloseSendChannelEndpoint() {
            }

            @Advice.OnMethodEnter
            static void closeSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
                DriverEventLogger.LOGGER.logString(DriverEventCode.SEND_CHANNEL_CLOSE, channelEndpoint.udpChannel().description());
            }
        }

        static class RegisterSendChannelEndpoint {
            RegisterSendChannelEndpoint() {
            }

            @Advice.OnMethodEnter
            static void registerSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
                DriverEventLogger.LOGGER.logString(DriverEventCode.SEND_CHANNEL_CREATION, channelEndpoint.udpChannel().description());
            }
        }
    }
}

