/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.DriverEventLogger;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.SubscriptionLink;
import io.aeron.shadow.net.bytebuddy.asm.Advice;

class CleanupInterceptor {
    CleanupInterceptor() {
    }

    static class CleanupSubscriptionLink {
        CleanupSubscriptionLink() {
        }

        @Advice.OnMethodEnter
        static void cleanupSubscriptionLink(SubscriptionLink link) {
            DriverEventLogger.LOGGER.logSubscriptionRemoval(link.channel(), link.streamId(), link.registrationId());
        }
    }

    static class CleanupIpcPublication {
        CleanupIpcPublication() {
        }

        @Advice.OnMethodEnter
        static void cleanupIpcPublication(IpcPublication publication) {
            DriverEventLogger.LOGGER.logPublicationRemoval(publication.channel(), publication.sessionId(), publication.streamId());
        }
    }

    static class CleanupPublication {
        CleanupPublication() {
        }

        @Advice.OnMethodEnter
        static void cleanupPublication(NetworkPublication publication) {
            DriverEventLogger.LOGGER.logPublicationRemoval(publication.channel(), publication.sessionId(), publication.streamId());
        }
    }

    static class CleanupImage {
        CleanupImage() {
        }

        @Advice.OnMethodEnter
        static void cleanupImage(PublicationImage image) {
            DriverEventLogger.LOGGER.logImageRemoval(image.channel(), image.sessionId(), image.streamId(), image.correlationId());
        }
    }
}

