/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.agrona.Strings;

final class ConfigOption {
    static final String LOG_FILENAME = "aeron.event.log.filename";
    static final String READER_CLASSNAME = "aeron.event.log.reader.classname";
    static final String ENABLED_DRIVER_EVENT_CODES = "aeron.event.log";
    static final String DISABLED_DRIVER_EVENT_CODES = "aeron.event.log.disable";
    static final String ENABLED_ARCHIVE_EVENT_CODES = "aeron.event.archive.log";
    static final String DISABLED_ARCHIVE_EVENT_CODES = "aeron.event.archive.log.disable";
    static final String ENABLED_CLUSTER_EVENT_CODES = "aeron.event.cluster.log";
    static final String DISABLED_CLUSTER_EVENT_CODES = "aeron.event.cluster.log.disable";
    static final String START_COMMAND = "start";
    static final String STOP_COMMAND = "stop";
    private static final char VALUE_SEPARATOR = '=';
    private static final char OPTION_SEPARATOR = '|';

    ConfigOption() {
    }

    static Map<String, String> fromSystemProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    static String buildAgentArgs(Map<String, String> configOptions) {
        if (configOptions.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : configOptions.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append('|');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    static Map<String, String> parseAgentArgs(String agentArgs) {
        int valueIndex;
        if (Strings.isEmpty(agentArgs)) {
            throw new IllegalArgumentException("cannot parse empty value");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        int optionIndex = -1;
        while ((valueIndex = agentArgs.indexOf(61, optionIndex)) > 0) {
            int nameIndex = -1;
            while (optionIndex < valueIndex) {
                nameIndex = optionIndex;
                if ((optionIndex = agentArgs.indexOf(124, optionIndex + 1)) >= 0) continue;
            }
            String optionName = agentArgs.substring(nameIndex + 1, valueIndex);
            String value = agentArgs.substring(valueIndex + 1, optionIndex > 0 ? optionIndex : agentArgs.length());
            values.put(optionName, value);
            if (optionIndex > 0) continue;
        }
        return values;
    }
}

