/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ChannelEndpointInterceptor;
import io.aeron.agent.CleanupInterceptor;
import io.aeron.agent.CmdInterceptor;
import io.aeron.agent.ComponentLogger;
import io.aeron.agent.DriverEventCode;
import io.aeron.agent.DriverInterceptor;
import io.aeron.agent.EventCodeType;
import io.aeron.agent.EventConfiguration;
import io.aeron.shadow.net.bytebuddy.agent.builder.AgentBuilder;
import io.aeron.shadow.net.bytebuddy.asm.Advice;
import io.aeron.shadow.net.bytebuddy.matcher.ElementMatchers;
import java.util.EnumSet;
import java.util.Map;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Object2ObjectHashMap;

public class DriverComponentLogger
implements ComponentLogger {
    static final EnumSet<DriverEventCode> ENABLED_EVENTS = EnumSet.noneOf(DriverEventCode.class);
    private static final Object2ObjectHashMap<String, EnumSet<DriverEventCode>> SPECIAL_EVENTS = new Object2ObjectHashMap();

    @Override
    public int typeCode() {
        return EventCodeType.DRIVER.getTypeCode();
    }

    @Override
    public void decode(MutableDirectBuffer buffer, int offset, int eventCodeId, StringBuilder builder) {
        DriverEventCode.get(eventCodeId).decode(buffer, offset, builder);
    }

    @Override
    public AgentBuilder addInstrumentation(AgentBuilder agentBuilder, Map<String, String> configOptions) {
        ENABLED_EVENTS.clear();
        ENABLED_EVENTS.addAll(DriverComponentLogger.getDriverEventCodes(configOptions.get("aeron.event.log")));
        ENABLED_EVENTS.removeAll(DriverComponentLogger.getDriverEventCodes(configOptions.get("aeron.event.log.disable")));
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = DriverComponentLogger.addDriverConductorInstrumentation(tempBuilder);
        tempBuilder = DriverComponentLogger.addDriverCommandInstrumentation(tempBuilder);
        tempBuilder = DriverComponentLogger.addDriverSenderProxyInstrumentation(tempBuilder);
        tempBuilder = DriverComponentLogger.addDriverReceiverProxyInstrumentation(tempBuilder);
        tempBuilder = DriverComponentLogger.addDriverUdpChannelTransportInstrumentation(tempBuilder);
        tempBuilder = this.addChannelEndpointInstrumentation(tempBuilder);
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.UNTETHERED_SUBSCRIPTION_STATE_CHANGE, "UntetheredSubscription", DriverInterceptor.UntetheredSubscriptionStateChange.class, "logStateChange");
        tempBuilder = DriverComponentLogger.addDriverNameResolutionInstrumentation(tempBuilder);
        tempBuilder = DriverComponentLogger.addDriverFlowControlInstrumentation(tempBuilder);
        return tempBuilder;
    }

    @Override
    public void reset() {
        ENABLED_EVENTS.clear();
    }

    private static EnumSet<DriverEventCode> getDriverEventCodes(String enabledEventCodes) {
        return EventConfiguration.parseEventCodes(DriverEventCode.class, enabledEventCodes, SPECIAL_EVENTS, DriverEventCode::get, DriverEventCode::valueOf);
    }

    private static AgentBuilder addDriverConductorInstrumentation(AgentBuilder agentBuilder) {
        boolean hasImageHook = ENABLED_EVENTS.contains(DriverEventCode.REMOVE_IMAGE_CLEANUP);
        boolean hasPublicationHook = ENABLED_EVENTS.contains(DriverEventCode.REMOVE_PUBLICATION_CLEANUP);
        boolean hasSubscriptionHook = ENABLED_EVENTS.contains(DriverEventCode.REMOVE_SUBSCRIPTION_CLEANUP);
        if (!(hasImageHook || hasPublicationHook || hasSubscriptionHook)) {
            return agentBuilder;
        }
        return agentBuilder.type(ElementMatchers.nameEndsWith("DriverConductor")).transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> {
            if (hasImageHook) {
                builder = builder.visit(Advice.to(CleanupInterceptor.CleanupImage.class).on(ElementMatchers.named("cleanupImage")));
            }
            if (hasPublicationHook) {
                builder = builder.visit(Advice.to(CleanupInterceptor.CleanupPublication.class).on(ElementMatchers.named("cleanupPublication"))).visit(Advice.to(CleanupInterceptor.CleanupIpcPublication.class).on(ElementMatchers.named("cleanupIpcPublication")));
            }
            if (hasSubscriptionHook) {
                builder = builder.visit(Advice.to(CleanupInterceptor.CleanupSubscriptionLink.class).on(ElementMatchers.named("cleanupSubscriptionLink")));
            }
            return builder;
        });
    }

    private static AgentBuilder addDriverCommandInstrumentation(AgentBuilder agentBuilder) {
        if (CmdInterceptor.EVENTS.stream().noneMatch(ENABLED_EVENTS::contains)) {
            return agentBuilder;
        }
        return agentBuilder.type(ElementMatchers.nameEndsWith("ClientCommandAdapter")).transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> builder.visit(Advice.to(CmdInterceptor.class).on(ElementMatchers.named("onMessage")))).type(ElementMatchers.nameEndsWith("ClientProxy")).transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> builder.visit(Advice.to(CmdInterceptor.class).on(ElementMatchers.named("transmit"))));
    }

    private static AgentBuilder addDriverSenderProxyInstrumentation(AgentBuilder agentBuilder) {
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.SEND_CHANNEL_CREATION, "SenderProxy", ChannelEndpointInterceptor.SenderProxy.RegisterSendChannelEndpoint.class, "registerSendChannelEndpoint");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.SEND_CHANNEL_CLOSE, "SenderProxy", ChannelEndpointInterceptor.SenderProxy.CloseSendChannelEndpoint.class, "closeSendChannelEndpoint");
        return tempBuilder;
    }

    private static AgentBuilder addDriverReceiverProxyInstrumentation(AgentBuilder agentBuilder) {
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.RECEIVE_CHANNEL_CREATION, "ReceiverProxy", ChannelEndpointInterceptor.ReceiverProxy.RegisterReceiveChannelEndpoint.class, "registerReceiveChannelEndpoint");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.RECEIVE_CHANNEL_CLOSE, "ReceiverProxy", ChannelEndpointInterceptor.ReceiverProxy.CloseReceiveChannelEndpoint.class, "closeReceiveChannelEndpoint");
        return tempBuilder;
    }

    private static AgentBuilder addDriverUdpChannelTransportInstrumentation(AgentBuilder agentBuilder) {
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.FRAME_OUT, "UdpChannelTransport", ChannelEndpointInterceptor.UdpChannelTransport.SendHook.class, "sendHook");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.FRAME_IN, "UdpChannelTransport", ChannelEndpointInterceptor.UdpChannelTransport.ReceiveHook.class, "receiveHook");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.RESEND, "UdpChannelTransport", ChannelEndpointInterceptor.UdpChannelTransport.ResendHook.class, "resendHook");
        return tempBuilder;
    }

    private AgentBuilder addChannelEndpointInstrumentation(AgentBuilder agentBuilder) {
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.SEND_NAK_MESSAGE, "ReceiveChannelEndpoint", ChannelEndpointInterceptor.ReceiveChannelEndpointInterceptor.SendNakMessage.class, "sendNakMessage");
        return tempBuilder;
    }

    private static AgentBuilder addDriverNameResolutionInstrumentation(AgentBuilder agentBuilder) {
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.NAME_RESOLUTION_NEIGHBOR_ADDED, "Neighbor", DriverInterceptor.NameResolution.NeighborAdded.class, "neighborAdded");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.NAME_RESOLUTION_NEIGHBOR_REMOVED, "Neighbor", DriverInterceptor.NameResolution.NeighborRemoved.class, "neighborRemoved");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.NAME_RESOLUTION_RESOLVE, "TimeTrackingNameResolver", DriverInterceptor.NameResolution.Resolve.class, "logResolve");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.NAME_RESOLUTION_LOOKUP, "TimeTrackingNameResolver", DriverInterceptor.NameResolution.Lookup.class, "logLookup");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.NAME_RESOLUTION_HOST_NAME, "TimeTrackingNameResolver", DriverInterceptor.NameResolution.HostName.class, "logHostName");
        return tempBuilder;
    }

    private static AgentBuilder addDriverFlowControlInstrumentation(AgentBuilder agentBuilder) {
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.FLOW_CONTROL_RECEIVER_ADDED, "AbstractMinMulticastFlowControl", DriverInterceptor.FlowControl.ReceiverAdded.class, "receiverAdded");
        tempBuilder = DriverComponentLogger.addEventInstrumentation(tempBuilder, DriverEventCode.FLOW_CONTROL_RECEIVER_REMOVED, "AbstractMinMulticastFlowControl", DriverInterceptor.FlowControl.ReceiverRemoved.class, "receiverRemoved");
        return tempBuilder;
    }

    private static AgentBuilder addEventInstrumentation(AgentBuilder agentBuilder, DriverEventCode code, String typeName, Class<?> interceptorClass, String interceptorMethod) {
        if (!ENABLED_EVENTS.contains(code)) {
            return agentBuilder;
        }
        return agentBuilder.type(ElementMatchers.nameEndsWith(typeName)).transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> builder.visit(Advice.to(interceptorClass).on(ElementMatchers.named(interceptorMethod))));
    }

    static {
        SPECIAL_EVENTS.put("all", EnumSet.allOf(DriverEventCode.class));
        SPECIAL_EVENTS.put("admin", EnumSet.complementOf(EnumSet.of(DriverEventCode.FRAME_IN, DriverEventCode.FRAME_OUT)));
    }
}

