/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.CommonEventDissector;
import io.aeron.agent.CommonEventEncoder;
import io.aeron.agent.DriverEventCode;
import io.aeron.command.ClientTimeoutFlyweight;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.CounterUpdateFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.OperationSucceededFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.command.SubscriptionReadyFlyweight;
import io.aeron.command.TerminateDriverFlyweight;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.HeaderFlyweight;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.ResolutionEntryFlyweight;
import io.aeron.protocol.ResponseSetupFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

final class DriverEventDissector {
    private static final DataHeaderFlyweight DATA_HEADER = new DataHeaderFlyweight();
    private static final StatusMessageFlyweight SM_HEADER = new StatusMessageFlyweight();
    private static final NakFlyweight NAK_HEADER = new NakFlyweight();
    private static final SetupFlyweight SETUP_HEADER = new SetupFlyweight();
    private static final RttMeasurementFlyweight RTT_MEASUREMENT = new RttMeasurementFlyweight();
    private static final HeaderFlyweight HEADER = new HeaderFlyweight();
    private static final ResolutionEntryFlyweight RESOLUTION = new ResolutionEntryFlyweight();
    private static final ResponseSetupFlyweight RSP_SETUP = new ResponseSetupFlyweight();
    private static final PublicationMessageFlyweight PUB_MSG = new PublicationMessageFlyweight();
    private static final SubscriptionMessageFlyweight SUB_MSG = new SubscriptionMessageFlyweight();
    private static final PublicationBuffersReadyFlyweight PUB_READY = new PublicationBuffersReadyFlyweight();
    private static final ImageBuffersReadyFlyweight IMAGE_READY = new ImageBuffersReadyFlyweight();
    private static final CorrelatedMessageFlyweight CORRELATED_MSG = new CorrelatedMessageFlyweight();
    private static final ImageMessageFlyweight IMAGE_MSG = new ImageMessageFlyweight();
    private static final RemoveMessageFlyweight REMOVE_MSG = new RemoveMessageFlyweight();
    private static final DestinationMessageFlyweight DESTINATION_MSG = new DestinationMessageFlyweight();
    private static final ErrorResponseFlyweight ERROR_MSG = new ErrorResponseFlyweight();
    private static final CounterMessageFlyweight COUNTER_MSG = new CounterMessageFlyweight();
    private static final CounterUpdateFlyweight COUNTER_UPDATE = new CounterUpdateFlyweight();
    private static final OperationSucceededFlyweight OPERATION_SUCCEEDED = new OperationSucceededFlyweight();
    private static final SubscriptionReadyFlyweight SUBSCRIPTION_READY = new SubscriptionReadyFlyweight();
    private static final ClientTimeoutFlyweight CLIENT_TIMEOUT = new ClientTimeoutFlyweight();
    private static final TerminateDriverFlyweight TERMINATE_DRIVER = new TerminateDriverFlyweight();
    static final String CONTEXT = "DRIVER";

    private DriverEventDissector() {
    }

    static void dissectFrame(DriverEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int encodedLength = CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, offset, builder);
        builder.append(": address=");
        encodedLength += CommonEventDissector.dissectSocketAddress(buffer, offset + encodedLength, builder);
        builder.append(" ");
        int frameOffset = offset + encodedLength;
        int frameType = DriverEventDissector.frameType(buffer, frameOffset);
        switch (frameType) {
            case 0: 
            case 1: {
                DATA_HEADER.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                DriverEventDissector.dissectDataFrame(builder);
                break;
            }
            case 3: {
                SM_HEADER.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                DriverEventDissector.dissectStatusFrame(builder);
                break;
            }
            case 2: {
                NAK_HEADER.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                DriverEventDissector.dissectNakFrame(builder);
                break;
            }
            case 5: {
                SETUP_HEADER.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                DriverEventDissector.dissectSetupFrame(builder);
                break;
            }
            case 6: {
                RTT_MEASUREMENT.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                DriverEventDissector.dissectRttFrame(builder);
                break;
            }
            case 7: {
                DriverEventDissector.dissectResFrame(buffer, frameOffset, builder);
                break;
            }
            case 11: {
                RSP_SETUP.wrap(buffer, frameOffset, buffer.capacity() - frameOffset);
                DriverEventDissector.dissectRspSetupFrame(builder);
                break;
            }
            default: {
                builder.append("type=UNKNOWN(").append(frameType).append(")");
            }
        }
    }

    static void dissectCommand(DriverEventCode code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int encodedLength = CommonEventDissector.dissectLogHeader(CONTEXT, code, buffer, offset, builder);
        builder.append(": ");
        switch (code) {
            case CMD_IN_ADD_PUBLICATION: 
            case CMD_IN_ADD_EXCLUSIVE_PUBLICATION: {
                PUB_MSG.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectPublication(builder);
                break;
            }
            case CMD_IN_ADD_SUBSCRIPTION: {
                SUB_MSG.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectSubscription(builder);
                break;
            }
            case CMD_IN_REMOVE_PUBLICATION: 
            case CMD_IN_REMOVE_SUBSCRIPTION: 
            case CMD_IN_REMOVE_COUNTER: {
                REMOVE_MSG.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectRemoveEvent(builder);
                break;
            }
            case CMD_OUT_PUBLICATION_READY: 
            case CMD_OUT_EXCLUSIVE_PUBLICATION_READY: {
                PUB_READY.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectPublicationReady(builder);
                break;
            }
            case CMD_OUT_AVAILABLE_IMAGE: {
                IMAGE_READY.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectImageReady(builder);
                break;
            }
            case CMD_OUT_ON_OPERATION_SUCCESS: {
                OPERATION_SUCCEEDED.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectOperationSuccess(builder);
                break;
            }
            case CMD_IN_KEEPALIVE_CLIENT: 
            case CMD_IN_CLIENT_CLOSE: {
                CORRELATED_MSG.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectCorrelationEvent(builder);
                break;
            }
            case CMD_OUT_ON_UNAVAILABLE_IMAGE: {
                IMAGE_MSG.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectImage(builder);
                break;
            }
            case CMD_IN_ADD_DESTINATION: 
            case CMD_IN_REMOVE_DESTINATION: 
            case CMD_IN_ADD_RCV_DESTINATION: 
            case CMD_IN_REMOVE_RCV_DESTINATION: {
                DESTINATION_MSG.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectDestination(builder);
                break;
            }
            case CMD_OUT_ERROR: {
                ERROR_MSG.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectError(builder);
                break;
            }
            case CMD_IN_ADD_COUNTER: {
                COUNTER_MSG.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectCounter(builder);
                break;
            }
            case CMD_OUT_SUBSCRIPTION_READY: {
                SUBSCRIPTION_READY.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectSubscriptionReady(builder);
                break;
            }
            case CMD_OUT_COUNTER_READY: 
            case CMD_OUT_ON_UNAVAILABLE_COUNTER: {
                COUNTER_UPDATE.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectCounterUpdate(builder);
                break;
            }
            case CMD_OUT_ON_CLIENT_TIMEOUT: {
                CLIENT_TIMEOUT.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectClientTimeout(builder);
                break;
            }
            case CMD_IN_TERMINATE_DRIVER: {
                TERMINATE_DRIVER.wrap(buffer, offset + encodedLength);
                DriverEventDissector.dissectTerminateDriver(builder);
                break;
            }
            default: {
                builder.append("COMMAND_UNKNOWN: ").append(code);
            }
        }
    }

    static void dissectString(DriverEventCode code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int encodedLength = CommonEventDissector.dissectLogHeader(CONTEXT, code, buffer, offset, builder);
        builder.append(": ").append(buffer.getStringAscii(offset + encodedLength, ByteOrder.LITTLE_ENDIAN));
    }

    static void dissectRemovePublicationCleanup(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.REMOVE_PUBLICATION_CLEANUP, buffer, absoluteOffset, builder);
        builder.append(": sessionId=").append(buffer.getInt(absoluteOffset, ByteOrder.LITTLE_ENDIAN));
        builder.append(" streamId=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" channel=");
        buffer.getStringAscii(absoluteOffset += 4, builder);
    }

    static void dissectRemoveSubscriptionCleanup(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.REMOVE_SUBSCRIPTION_CLEANUP, buffer, absoluteOffset, builder);
        builder.append(": streamId=").append(buffer.getInt(absoluteOffset, ByteOrder.LITTLE_ENDIAN));
        builder.append(" id=").append(buffer.getLong(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" channel=");
        buffer.getStringAscii(absoluteOffset += 8, builder);
    }

    static void dissectRemoveImageCleanup(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.REMOVE_IMAGE_CLEANUP, buffer, absoluteOffset, builder);
        builder.append(": sessionId=").append(buffer.getInt(absoluteOffset, ByteOrder.LITTLE_ENDIAN));
        builder.append(" streamId=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" id=").append(buffer.getLong(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" channel=");
        buffer.getStringAscii(absoluteOffset += 8, builder);
    }

    static void dissectUntetheredSubscriptionStateChange(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.UNTETHERED_SUBSCRIPTION_STATE_CHANGE, buffer, absoluteOffset, builder);
        builder.append(": subscriptionId=").append(buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN));
        builder.append(" streamId=").append(buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN));
        builder.append(" sessionId=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" ");
        buffer.getStringAscii(absoluteOffset += 4, builder);
    }

    static void dissectAddress(DriverEventCode code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, code, buffer, absoluteOffset, builder);
        builder.append(": ");
        CommonEventDissector.dissectSocketAddress(buffer, absoluteOffset, builder);
    }

    static void dissectFlowControlReceiver(DriverEventCode code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, code, buffer, absoluteOffset, builder);
        builder.append(": receiverCount=").append(buffer.getInt(absoluteOffset, ByteOrder.LITTLE_ENDIAN));
        builder.append(" receiverId=").append(buffer.getLong(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" sessionId=").append(buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN));
        builder.append(" streamId=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" channel=");
        buffer.getStringAscii(absoluteOffset += 4, builder);
    }

    static void dissectResolve(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        boolean isReResolution = 1 == buffer.getByte(absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.NAME_RESOLUTION_RESOLVE, buffer, absoluteOffset, builder));
        long durationNs = buffer.getLong(++absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 8;
        builder.append(": resolver=");
        absoluteOffset += buffer.getStringAscii(absoluteOffset, builder);
        absoluteOffset += 4;
        builder.append(" durationNs=").append(durationNs);
        builder.append(" name=");
        absoluteOffset += buffer.getStringAscii(absoluteOffset, builder);
        builder.append(" isReResolution=").append(isReResolution);
        builder.append(" address=");
        CommonEventDissector.dissectInetAddress(buffer, absoluteOffset += 4, builder);
    }

    static void dissectLookup(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        boolean isReLookup = 1 == buffer.getByte(absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.NAME_RESOLUTION_LOOKUP, buffer, absoluteOffset, builder));
        long durationNs = buffer.getLong(++absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 8;
        builder.append(": resolver=");
        absoluteOffset += buffer.getStringAscii(absoluteOffset, builder);
        absoluteOffset += 4;
        builder.append(" durationNs=").append(durationNs);
        builder.append(" name=");
        absoluteOffset += buffer.getStringAscii(absoluteOffset, builder);
        builder.append(" isReLookup=").append(isReLookup);
        builder.append(" resolvedName=");
        buffer.getStringAscii(absoluteOffset += 4, builder);
    }

    static void dissectHostName(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.NAME_RESOLUTION_HOST_NAME, buffer, absoluteOffset, builder);
        builder.append(": durationNs=").append(buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN));
        builder.append(" hostName=");
        buffer.getStringAscii(absoluteOffset += 8, builder);
    }

    public static void dissectSendNak(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.SEND_NAK_MESSAGE, buffer, absoluteOffset, builder);
        builder.append(": address=");
        int encodedSocketLength = CommonEventDissector.dissectSocketAddress(buffer, absoluteOffset, builder);
        builder.append(" sessionId=").append(buffer.getInt(absoluteOffset += encodedSocketLength, ByteOrder.LITTLE_ENDIAN));
        builder.append(" streamId=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" termId=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" termOffset=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" length=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" channel=");
        buffer.getStringAscii(absoluteOffset += 4, builder);
    }

    public static void dissectResend(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, DriverEventCode.RESEND, buffer, absoluteOffset, builder);
        builder.append(": sessionId=").append(buffer.getInt(absoluteOffset, ByteOrder.LITTLE_ENDIAN));
        builder.append(" streamId=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" termId=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" termOffset=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" length=").append(buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN));
        builder.append(" channel=");
        buffer.getStringAscii(absoluteOffset += 4, builder);
    }

    static int frameType(MutableDirectBuffer buffer, int termOffset) {
        return buffer.getShort(FrameDescriptor.typeOffset(termOffset), ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    private static void dissectDataFrame(StringBuilder builder) {
        builder.append("type=").append(DATA_HEADER.headerType() == 0 ? "PAD" : "DATA").append(" flags=");
        HeaderFlyweight.appendFlagsAsChars(DATA_HEADER.flags(), builder);
        builder.append(" frameLength=").append(DATA_HEADER.frameLength()).append(" sessionId=").append(DATA_HEADER.sessionId()).append(" streamId=").append(DATA_HEADER.streamId()).append(" termId=").append(DATA_HEADER.termId()).append(" termOffset=").append(DATA_HEADER.termOffset());
    }

    private static void dissectStatusFrame(StringBuilder builder) {
        builder.append("type=SM flags=");
        HeaderFlyweight.appendFlagsAsChars(SM_HEADER.flags(), builder);
        builder.append(" frameLength=").append(SM_HEADER.frameLength()).append(" sessionId=").append(SM_HEADER.sessionId()).append(" streamId=").append(SM_HEADER.streamId()).append(" termId=").append(SM_HEADER.consumptionTermId()).append(" termOffset=").append(SM_HEADER.consumptionTermOffset()).append(" receiverWindowLength=").append(SM_HEADER.receiverWindowLength()).append(" receiverId=").append(SM_HEADER.receiverId());
    }

    private static void dissectNakFrame(StringBuilder builder) {
        builder.append("type=NAK flags=");
        HeaderFlyweight.appendFlagsAsChars(NAK_HEADER.flags(), builder);
        builder.append(" frameLength=").append(NAK_HEADER.frameLength()).append(" sessionId=").append(NAK_HEADER.sessionId()).append(" streamId=").append(NAK_HEADER.streamId()).append(" termId=").append(NAK_HEADER.termId()).append(" termOffset=").append(NAK_HEADER.termOffset()).append(" length=").append(NAK_HEADER.length());
    }

    private static void dissectSetupFrame(StringBuilder builder) {
        builder.append("type=SETUP flags=");
        HeaderFlyweight.appendFlagsAsChars(SETUP_HEADER.flags(), builder);
        builder.append(" frameLength=").append(SETUP_HEADER.frameLength()).append(" sessionId=").append(SETUP_HEADER.sessionId()).append(" streamId=").append(SETUP_HEADER.streamId()).append(" activeTermId=").append(SETUP_HEADER.activeTermId()).append(" initialTermId=").append(SETUP_HEADER.initialTermId()).append(" termOffset=").append(SETUP_HEADER.termOffset()).append(" termLength=").append(SETUP_HEADER.termLength()).append(" mtu=").append(SETUP_HEADER.mtuLength()).append(" ttl=").append(SETUP_HEADER.ttl());
    }

    private static void dissectRttFrame(StringBuilder builder) {
        builder.append("type=RTT flags=");
        HeaderFlyweight.appendFlagsAsChars(RTT_MEASUREMENT.flags(), builder);
        builder.append(" frameLength=").append(RTT_MEASUREMENT.frameLength()).append(" sessionId=").append(RTT_MEASUREMENT.sessionId()).append(" streamId=").append(RTT_MEASUREMENT.streamId()).append(" echoTimestampNs=").append(RTT_MEASUREMENT.echoTimestampNs()).append(" receptionDelta=").append(RTT_MEASUREMENT.receptionDelta()).append(" receiverId=").append(RTT_MEASUREMENT.receiverId());
    }

    private static void dissectResFrame(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int currentOffset = offset;
        HEADER.wrap(buffer, offset, buffer.capacity() - offset);
        int length = offset + Math.min(HEADER.frameLength(), CommonEventEncoder.MAX_CAPTURE_LENGTH);
        currentOffset += 8;
        builder.append("type=RES flags=");
        HeaderFlyweight.appendFlagsAsChars(HEADER.flags(), builder);
        builder.append(" frameLength=").append(HEADER.frameLength());
        while (length > currentOffset) {
            RESOLUTION.wrap(buffer, currentOffset, buffer.capacity() - currentOffset);
            if (length - offset < RESOLUTION.entryLength()) {
                builder.append(" ... ").append(length - offset).append(" bytes left");
                break;
            }
            DriverEventDissector.dissectResEntry(builder);
            currentOffset += RESOLUTION.entryLength();
        }
    }

    private static void dissectRspSetupFrame(StringBuilder builder) {
        builder.append("type=RSP_SETUP flags=");
        HeaderFlyweight.appendFlagsAsChars(RSP_SETUP.flags(), builder);
        builder.append(" frameLength=").append(RSP_SETUP.frameLength()).append(" sessionId=").append(RSP_SETUP.sessionId()).append(" streamId=").append(RSP_SETUP.streamId()).append(" responseSessionId=").append(RSP_SETUP.responseSessionId());
    }

    private static void dissectResEntry(StringBuilder builder) {
        builder.append(" [resType=").append(RESOLUTION.resType()).append(" flags=");
        HeaderFlyweight.appendFlagsAsChars(RESOLUTION.flags(), builder);
        builder.append(" port=").append(RESOLUTION.udpPort()).append(" ageInMs=").append(RESOLUTION.ageInMs());
        builder.append(" address=");
        RESOLUTION.appendAddress(builder);
        builder.append(" name=");
        RESOLUTION.appendName(builder);
        builder.append(']');
    }

    private static void dissectPublication(StringBuilder builder) {
        builder.append("streamId=").append(PUB_MSG.streamId()).append(" clientId=").append(PUB_MSG.clientId()).append(" correlationId=").append(PUB_MSG.correlationId()).append(" channel=");
        PUB_MSG.appendChannel(builder);
    }

    private static void dissectSubscription(StringBuilder builder) {
        builder.append("streamId=").append(SUB_MSG.streamId()).append(" registrationCorrelationId=").append(SUB_MSG.registrationCorrelationId()).append(" clientId=").append(SUB_MSG.clientId()).append(" correlationId=").append(SUB_MSG.correlationId()).append(" channel=");
        SUB_MSG.appendChannel(builder);
    }

    private static void dissectPublicationReady(StringBuilder builder) {
        builder.append("sessionId=").append(PUB_READY.sessionId()).append(" streamId=").append(PUB_READY.streamId()).append(" publicationLimitCounterId=").append(PUB_READY.publicationLimitCounterId()).append(" channelStatusCounterId=").append(PUB_READY.channelStatusCounterId()).append(" correlationId=").append(PUB_READY.correlationId()).append(" registrationId=").append(PUB_READY.registrationId()).append(" logFileName=");
        PUB_READY.appendLogFileName(builder);
    }

    private static void dissectImageReady(StringBuilder builder) {
        builder.append("sessionId=").append(IMAGE_READY.sessionId()).append(" streamId=").append(IMAGE_READY.streamId()).append(" subscriberPositionId=").append(IMAGE_READY.subscriberPositionId()).append(" subscriptionRegistrationId=").append(IMAGE_READY.subscriptionRegistrationId()).append(" correlationId=").append(IMAGE_READY.correlationId());
        builder.append(" sourceIdentity=");
        IMAGE_READY.appendSourceIdentity(builder);
        builder.append(" logFileName=");
        IMAGE_READY.appendLogFileName(builder);
    }

    private static void dissectCorrelationEvent(StringBuilder builder) {
        builder.append("clientId=").append(CORRELATED_MSG.clientId()).append(" correlationId=").append(CORRELATED_MSG.correlationId());
    }

    private static void dissectImage(StringBuilder builder) {
        builder.append("streamId=").append(IMAGE_MSG.streamId()).append(" correlationId=").append(IMAGE_MSG.correlationId()).append(" subscriptionRegistrationId=").append(IMAGE_MSG.subscriptionRegistrationId()).append(" channel=");
        IMAGE_MSG.appendChannel(builder);
    }

    private static void dissectRemoveEvent(StringBuilder builder) {
        builder.append("registrationId=").append(REMOVE_MSG.registrationId()).append(" clientId=").append(REMOVE_MSG.clientId()).append(" correlationId=").append(REMOVE_MSG.correlationId());
    }

    private static void dissectDestination(StringBuilder builder) {
        builder.append("registrationCorrelationId=").append(DESTINATION_MSG.registrationCorrelationId()).append(" clientId=").append(DESTINATION_MSG.clientId()).append(" correlationId=").append(DESTINATION_MSG.correlationId()).append(" channel=");
        DESTINATION_MSG.appendChannel(builder);
    }

    private static void dissectError(StringBuilder builder) {
        builder.append("offendingCommandCorrelationId=").append(ERROR_MSG.offendingCommandCorrelationId()).append(" errorCode=").append((Object)ERROR_MSG.errorCode()).append(" message=");
        ERROR_MSG.appendMessage(builder);
    }

    private static void dissectCounter(StringBuilder builder) {
        builder.append("typeId=").append(COUNTER_MSG.typeId()).append(" keyBufferOffset=").append(COUNTER_MSG.keyBufferOffset()).append(" keyBufferLength=").append(COUNTER_MSG.keyBufferLength()).append(" labelBufferOffset=").append(COUNTER_MSG.labelBufferOffset()).append(" labelBufferLength=").append(COUNTER_MSG.labelBufferLength()).append(" clientId=").append(COUNTER_MSG.clientId()).append(" correlationId=").append(COUNTER_MSG.correlationId());
    }

    private static void dissectCounterUpdate(StringBuilder builder) {
        builder.append("correlationId=").append(COUNTER_UPDATE.correlationId()).append(" counterId=").append(COUNTER_UPDATE.counterId());
    }

    private static void dissectOperationSuccess(StringBuilder builder) {
        builder.append("correlationId=").append(OPERATION_SUCCEEDED.correlationId());
    }

    private static void dissectSubscriptionReady(StringBuilder builder) {
        builder.append("correlationId=").append(SUBSCRIPTION_READY.correlationId()).append(" channelStatusCounterId=").append(SUBSCRIPTION_READY.channelStatusCounterId());
    }

    private static void dissectClientTimeout(StringBuilder builder) {
        builder.append("clientId=").append(CLIENT_TIMEOUT.clientId());
    }

    private static void dissectTerminateDriver(StringBuilder builder) {
        builder.append("clientId=").append(TERMINATE_DRIVER.clientId()).append(" tokenBufferLength=").append(TERMINATE_DRIVER.tokenBufferLength());
    }
}

