/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.CommonEventEncoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class DriverEventEncoder {
    private DriverEventEncoder() {
    }

    static void encode(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, ByteBuffer srcBuffer, int srcOffset, InetSocketAddress dstAddress) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int encodedSocketLength = CommonEventEncoder.encodeSocketAddress(encodingBuffer, offset + encodedLength, dstAddress);
        int bufferCaptureLength = captureLength - encodedSocketLength;
        encodingBuffer.putBytes(offset + (encodedLength += encodedSocketLength), srcBuffer, srcOffset, bufferCaptureLength);
    }

    static void encode(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, DirectBuffer srcBuffer, int srcOffset, InetSocketAddress dstAddress) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int encodedSocketLength = CommonEventEncoder.encodeSocketAddress(encodingBuffer, offset + encodedLength, dstAddress);
        int bufferCaptureLength = captureLength - encodedSocketLength;
        encodingBuffer.putBytes(offset + (encodedLength += encodedSocketLength), srcBuffer, srcOffset, bufferCaptureLength);
    }

    static void encode(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, DirectBuffer srcBuffer, int srcOffset, InetAddress dstAddress) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int encodedInetAddressLength = CommonEventEncoder.encodeInetAddress(encodingBuffer, offset + encodedLength, dstAddress);
        int bufferCaptureLength = captureLength - encodedInetAddressLength;
        encodingBuffer.putBytes(offset + (encodedLength += encodedInetAddressLength), srcBuffer, srcOffset, bufferCaptureLength);
    }

    public static void encode(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, String value) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, captureLength, value);
    }

    static void encode(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, InetSocketAddress address) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        CommonEventEncoder.encodeSocketAddress(encodingBuffer, offset + encodedLength, address);
    }

    static void encodePublicationRemoval(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, String channel, int sessionId, int streamId) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putInt(offset + encodedLength, sessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), streamId, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + (encodedLength += 4), captureLength - 8, channel);
    }

    static void encodeSubscriptionRemoval(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, String channel, int streamId, long id) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putInt(offset + encodedLength, streamId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 4), id, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + (encodedLength += 8), captureLength - 4 - 8, channel);
    }

    static void encodeImageRemoval(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, String channel, int sessionId, int streamId, long id) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putInt(offset + encodedLength, sessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), streamId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 4), id, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + (encodedLength += 8), captureLength - 8 - 8, channel);
    }

    static <E extends Enum<E>> int untetheredSubscriptionStateChangeLength(E from, E to) {
        return CommonEventEncoder.stateTransitionStringLength(from, to) + 8 + 8;
    }

    static <E extends Enum<E>> void encodeUntetheredSubscriptionStateChange(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, E from, E to, long subscriptionId, int streamId, int sessionId) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, subscriptionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 8), streamId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), sessionId, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingStateChange(encodingBuffer, offset, encodedLength += 4, captureLength, from, to);
    }

    static void encodeFlowControlReceiver(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, long receiverId, int sessionId, int streamId, String channel, int receiverCount) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putInt(offset + encodedLength, receiverCount, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 4), receiverId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 8), sessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), streamId, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + (encodedLength += 4), captureLength - 12 - 8, channel);
    }

    static void encodeResolve(UnsafeBuffer encodingBuffer, int offset, int length, int captureLength, String resolverName, long durationNs, String hostName, boolean isReResolution, InetAddress inetAddress) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putByte(offset + encodedLength, (byte)(isReResolution ? 1 : 0));
        encodingBuffer.putLong(offset + ++encodedLength, durationNs, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 8;
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, 260, resolverName);
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, 260, hostName);
        CommonEventEncoder.encodeInetAddress(encodingBuffer, offset + encodedLength, inetAddress);
    }

    static void encodeLookup(UnsafeBuffer encodingBuffer, int offset, int length, int captureLength, String resolverName, long durationNs, String name, boolean isReLookup, String resolvedName) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putByte(offset + encodedLength, (byte)(isReLookup ? 1 : 0));
        encodingBuffer.putLong(offset + ++encodedLength, durationNs, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 8;
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, 260, resolverName);
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, 260, name);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, 260, resolvedName);
    }

    static void encodeHostName(UnsafeBuffer encodingBuffer, int offset, int length, int captureLength, long durationNs, String hostName) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, durationNs, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 8;
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, 260, hostName);
    }

    static void encodeSendNakMessage(UnsafeBuffer encodingBuffer, int offset, int length, int captureLength, InetSocketAddress controlAddress, int sessionId, int streamId, int termId, int termOffset, int nakLength, String channel) {
        int headerLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + headerLength;
        int bodyLength = 0;
        int socketEncodedLength = CommonEventEncoder.encodeSocketAddress(encodingBuffer, bodyOffset + bodyLength, controlAddress);
        encodingBuffer.putInt(bodyOffset + (bodyLength += socketEncodedLength), sessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), streamId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), termId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), termOffset, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), nakLength, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, bodyOffset + (bodyLength += 4), captureLength - bodyLength, channel);
    }

    static void encodeResend(UnsafeBuffer encodingBuffer, int offset, int length, int captureLength, int sessionId, int streamId, int termId, int termOffset, int nakLength, String channel) {
        int headerLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + headerLength;
        int bodyLength = 0;
        encodingBuffer.putInt(bodyOffset + bodyLength, sessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), streamId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), termId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), termOffset, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), nakLength, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, bodyOffset + (bodyLength += 4), captureLength - bodyLength, channel);
    }
}

