/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ConfigOption;
import io.aeron.shadow.net.bytebuddy.agent.ByteBuddyAgent;
import java.io.File;
import java.nio.file.Paths;
import java.util.Map;
import org.agrona.PropertyAction;
import org.agrona.Strings;
import org.agrona.SystemUtil;

public class DynamicLoggingAgent {
    public static void main(String[] args) {
        String command;
        File agentJar;
        if (args.length < 3) {
            DynamicLoggingAgent.printHelp();
            System.exit(-1);
        }
        if (!(agentJar = Paths.get(args[0], new String[0]).toAbsolutePath().toFile()).exists()) {
            throw new IllegalArgumentException(agentJar + " does not exist!");
        }
        String processId = args[1];
        if (Strings.isEmpty(processId)) {
            throw new IllegalArgumentException("no PID provided!");
        }
        switch (command = args[2]) {
            case "start": {
                for (int i = 3; i < args.length; ++i) {
                    SystemUtil.loadPropertiesFile(PropertyAction.PRESERVE, args[i]);
                }
                Map<String, String> configOptions = ConfigOption.fromSystemProperties();
                String agentArgs = ConfigOption.buildAgentArgs(configOptions);
                DynamicLoggingAgent.attachAgent("start", agentJar, processId, agentArgs);
                System.out.println("Logging started.");
                break;
            }
            case "stop": {
                DynamicLoggingAgent.attachAgent("stop", agentJar, processId, command);
                System.out.println("Logging stopped.");
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid command: " + command);
            }
        }
    }

    private static void printHelp() {
        System.out.println("Usage: <agent-jar> <java-process-id> <command> [property files...]");
        System.out.println("  <agent-jar> - fully qualified path to the agent jar");
        System.out.println("  <java-process-id> - PID of the Java process to attach an agent to");
        System.out.println("  <command> - either 'start' or 'stop'");
        System.out.println("  [property files...] - an optional list of property files to configure logging options");
        System.out.println("Note: logging options can be specified either via system properties or the property files.");
    }

    private static void attachAgent(String command, File agentJar, String processId, String agentArgs) {
        try {
            ByteBuddyAgent.attach(agentJar, processId, agentArgs);
        }
        catch (Exception ex) {
            System.out.println("Command '" + command + "' failed, cause: " + DynamicLoggingAgent.getCause(ex));
            System.exit(-1);
        }
    }

    private static Throwable getCause(Throwable t) {
        Throwable cause = t;
        while (null != cause.getCause()) {
            cause = cause.getCause();
        }
        return cause;
    }
}

