/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.agrona.BufferUtil;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

final class EventConfiguration {
    static final String BUFFER_LENGTH_PROP_NAME = "aeron.event.buffer.length";
    static final int BUFFER_LENGTH_DEFAULT = 0x800000;
    static final int MAX_EVENT_LENGTH = 4096 - System.lineSeparator().length();
    static final int EVENT_READER_FRAME_LIMIT = 20;
    static final ManyToOneRingBuffer EVENT_RING_BUFFER = new ManyToOneRingBuffer(new UnsafeBuffer(BufferUtil.allocateDirectAligned(SystemUtil.getSizeAsInt("aeron.event.buffer.length", 0x800000) + RingBufferDescriptor.TRAILER_LENGTH, 64)));

    private EventConfiguration() {
    }

    static <E extends Enum<E>> EnumSet<E> parseEventCodes(Class<E> eventCodeType, String eventCodes, Map<String, EnumSet<E>> specialEvents, IntFunction<E> eventCodeById, Function<String, E> eventCodeByName) {
        String[] codeIds;
        if (Strings.isEmpty(eventCodes)) {
            return EnumSet.noneOf(eventCodeType);
        }
        EnumSet<E> eventCodeSet = EnumSet.noneOf(eventCodeType);
        for (String codeId : codeIds = eventCodes.split(",")) {
            EnumSet<E> specialCodes = specialEvents.get(codeId);
            if (null != specialCodes) {
                eventCodeSet.addAll(specialCodes);
                continue;
            }
            Enum code = null;
            try {
                code = (Enum)eventCodeByName.apply(codeId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (null == code) {
                try {
                    code = (Enum)eventCodeById.apply(Integer.parseInt(codeId));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (null != code) {
                eventCodeSet.add(code);
                continue;
            }
            System.err.println("unknown event code: " + codeId);
        }
        return eventCodeSet;
    }
}

