/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.AgentBuilderListener;
import io.aeron.agent.ComponentLogger;
import io.aeron.agent.ConfigOption;
import io.aeron.agent.EventConfiguration;
import io.aeron.shadow.net.bytebuddy.ByteBuddy;
import io.aeron.shadow.net.bytebuddy.agent.builder.AgentBuilder;
import io.aeron.shadow.net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import io.aeron.shadow.net.bytebuddy.dynamic.scaffold.TypeValidation;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.agrona.CloseHelper;
import org.agrona.Strings;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.SleepingMillisIdleStrategy;

public final class EventLogAgent {
    public static final String READER_CLASSNAME_PROP_NAME = "aeron.event.log.reader.classname";
    public static final String READER_CLASSNAME_DEFAULT = "io.aeron.agent.EventLogReaderAgent";
    private static final long SLEEP_PERIOD_MS = 1L;
    private static List<ComponentLogger> loggers;
    private static AgentRunner readerAgentRunner;
    private static Instrumentation instrumentation;
    private static ResettableClassFileTransformer logTransformer;
    private static Thread thread;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        EventLogAgent.startLogging(instrumentation, ConfigOption.fromSystemProperties());
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        if ("stop".equals(agentArgs)) {
            EventLogAgent.stopLogging();
        } else {
            Map<String, String> configOptions = Strings.isEmpty(agentArgs) ? ConfigOption.fromSystemProperties() : ConfigOption.parseAgentArgs(agentArgs);
            EventLogAgent.startLogging(instrumentation, configOptions);
        }
    }

    @Deprecated
    public static void removeTransformer() {
        EventLogAgent.stopLogging();
    }

    public static synchronized void stopLogging() {
        if (logTransformer != null) {
            logTransformer.reset(instrumentation, AgentBuilder.RedefinitionStrategy.RETRANSFORMATION);
            instrumentation = null;
            logTransformer = null;
            thread = null;
            for (ComponentLogger logger : loggers) {
                logger.reset();
            }
            loggers = null;
            EventConfiguration.EVENT_RING_BUFFER.unblock();
            CloseHelper.close(readerAgentRunner);
            readerAgentRunner = null;
        }
    }

    private static synchronized void startLogging(Instrumentation instrumentation, Map<String, String> configOptions) {
        AgentBuilder agentBuilder;
        if (null != logTransformer) {
            throw new IllegalStateException("agent already instrumented");
        }
        ArrayList<ComponentLogger> loggers = new ArrayList<ComponentLogger>();
        for (ComponentLogger componentLogger : ServiceLoader.load(ComponentLogger.class)) {
            loggers.add(componentLogger);
        }
        AgentBuilder.RedefinitionListenable initialAgentBuilder = agentBuilder = new AgentBuilder.Default(new ByteBuddy().with(TypeValidation.DISABLED)).disableClassFormatChanges().with(new AgentBuilderListener()).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE);
        for (ComponentLogger componentLogger : loggers) {
            agentBuilder = componentLogger.addInstrumentation(agentBuilder, configOptions);
        }
        if (initialAgentBuilder == agentBuilder) {
            return;
        }
        EventLogAgent.instrumentation = instrumentation;
        logTransformer = agentBuilder.installOn(instrumentation);
        EventLogAgent.loggers = loggers;
        readerAgentRunner = new AgentRunner(new SleepingMillisIdleStrategy(1L), Throwable::printStackTrace, null, EventLogAgent.newReaderAgent(configOptions, loggers));
        thread = new Thread(readerAgentRunner);
        thread.setName("event-log-reader");
        thread.setDaemon(true);
        thread.start();
    }

    private static Agent newReaderAgent(Map<String, String> configOptions, List<ComponentLogger> loggers) {
        try {
            Class<?> aClass = Class.forName(configOptions.getOrDefault(READER_CLASSNAME_PROP_NAME, READER_CLASSNAME_DEFAULT));
            try {
                Constructor<?> constructor = aClass.getDeclaredConstructor(String.class, List.class);
                return (Agent)constructor.newInstance(configOptions.get("aeron.event.log.filename"), loggers);
            }
            catch (NoSuchMethodException ex) {
                try {
                    Constructor<?> constructor = aClass.getDeclaredConstructor(String.class);
                    return (Agent)constructor.newInstance(configOptions.get("aeron.event.log.filename"));
                }
                catch (NoSuchMethodException ex2) {
                    return (Agent)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

