/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.CommonEventDissector;
import io.aeron.agent.ComponentLogger;
import io.aeron.agent.EventConfiguration;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.ZoneId;
import java.util.List;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public final class EventLogReaderAgent
implements Agent {
    public static final String LOG_FILENAME_PROP_NAME = "aeron.event.log.filename";
    private final ManyToOneRingBuffer ringBuffer = EventConfiguration.EVENT_RING_BUFFER;
    private final StringBuilder builder = new StringBuilder(EventConfiguration.MAX_EVENT_LENGTH);
    private final MessageHandler messageHandler = this::onMessage;
    private final ByteBuffer byteBuffer;
    private final FileChannel fileChannel;
    private final Int2ObjectHashMap<ComponentLogger> loggers = new Int2ObjectHashMap();

    EventLogReaderAgent(String filename, List<ComponentLogger> loggers) {
        for (ComponentLogger componentLogger : loggers) {
            this.loggers.put(componentLogger.typeCode(), componentLogger);
        }
        if (null != filename) {
            try {
                this.fileChannel = FileChannel.open(Paths.get(filename, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            this.byteBuffer = BufferUtil.allocateDirectAligned(EventConfiguration.MAX_EVENT_LENGTH * 2, 64);
        } else {
            this.fileChannel = null;
            this.byteBuffer = null;
        }
    }

    @Override
    public void onStart() {
        CommonEventDissector.dissectLogStartMessage(System.nanoTime(), System.currentTimeMillis(), ZoneId.systemDefault(), this.builder);
        this.builder.append(System.lineSeparator());
        if (null == this.fileChannel) {
            System.out.print(this.builder);
        } else {
            EventLogReaderAgent.appendEvent(this.builder, this.byteBuffer, this.fileChannel);
            EventLogReaderAgent.write(this.byteBuffer, this.fileChannel);
        }
    }

    @Override
    public void onClose() {
        CloseHelper.close(this.fileChannel);
    }

    @Override
    public String roleName() {
        return "event-log-reader";
    }

    @Override
    public int doWork() {
        int eventsRead = this.ringBuffer.read(this.messageHandler, 20);
        if (null != this.byteBuffer && this.byteBuffer.position() > 0) {
            EventLogReaderAgent.write(this.byteBuffer, this.fileChannel);
        }
        return eventsRead;
    }

    private void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        int eventCodeTypeId = msgTypeId >> 16;
        int eventCodeId = msgTypeId & 0xFFFF;
        this.builder.setLength(0);
        EventLogReaderAgent.decodeLogEvent(buffer, index, eventCodeTypeId, eventCodeId, this.loggers, this.builder);
        if (null == this.fileChannel) {
            System.out.print(this.builder);
        } else {
            EventLogReaderAgent.appendEvent(this.builder, this.byteBuffer, this.fileChannel);
        }
    }

    static void decodeLogEvent(MutableDirectBuffer buffer, int index, int eventCodeTypeId, int eventCodeId, Int2ObjectHashMap<ComponentLogger> loggers, StringBuilder builder) {
        ComponentLogger componentLogger = loggers.get(eventCodeTypeId);
        if (null != componentLogger) {
            componentLogger.decode(buffer, index, eventCodeId, builder);
        } else {
            builder.append("Unknown EventCodeType: ").append(eventCodeTypeId);
        }
        builder.append(System.lineSeparator());
    }

    private static void appendEvent(StringBuilder builder, ByteBuffer buffer, FileChannel fileChannel) {
        int length = builder.length();
        if (buffer.position() + length > buffer.capacity()) {
            EventLogReaderAgent.write(buffer, fileChannel);
        }
        int position = buffer.position();
        int i = 0;
        int p = position;
        while (i < length) {
            buffer.put(p, (byte)builder.charAt(i));
            ++i;
            ++p;
        }
        buffer.position(position + length);
    }

    private static void write(ByteBuffer buffer, FileChannel fileChannel) {
        try {
            buffer.flip();
            do {
                fileChannel.write(buffer);
            } while (buffer.remaining() > 0);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        finally {
            buffer.clear();
        }
    }
}

