/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ReplicationParams;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.archive.status.RecordingPos;
import io.aeron.cluster.client.ClusterException;
import io.aeron.exceptions.AeronException;
import org.agrona.concurrent.status.CountersReader;

final class RecordingReplication
implements AutoCloseable {
    private final long replicationId;
    private final long stopPosition;
    private final long progressCheckTimeoutNs;
    private final long progressCheckIntervalNs;
    private final String srcArchiveChannel;
    private int recordingPositionCounterId = -1;
    private long recordingId = -1L;
    private long position = -1L;
    private long progressDeadlineNs;
    private long progressCheckDeadlineNs;
    private final AeronArchive archive;
    private RecordingSignal lastRecordingSignal = RecordingSignal.NULL_VAL;
    private boolean hasReplicationEnded = false;
    private boolean hasSynced = false;
    private boolean hasStopped = false;

    RecordingReplication(AeronArchive archive, long srcRecordingId, String srcArchiveChannel, int srcControlStreamId, ReplicationParams replicationParams, long progressCheckTimeoutNs, long progressCheckIntervalNs, long nowNs) {
        this.archive = archive;
        this.stopPosition = replicationParams.stopPosition();
        this.progressCheckTimeoutNs = progressCheckTimeoutNs;
        this.progressCheckIntervalNs = progressCheckIntervalNs;
        this.progressDeadlineNs = nowNs + progressCheckTimeoutNs;
        this.progressCheckDeadlineNs = nowNs + progressCheckIntervalNs;
        this.srcArchiveChannel = srcArchiveChannel;
        this.replicationId = archive.replicate(srcRecordingId, srcControlStreamId, srcArchiveChannel, replicationParams);
    }

    int poll(long nowNs) {
        int workCount = 0;
        if (this.hasReplicationEnded) {
            return workCount;
        }
        try {
            if (nowNs >= this.progressCheckDeadlineNs) {
                this.progressCheckDeadlineNs = nowNs + this.progressCheckIntervalNs;
                if (this.pollDstRecordingPosition()) {
                    this.progressDeadlineNs = nowNs + this.progressCheckTimeoutNs;
                }
                ++workCount;
            }
            if (nowNs >= this.progressDeadlineNs) {
                if (-1L == this.stopPosition || this.position < this.stopPosition) {
                    throw new ClusterException("log replication has not progressed", AeronException.Category.WARN);
                }
                throw new ClusterException("log replication failed to stop");
            }
            return workCount;
        }
        catch (ClusterException ex) {
            try {
                this.close();
            }
            catch (ClusterException ex1) {
                ex.addSuppressed(ex1);
            }
            throw ex;
        }
    }

    long position() {
        return this.position;
    }

    long recordingId() {
        return this.recordingId;
    }

    boolean hasReplicationEnded() {
        return this.hasReplicationEnded;
    }

    boolean hasSynced() {
        return this.hasSynced;
    }

    boolean hasStopped() {
        return this.hasStopped;
    }

    @Override
    public void close() {
        if (!this.hasReplicationEnded) {
            try {
                this.hasReplicationEnded = true;
                this.archive.tryStopReplication(this.replicationId);
            }
            catch (Exception ex) {
                throw new ClusterException("failed to stop log replication", ex, AeronException.Category.WARN);
            }
        }
    }

    void onSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        if (correlationId == this.replicationId) {
            if (RecordingSignal.EXTEND == signal) {
                CountersReader counters = this.archive.context().aeron().countersReader();
                this.recordingPositionCounterId = RecordingPos.findCounterIdByRecording(counters, recordingId, this.archive.archiveId());
            } else if (RecordingSignal.SYNC == signal) {
                this.hasSynced = true;
            } else if (RecordingSignal.REPLICATE_END == signal) {
                this.hasReplicationEnded = true;
            } else if (RecordingSignal.STOP == signal) {
                if (-1L != position) {
                    this.position = position;
                }
                this.hasStopped = true;
            } else if (RecordingSignal.DELETE == signal) {
                throw new ClusterException("recording was deleted during replication: " + this);
            }
            this.lastRecordingSignal = signal;
            if (-1L != recordingId) {
                this.recordingId = recordingId;
            }
            if (-1L != position) {
                this.position = position;
            }
        }
    }

    private boolean pollDstRecordingPosition() {
        if (-1 != this.recordingPositionCounterId) {
            CountersReader counters = this.archive.context().aeron().countersReader();
            long recordingPosition = counters.getCounterValue(this.recordingPositionCounterId);
            if (RecordingPos.isActive(counters, this.recordingPositionCounterId, this.recordingId) && recordingPosition > this.position) {
                this.position = recordingPosition;
                return true;
            }
        }
        return false;
    }

    String srcArchiveChannel() {
        return this.srcArchiveChannel;
    }

    public String toString() {
        return "RecordingReplication{replicationId=" + this.replicationId + ", stopPosition=" + this.stopPosition + ", progressCheckTimeoutNs=" + this.progressCheckTimeoutNs + ", progressCheckIntervalNs=" + this.progressCheckIntervalNs + ", recordingPositionCounterId=" + this.recordingPositionCounterId + ", recordingId=" + this.recordingId + ", position=" + this.position + ", progressDeadlineNs=" + this.progressDeadlineNs + ", progressCheckDeadlineNs=" + this.progressCheckDeadlineNs + ", lastRecordingSignal=" + (Object)((Object)this.lastRecordingSignal) + ", hasReplicationEnded=" + this.hasReplicationEnded + ", hasSynced=" + this.hasSynced + ", hasStopped=" + this.hasStopped + '}';
    }
}

