/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControlSupplier;
import io.aeron.driver.DefaultNameResolver;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.NameResolver;
import io.aeron.driver.OptimalMulticastDelayGenerator;
import io.aeron.driver.ReceiveChannelEndpointSupplier;
import io.aeron.driver.Receiver;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.SendChannelEndpointSupplier;
import io.aeron.driver.Sender;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.StaticDelayGenerator;
import io.aeron.driver.TerminationValidator;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.buffer.FileStoreLogFactory;
import io.aeron.driver.buffer.LogFactory;
import io.aeron.driver.exceptions.ActiveDriverException;
import io.aeron.driver.media.ControlTransportPoller;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.PortManager;
import io.aeron.driver.media.ReceiveChannelEndpointThreadLocals;
import io.aeron.driver.media.WildcardPortManager;
import io.aeron.driver.reports.LossReport;
import io.aeron.driver.reports.LossReportUtil;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemEpochNanoClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.ConcurrentCountersManager;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.UnsafeBufferStatusIndicator;

public final class MediaDriver
implements AutoCloseable {
    private boolean wasHighResTimerEnabled;
    private final AgentRunner sharedRunner;
    private final AgentRunner sharedNetworkRunner;
    private final AgentRunner conductorRunner;
    private final AgentRunner receiverRunner;
    private final AgentRunner senderRunner;
    private final AgentInvoker sharedInvoker;
    private final Context ctx;

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles(args);
        ShutdownSignalBarrier barrier = new ShutdownSignalBarrier();
        Context ctx = new Context().terminationHook(barrier::signal);
        try (MediaDriver ignore = MediaDriver.launch(ctx);){
            barrier.await();
            System.out.println("Shutdown Driver...");
        }
    }

    private MediaDriver(Context ctx) {
        ctx.concludeAeronDirectory();
        MediaDriver.ensureDirectoryIsRecreated(ctx);
        Configuration.validateSocketBufferLengths(ctx);
        try {
            ctx.conclude();
            this.ctx = ctx;
            DriverConductor conductor = new DriverConductor(ctx);
            Receiver receiver = new Receiver(ctx);
            Sender sender = new Sender(ctx);
            ctx.receiverProxy().receiver(receiver);
            ctx.senderProxy().sender(sender);
            ctx.driverConductorProxy().driverConductor(conductor);
            AtomicCounter errorCounter = ctx.systemCounters().get(SystemCounterDescriptor.ERRORS);
            ErrorHandler errorHandler = ctx.errorHandler();
            switch (ctx.threadingMode()) {
                case INVOKER: {
                    this.sharedInvoker = new AgentInvoker(errorHandler, errorCounter, new CompositeAgent(sender, receiver, conductor));
                    this.sharedRunner = null;
                    this.sharedNetworkRunner = null;
                    this.conductorRunner = null;
                    this.receiverRunner = null;
                    this.senderRunner = null;
                    break;
                }
                case SHARED: {
                    this.sharedRunner = new AgentRunner(ctx.sharedIdleStrategy(), errorHandler, errorCounter, new CompositeAgent(sender, receiver, conductor));
                    this.sharedNetworkRunner = null;
                    this.conductorRunner = null;
                    this.receiverRunner = null;
                    this.senderRunner = null;
                    this.sharedInvoker = null;
                    break;
                }
                case SHARED_NETWORK: {
                    this.sharedNetworkRunner = new AgentRunner(ctx.sharedNetworkIdleStrategy(), errorHandler, errorCounter, new CompositeAgent(sender, receiver));
                    this.conductorRunner = new AgentRunner(ctx.conductorIdleStrategy(), errorHandler, errorCounter, conductor);
                    this.sharedRunner = null;
                    this.receiverRunner = null;
                    this.senderRunner = null;
                    this.sharedInvoker = null;
                    break;
                }
                default: {
                    this.senderRunner = new AgentRunner(ctx.senderIdleStrategy(), errorHandler, errorCounter, sender);
                    this.receiverRunner = new AgentRunner(ctx.receiverIdleStrategy(), errorHandler, errorCounter, receiver);
                    this.conductorRunner = new AgentRunner(ctx.conductorIdleStrategy(), errorHandler, errorCounter, conductor);
                    this.sharedNetworkRunner = null;
                    this.sharedRunner = null;
                    this.sharedInvoker = null;
                    break;
                }
            }
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static MediaDriver launchEmbedded() {
        return MediaDriver.launchEmbedded(new Context());
    }

    public static MediaDriver launchEmbedded(Context ctx) {
        if (CommonContext.AERON_DIR_PROP_DEFAULT.equals(ctx.aeronDirectoryName())) {
            ctx.aeronDirectoryName(CommonContext.generateRandomDirName());
        }
        return MediaDriver.launch(ctx);
    }

    public static MediaDriver launch() {
        return MediaDriver.launch(new Context());
    }

    public static MediaDriver launch(Context ctx) {
        MediaDriver mediaDriver = new MediaDriver(ctx);
        if (ctx.useWindowsHighResTimer() && SystemUtil.isWindows()) {
            mediaDriver.wasHighResTimerEnabled = HighResolutionTimer.isEnabled();
            if (!mediaDriver.wasHighResTimerEnabled) {
                HighResolutionTimer.enable();
            }
        }
        if (null != mediaDriver.conductorRunner) {
            AgentRunner.startOnThread(mediaDriver.conductorRunner, ctx.conductorThreadFactory());
        }
        if (null != mediaDriver.senderRunner) {
            AgentRunner.startOnThread(mediaDriver.senderRunner, ctx.senderThreadFactory());
        }
        if (null != mediaDriver.receiverRunner) {
            AgentRunner.startOnThread(mediaDriver.receiverRunner, ctx.receiverThreadFactory());
        }
        if (null != mediaDriver.sharedNetworkRunner) {
            AgentRunner.startOnThread(mediaDriver.sharedNetworkRunner, ctx.sharedNetworkThreadFactory());
        }
        if (null != mediaDriver.sharedRunner) {
            AgentRunner.startOnThread(mediaDriver.sharedRunner, ctx.sharedThreadFactory());
        }
        if (null != mediaDriver.sharedInvoker) {
            mediaDriver.sharedInvoker.start();
        }
        return mediaDriver;
    }

    public Context context() {
        return this.ctx;
    }

    public AgentInvoker sharedAgentInvoker() {
        return this.sharedInvoker;
    }

    @Override
    public void close() {
        try {
            CloseHelper.closeAll(this.sharedRunner, this.sharedNetworkRunner, this.receiverRunner, this.senderRunner, this.conductorRunner, this.sharedInvoker);
        }
        finally {
            if (this.ctx.useWindowsHighResTimer() && SystemUtil.isWindows() && !this.wasHighResTimerEnabled) {
                HighResolutionTimer.disable();
            }
        }
    }

    public String aeronDirectoryName() {
        return this.ctx.aeronDirectoryName();
    }

    private static void ensureDirectoryIsRecreated(Context ctx) {
        if (ctx.aeronDirectory().isDirectory()) {
            if (ctx.warnIfDirectoryExists()) {
                System.err.println("WARNING: " + ctx.aeronDirectory() + " exists");
            }
            if (!ctx.dirDeleteOnStart()) {
                Consumer<String> logger = ctx.warnIfDirectoryExists() ? System.err::println : s -> {};
                MappedByteBuffer cncByteBuffer = ctx.mapExistingCncFile(logger);
                try {
                    if (CommonContext.isDriverActive(ctx.driverTimeoutMs(), logger, cncByteBuffer)) {
                        throw new ActiveDriverException("active driver detected");
                    }
                    MediaDriver.reportExistingErrors(ctx, cncByteBuffer);
                }
                finally {
                    BufferUtil.free(cncByteBuffer);
                }
            }
            ctx.deleteDirectory();
        }
        IoUtil.ensureDirectoryExists(ctx.aeronDirectory(), "aeron");
    }

    private static void reportExistingErrors(Context ctx, MappedByteBuffer cncByteBuffer) {
        block14: {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int observations = ctx.saveErrorLog(new PrintStream((OutputStream)baos, false, "US-ASCII"), cncByteBuffer);
                if (observations <= 0) break block14;
                StringBuilder builder = new StringBuilder(ctx.aeronDirectoryName());
                IoUtil.removeTrailingSlashes(builder);
                SimpleDateFormat dateFormat = new SimpleDateFormat("-yyyy-MM-dd-HH-mm-ss-SSSZ");
                builder.append(dateFormat.format(new Date())).append("-error.log");
                String errorLogFilename = builder.toString();
                System.err.println("WARNING: Existing errors saved to: " + errorLogFilename);
                try (FileOutputStream out = new FileOutputStream(errorLogFilename);){
                    baos.writeTo(out);
                }
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
            }
        }
    }

    public static final class Context
    extends CommonContext {
        private static final AtomicIntegerFieldUpdater<Context> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isClosed");
        private volatile int isClosed;
        private boolean printConfigurationOnStart = Configuration.printConfigurationOnStart();
        private boolean useWindowsHighResTimer = Configuration.useWindowsHighResTimer();
        private boolean warnIfDirectoryExists = Configuration.warnIfDirExists();
        private boolean dirDeleteOnStart = Configuration.dirDeleteOnStart();
        private boolean dirDeleteOnShutdown = Configuration.dirDeleteOnShutdown();
        private boolean termBufferSparseFile = Configuration.termBufferSparseFile();
        private boolean performStorageChecks = Configuration.performStorageChecks();
        private boolean spiesSimulateConnection = Configuration.spiesSimulateConnection();
        private boolean reliableStream = Configuration.reliableStream();
        private boolean tetherSubscriptions = Configuration.tetherSubscriptions();
        private boolean rejoinStream = Configuration.rejoinStream();
        private long lowStorageWarningThreshold = Configuration.lowStorageWarningThreshold();
        private long timerIntervalNs = Configuration.timerIntervalNs();
        private long clientLivenessTimeoutNs = Configuration.clientLivenessTimeoutNs();
        private long imageLivenessTimeoutNs = Configuration.imageLivenessTimeoutNs();
        private long publicationUnblockTimeoutNs = Configuration.publicationUnblockTimeoutNs();
        private long publicationConnectionTimeoutNs = Configuration.publicationConnectionTimeoutNs();
        private long publicationLingerTimeoutNs = Configuration.publicationLingerTimeoutNs();
        private long untetheredWindowLimitTimeoutNs = Configuration.untetheredWindowLimitTimeoutNs();
        private long untetheredRestingTimeoutNs = Configuration.untetheredRestingTimeoutNs();
        private long statusMessageTimeoutNs = Configuration.statusMessageTimeoutNs();
        private long counterFreeToReuseTimeoutNs = Configuration.counterFreeToReuseTimeoutNs();
        private long retransmitUnicastDelayNs = Configuration.retransmitUnicastDelayNs();
        private long retransmitUnicastLingerNs = Configuration.retransmitUnicastLingerNs();
        private long nakUnicastDelayNs = Configuration.nakUnicastDelayNs();
        private long nakUnicastRetryDelayRatio = Configuration.nakUnicastRetryDelayRatio();
        private long nakMulticastMaxBackoffNs = Configuration.nakMulticastMaxBackoffNs();
        private long flowControlReceiverTimeoutNs = Configuration.flowControlReceiverTimeoutNs();
        private long reResolutionCheckIntervalNs = Configuration.reResolutionCheckIntervalNs();
        private long conductorCycleThresholdNs = Configuration.conductorCycleThresholdNs();
        private long senderCycleThresholdNs = Configuration.senderCycleThresholdNs();
        private long receiverCycleThresholdNs = Configuration.receiverCycleThresholdNs();
        private long nameResolverThresholdNs = Configuration.nameResolverThresholdNs();
        private int conductorBufferLength = Configuration.conductorBufferLength();
        private int toClientsBufferLength = Configuration.toClientsBufferLength();
        private int counterValuesBufferLength = Configuration.counterValuesBufferLength();
        private int errorBufferLength = Configuration.errorBufferLength();
        private int nakMulticastGroupSize = Configuration.nakMulticastGroupSize();
        private int publicationTermBufferLength = Configuration.termBufferLength();
        private int ipcTermBufferLength = Configuration.ipcTermBufferLength();
        private int publicationTermWindowLength = Configuration.publicationTermWindowLength();
        private int ipcPublicationTermWindowLength = Configuration.ipcPublicationTermWindowLength();
        private int initialWindowLength = Configuration.initialWindowLength();
        private int socketSndbufLength = Configuration.socketSndbufLength();
        private int socketRcvbufLength = Configuration.socketRcvbufLength();
        private int socketMulticastTtl = Configuration.socketMulticastTtl();
        private int mtuLength = Configuration.mtuLength();
        private int ipcMtuLength = Configuration.ipcMtuLength();
        private int filePageSize = Configuration.filePageSize();
        private int publicationReservedSessionIdLow = Configuration.publicationReservedSessionIdLow();
        private int publicationReservedSessionIdHigh = Configuration.publicationReservedSessionIdHigh();
        private int lossReportBufferLength = Configuration.lossReportBufferLength();
        private int sendToStatusMessagePollRatio = Configuration.sendToStatusMessagePollRatio();
        private int resourceFreeLimit = Configuration.resourceFreeLimit();
        private int asyncTaskExecutorThreads = Configuration.asyncTaskExecutorThreads();
        private int maxResend = Configuration.maxResend();
        private Long receiverGroupTag = Configuration.groupTag();
        private long flowControlGroupTag = Configuration.flowControlGroupTag();
        private int flowControlGroupMinSize = Configuration.flowControlGroupMinSize();
        private CommonContext.InferableBoolean receiverGroupConsideration = Configuration.receiverGroupConsideration();
        private String resolverName = Configuration.resolverName();
        private String resolverInterface = Configuration.resolverInterface();
        private String resolverBootstrapNeighbor = Configuration.resolverBootstrapNeighbor();
        private String senderWildcardPortRange = Configuration.senderWildcardPortRange();
        private String receiverWildcardPortRange = Configuration.receiverWildcardPortRange();
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private CachedEpochClock cachedEpochClock;
        private CachedNanoClock cachedNanoClock;
        private CachedNanoClock senderCachedNanoClock;
        private CachedNanoClock receiverCachedNanoClock;
        private ThreadingMode threadingMode;
        private ThreadFactory conductorThreadFactory;
        private ThreadFactory senderThreadFactory;
        private ThreadFactory receiverThreadFactory;
        private ThreadFactory sharedThreadFactory;
        private ThreadFactory sharedNetworkThreadFactory;
        private Executor asyncTaskExecutor;
        private IdleStrategy conductorIdleStrategy;
        private IdleStrategy senderIdleStrategy;
        private IdleStrategy receiverIdleStrategy;
        private IdleStrategy sharedNetworkIdleStrategy;
        private IdleStrategy sharedIdleStrategy;
        private SendChannelEndpointSupplier sendChannelEndpointSupplier;
        private ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier;
        private ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals;
        private MutableDirectBuffer tempBuffer;
        private FlowControlSupplier unicastFlowControlSupplier;
        private FlowControlSupplier multicastFlowControlSupplier;
        private byte[] applicationSpecificFeedback;
        private CongestionControlSupplier congestionControlSupplier;
        private FeedbackDelayGenerator unicastFeedbackDelayGenerator;
        private FeedbackDelayGenerator multicastFeedbackDelayGenerator;
        private FeedbackDelayGenerator retransmitUnicastDelayGenerator;
        private FeedbackDelayGenerator retransmitUnicastLingerGenerator;
        private TerminationValidator terminationValidator;
        private Runnable terminationHook;
        private NameResolver nameResolver;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private boolean useConcurrentCountersManager;
        private CountersManager countersManager;
        private SystemCounters systemCounters;
        private LossReport lossReport;
        private LogFactory logFactory;
        private DataTransportPoller dataTransportPoller;
        private ControlTransportPoller controlTransportPoller;
        private ManyToOneConcurrentLinkedQueue<Runnable> driverCommandQueue;
        private OneToOneConcurrentArrayQueue<Runnable> receiverCommandQueue;
        private OneToOneConcurrentArrayQueue<Runnable> senderCommandQueue;
        private ReceiverProxy receiverProxy;
        private SenderProxy senderProxy;
        private DriverConductorProxy driverConductorProxy;
        private ClientProxy clientProxy;
        private RingBuffer toDriverCommands;
        private MappedByteBuffer lossReportBuffer;
        private MappedByteBuffer cncByteBuffer;
        private UnsafeBuffer cncMetaDataBuffer;
        private int osDefaultSocketRcvbufLength = -1;
        private int osMaxSocketRcvbufLength = -1;
        private int osDefaultSocketSndbufLength = -1;
        private int osMaxSocketSndbufLength = -1;
        private EpochNanoClock channelReceiveTimestampClock;
        private EpochNanoClock channelSendTimestampClock;
        private DutyCycleTracker conductorDutyCycleTracker;
        private DutyCycleTracker senderDutyCycleTracker;
        private DutyCycleTracker receiverDutyCycleTracker;
        private DutyCycleTracker nameResolverTimeTracker;
        private PortManager senderPortManager;
        private PortManager receiverPortManager;
        private int streamSessionLimit = Configuration.streamSessionLimit();

        @Override
        public Context clone() {
            return (Context)super.clone();
        }

        @Override
        public void close() {
            if (IS_CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
                CloseHelper.close(this.errorHandler, this.logFactory);
                if (null != this.systemCounters) {
                    AtomicCounter errorCounter = this.systemCounters.get(SystemCounterDescriptor.ERRORS);
                    errorCounter.disconnectCountersManager();
                    errorCounter.close();
                }
                if (this.errorHandler instanceof AutoCloseable) {
                    CloseHelper.quietClose((AutoCloseable)((Object)this.errorHandler));
                }
                BufferUtil.free(this.lossReportBuffer);
                this.lossReportBuffer = null;
                BufferUtil.free(this.cncByteBuffer);
                this.cncByteBuffer = null;
                if (this.dirDeleteOnShutdown) {
                    this.deleteDirectory();
                }
                super.close();
            }
        }

        @Override
        public Context conclude() {
            super.conclude();
            try {
                this.concludeNullProperties();
                this.resolveOsSocketBufLengths();
                Configuration.validateMtuLength(this.mtuLength);
                Configuration.validateMtuLength(this.ipcMtuLength);
                Configuration.validatePageSize(this.filePageSize);
                Configuration.validateValueRange(this.conductorBufferLength, Configuration.CONDUCTOR_BUFFER_LENGTH_DEFAULT, Integer.MAX_VALUE, "conductorBufferLength");
                Configuration.validateValueRange(this.toClientsBufferLength, Configuration.TO_CLIENTS_BUFFER_LENGTH_DEFAULT, Integer.MAX_VALUE, "toClientsBufferLength");
                Configuration.validateValueRange(this.counterValuesBufferLength, 0x100000L, 524288000L, "counterValuesBufferLength");
                Configuration.validateValueRange(this.errorBufferLength, 0x100000L, Integer.MAX_VALUE, "errorBufferLength");
                Configuration.validateValueRange(this.publicationTermWindowLength, 0L, 0x40000000L, "publicationTermWindowLength");
                Configuration.validateValueRange(this.ipcPublicationTermWindowLength, 0L, 0x40000000L, "ipcPublicationTermWindowLength");
                Configuration.validateSessionIdRange(this.publicationReservedSessionIdLow, this.publicationReservedSessionIdHigh);
                LogBufferDescriptor.checkTermLength(this.publicationTermBufferLength);
                LogBufferDescriptor.checkTermLength(this.ipcTermBufferLength);
                Configuration.validateInitialWindowLength(this.initialWindowLength, this.mtuLength);
                Configuration.validateUnblockTimeout(this.publicationUnblockTimeoutNs(), this.clientLivenessTimeoutNs(), this.timerIntervalNs);
                Configuration.validateUntetheredTimeouts(this.untetheredWindowLimitTimeoutNs, this.untetheredRestingTimeoutNs, this.timerIntervalNs);
                long cncFileLength = BitUtil.align((long)CncFileDescriptor.END_OF_METADATA_OFFSET + (long)this.conductorBufferLength + (long)this.toClientsBufferLength + (long)Configuration.countersMetadataBufferLength(this.counterValuesBufferLength) + (long)this.counterValuesBufferLength + (long)this.errorBufferLength, (long)this.filePageSize);
                Configuration.validateValueRange(cncFileLength, 0L, Integer.MAX_VALUE, "CnC file length");
                this.cncByteBuffer = IoUtil.mapNewFile(this.cncFile(), cncFileLength);
                this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(this.cncByteBuffer);
                CncFileDescriptor.fillMetaData(this.cncMetaDataBuffer, this.conductorBufferLength, this.toClientsBufferLength, Configuration.countersMetadataBufferLength(this.counterValuesBufferLength), this.counterValuesBufferLength, this.clientLivenessTimeoutNs, this.errorBufferLength, this.epochClock.time(), SystemUtil.getPid());
                this.concludeCounters();
                this.concludeDependantProperties();
                this.concludeIdleStrategies();
                this.systemCounters.get(SystemCounterDescriptor.BYTES_CURRENTLY_MAPPED).setOrdered(cncFileLength + (long)this.lossReportBufferLength);
                this.toDriverCommands.nextCorrelationId();
                this.toDriverCommands.consumerHeartbeatTime(this.epochClock.time());
                CncFileDescriptor.signalCncReady(this.cncMetaDataBuffer);
                this.cncByteBuffer.force();
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
            }
            if (this.printConfigurationOnStart) {
                System.out.println(this);
            }
            return this;
        }

        public void deleteDirectory() {
            if (null != this.aeronDirectory()) {
                super.deleteAeronDirectory();
            }
        }

        @Override
        public Context aeronDirectoryName(String dirName) {
            super.aeronDirectoryName(dirName);
            return this;
        }

        @Override
        public Context driverTimeoutMs(long value) {
            super.driverTimeoutMs(value);
            return this;
        }

        @Override
        public Context countersMetaDataBuffer(UnsafeBuffer countersMetaDataBuffer) {
            super.countersMetaDataBuffer(countersMetaDataBuffer);
            return this;
        }

        @Override
        public Context countersValuesBuffer(UnsafeBuffer countersValuesBuffer) {
            super.countersValuesBuffer(countersValuesBuffer);
            return this;
        }

        public boolean printConfigurationOnStart() {
            return this.printConfigurationOnStart;
        }

        public Context printConfigurationOnStart(boolean printConfigurationOnStart) {
            this.printConfigurationOnStart = printConfigurationOnStart;
            return this;
        }

        public Context useWindowsHighResTimer(boolean useWindowsHighResTimers) {
            this.useWindowsHighResTimer = useWindowsHighResTimers;
            return this;
        }

        public boolean useWindowsHighResTimer() {
            return this.useWindowsHighResTimer;
        }

        public boolean warnIfDirectoryExists() {
            return this.warnIfDirectoryExists;
        }

        public Context warnIfDirectoryExists(boolean warnIfDirectoryExists) {
            this.warnIfDirectoryExists = warnIfDirectoryExists;
            return this;
        }

        public boolean dirDeleteOnStart() {
            return this.dirDeleteOnStart;
        }

        public Context dirDeleteOnStart(boolean dirDeleteOnStart) {
            this.dirDeleteOnStart = dirDeleteOnStart;
            return this;
        }

        public boolean dirDeleteOnShutdown() {
            return this.dirDeleteOnShutdown;
        }

        public Context dirDeleteOnShutdown(boolean dirDeleteOnShutdown) {
            this.dirDeleteOnShutdown = dirDeleteOnShutdown;
            return this;
        }

        public boolean termBufferSparseFile() {
            return this.termBufferSparseFile;
        }

        public Context termBufferSparseFile(boolean termBufferSparseFile) {
            this.termBufferSparseFile = termBufferSparseFile;
            return this;
        }

        public int conductorBufferLength() {
            return this.conductorBufferLength;
        }

        public Context conductorBufferLength(int length) {
            this.conductorBufferLength = length;
            return this;
        }

        public int toClientsBufferLength() {
            return this.toClientsBufferLength;
        }

        public Context toClientsBufferLength(int length) {
            this.toClientsBufferLength = length;
            return this;
        }

        public int counterValuesBufferLength() {
            return this.counterValuesBufferLength;
        }

        public Context counterValuesBufferLength(int length) {
            this.counterValuesBufferLength = length;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public Context errorBufferLength(int length) {
            this.errorBufferLength = length;
            return this;
        }

        public boolean performStorageChecks() {
            return this.performStorageChecks;
        }

        public Context performStorageChecks(boolean performStorageChecks) {
            this.performStorageChecks = performStorageChecks;
            return this;
        }

        public long lowStorageWarningThreshold() {
            return this.lowStorageWarningThreshold;
        }

        public Context lowStorageWarningThreshold(long lowStorageWarningThreshold) {
            this.lowStorageWarningThreshold = lowStorageWarningThreshold;
            return this;
        }

        public int lossReportBufferLength() {
            return this.lossReportBufferLength;
        }

        public Context lossReportBufferLength(int length) {
            this.lossReportBufferLength = length;
            return this;
        }

        public int filePageSize() {
            return this.filePageSize;
        }

        public Context filePageSize(int filePageSize) {
            this.filePageSize = filePageSize;
            return this;
        }

        public long timerIntervalNs() {
            return this.timerIntervalNs;
        }

        public Context timerIntervalNs(long timerIntervalNs) {
            this.timerIntervalNs = timerIntervalNs;
            return this;
        }

        public long imageLivenessTimeoutNs() {
            return this.imageLivenessTimeoutNs;
        }

        public Context imageLivenessTimeoutNs(long timeout) {
            this.imageLivenessTimeoutNs = timeout;
            return this;
        }

        public long publicationLingerTimeoutNs() {
            return this.publicationLingerTimeoutNs;
        }

        public Context publicationLingerTimeoutNs(long timeoutNs) {
            this.publicationLingerTimeoutNs = timeoutNs;
            return this;
        }

        public long untetheredWindowLimitTimeoutNs() {
            return this.untetheredWindowLimitTimeoutNs;
        }

        public Context untetheredWindowLimitTimeoutNs(long timeoutNs) {
            this.untetheredWindowLimitTimeoutNs = timeoutNs;
            return this;
        }

        public long untetheredRestingTimeoutNs() {
            return this.untetheredRestingTimeoutNs;
        }

        public Context untetheredRestingTimeoutNs(long timeoutNs) {
            this.untetheredRestingTimeoutNs = timeoutNs;
            return this;
        }

        public long retransmitUnicastDelayNs() {
            return this.retransmitUnicastDelayNs;
        }

        public Context retransmitUnicastDelayNs(long retransmitUnicastDelayNs) {
            this.retransmitUnicastDelayNs = retransmitUnicastDelayNs;
            return this;
        }

        public long retransmitUnicastLingerNs() {
            return this.retransmitUnicastLingerNs;
        }

        public Context retransmitUnicastLingerNs(long retransmitUnicastLingerNs) {
            this.retransmitUnicastLingerNs = retransmitUnicastLingerNs;
            return this;
        }

        public long nakUnicastDelayNs() {
            return this.nakUnicastDelayNs;
        }

        public Context nakUnicastDelayNs(long nakUnicastDelayNs) {
            this.nakUnicastDelayNs = nakUnicastDelayNs;
            return this;
        }

        public long nakUnicastRetryDelayRatio() {
            return this.nakUnicastRetryDelayRatio;
        }

        public Context nakUnicastRetryDelayRatio(long nakUnicastRetryDelayRatio) {
            this.nakUnicastRetryDelayRatio = nakUnicastRetryDelayRatio;
            return this;
        }

        public long nakMulticastMaxBackoffNs() {
            return this.nakMulticastMaxBackoffNs;
        }

        public Context nakMulticastMaxBackoffNs(long nakMulticastMaxBackoffNs) {
            this.nakMulticastMaxBackoffNs = nakMulticastMaxBackoffNs;
            return this;
        }

        public int nakMulticastGroupSize() {
            return this.nakMulticastGroupSize;
        }

        public Context nakMulticastGroupSize(int nakMulticastGroupSize) {
            this.nakMulticastGroupSize = nakMulticastGroupSize;
            return this;
        }

        public long clientLivenessTimeoutNs() {
            return CommonContext.checkDebugTimeout(this.clientLivenessTimeoutNs, TimeUnit.NANOSECONDS);
        }

        public Context clientLivenessTimeoutNs(long timeoutNs) {
            this.clientLivenessTimeoutNs = timeoutNs;
            return this;
        }

        public long statusMessageTimeoutNs() {
            return this.statusMessageTimeoutNs;
        }

        public Context statusMessageTimeoutNs(long statusMessageTimeoutNs) {
            this.statusMessageTimeoutNs = statusMessageTimeoutNs;
            return this;
        }

        public long counterFreeToReuseTimeoutNs() {
            return this.counterFreeToReuseTimeoutNs;
        }

        public Context counterFreeToReuseTimeoutNs(long counterFreeToReuseTimeoutNs) {
            this.counterFreeToReuseTimeoutNs = counterFreeToReuseTimeoutNs;
            return this;
        }

        public long publicationUnblockTimeoutNs() {
            return CommonContext.checkDebugTimeout(this.publicationUnblockTimeoutNs, TimeUnit.NANOSECONDS, 1.5);
        }

        public Context publicationUnblockTimeoutNs(long timeoutNs) {
            this.publicationUnblockTimeoutNs = timeoutNs;
            return this;
        }

        public long publicationConnectionTimeoutNs() {
            return this.publicationConnectionTimeoutNs;
        }

        public Context publicationConnectionTimeoutNs(long timeoutNs) {
            this.publicationConnectionTimeoutNs = timeoutNs;
            return this;
        }

        public boolean spiesSimulateConnection() {
            return this.spiesSimulateConnection;
        }

        public Context spiesSimulateConnection(boolean spiesSimulateConnection) {
            this.spiesSimulateConnection = spiesSimulateConnection;
            return this;
        }

        public boolean reliableStream() {
            return this.reliableStream;
        }

        public Context reliableStream(boolean reliableStream) {
            this.reliableStream = reliableStream;
            return this;
        }

        public boolean tetherSubscriptions() {
            return this.tetherSubscriptions;
        }

        public Context tetherSubscriptions(boolean tetherSubscription) {
            this.tetherSubscriptions = tetherSubscription;
            return this;
        }

        public CommonContext.InferableBoolean receiverGroupConsideration() {
            return this.receiverGroupConsideration;
        }

        public Context receiverGroupConsideration(CommonContext.InferableBoolean receiverGroupConsideration) {
            this.receiverGroupConsideration = receiverGroupConsideration;
            return this;
        }

        public boolean rejoinStream() {
            return this.rejoinStream;
        }

        public Context rejoinStream(boolean rejoinStream) {
            this.rejoinStream = rejoinStream;
            return this;
        }

        public int publicationTermBufferLength() {
            return this.publicationTermBufferLength;
        }

        public Context publicationTermBufferLength(int termBufferLength) {
            this.publicationTermBufferLength = termBufferLength;
            return this;
        }

        public int ipcTermBufferLength() {
            return this.ipcTermBufferLength;
        }

        public Context ipcTermBufferLength(int termBufferLength) {
            this.ipcTermBufferLength = termBufferLength;
            return this;
        }

        public int publicationTermWindowLength() {
            return this.publicationTermWindowLength;
        }

        public Context publicationTermWindowLength(int termWindowLength) {
            this.publicationTermWindowLength = termWindowLength;
            return this;
        }

        public int ipcPublicationTermWindowLength() {
            return this.ipcPublicationTermWindowLength;
        }

        public Context ipcPublicationTermWindowLength(int termWindowLength) {
            this.ipcPublicationTermWindowLength = termWindowLength;
            return this;
        }

        public int initialWindowLength() {
            return this.initialWindowLength;
        }

        public Context initialWindowLength(int initialWindowLength) {
            this.initialWindowLength = initialWindowLength;
            return this;
        }

        public int socketSndbufLength() {
            return this.socketSndbufLength;
        }

        public Context socketSndbufLength(int socketSndbufLength) {
            this.socketSndbufLength = socketSndbufLength;
            return this;
        }

        public int socketRcvbufLength() {
            return this.socketRcvbufLength;
        }

        public Context socketRcvbufLength(int socketRcvbufLength) {
            this.socketRcvbufLength = socketRcvbufLength;
            return this;
        }

        public int socketMulticastTtl() {
            return this.socketMulticastTtl;
        }

        public Context socketMulticastTtl(int ttl) {
            this.socketMulticastTtl = ttl;
            return this;
        }

        public int mtuLength() {
            return this.mtuLength;
        }

        public Context mtuLength(int mtuLength) {
            this.mtuLength = mtuLength;
            return this;
        }

        public int ipcMtuLength() {
            return this.ipcMtuLength;
        }

        public Context ipcMtuLength(int ipcMtuLength) {
            this.ipcMtuLength = ipcMtuLength;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public CachedEpochClock cachedEpochClock() {
            return this.cachedEpochClock;
        }

        public Context cachedEpochClock(CachedEpochClock clock) {
            this.cachedEpochClock = clock;
            return this;
        }

        public CachedNanoClock cachedNanoClock() {
            return this.cachedNanoClock;
        }

        public Context cachedNanoClock(CachedNanoClock clock) {
            this.cachedNanoClock = clock;
            return this;
        }

        public CachedNanoClock senderCachedNanoClock() {
            return this.senderCachedNanoClock;
        }

        public Context senderCachedNanoClock(CachedNanoClock clock) {
            this.senderCachedNanoClock = clock;
            return this;
        }

        public CachedNanoClock receiverCachedNanoClock() {
            return this.receiverCachedNanoClock;
        }

        public Context receiverCachedNanoClock(CachedNanoClock clock) {
            this.receiverCachedNanoClock = clock;
            return this;
        }

        public ThreadingMode threadingMode() {
            return this.threadingMode;
        }

        public Context threadingMode(ThreadingMode threadingMode) {
            this.threadingMode = threadingMode;
            return this;
        }

        public ThreadFactory senderThreadFactory() {
            return this.senderThreadFactory;
        }

        public Context senderThreadFactory(ThreadFactory factory) {
            this.senderThreadFactory = factory;
            return this;
        }

        public ThreadFactory receiverThreadFactory() {
            return this.receiverThreadFactory;
        }

        public Context receiverThreadFactory(ThreadFactory factory) {
            this.receiverThreadFactory = factory;
            return this;
        }

        public ThreadFactory conductorThreadFactory() {
            return this.conductorThreadFactory;
        }

        public Context conductorThreadFactory(ThreadFactory factory) {
            this.conductorThreadFactory = factory;
            return this;
        }

        public ThreadFactory sharedThreadFactory() {
            return this.sharedThreadFactory;
        }

        public Context sharedThreadFactory(ThreadFactory factory) {
            this.sharedThreadFactory = factory;
            return this;
        }

        public ThreadFactory sharedNetworkThreadFactory() {
            return this.sharedNetworkThreadFactory;
        }

        public Context sharedNetworkThreadFactory(ThreadFactory factory) {
            this.sharedNetworkThreadFactory = factory;
            return this;
        }

        public int asyncTaskExecutorThreads() {
            return this.asyncTaskExecutorThreads;
        }

        public Context asyncTaskExecutorThreads(int asyncTaskExecutorThreads) {
            this.asyncTaskExecutorThreads = asyncTaskExecutorThreads;
            return this;
        }

        public Executor asyncTaskExecutor() {
            return this.asyncTaskExecutor;
        }

        public Context asyncTaskExecutor(Executor asyncTaskExecutor) {
            this.asyncTaskExecutor = asyncTaskExecutor;
            return this;
        }

        public int maxResend() {
            return this.maxResend;
        }

        public Context maxResend(int maxResend) {
            this.maxResend = maxResend;
            return this;
        }

        public IdleStrategy senderIdleStrategy() {
            return this.senderIdleStrategy;
        }

        public Context senderIdleStrategy(IdleStrategy strategy) {
            this.senderIdleStrategy = strategy;
            return this;
        }

        public IdleStrategy receiverIdleStrategy() {
            return this.receiverIdleStrategy;
        }

        public Context receiverIdleStrategy(IdleStrategy strategy) {
            this.receiverIdleStrategy = strategy;
            return this;
        }

        public IdleStrategy conductorIdleStrategy() {
            return this.conductorIdleStrategy;
        }

        public Context conductorIdleStrategy(IdleStrategy strategy) {
            this.conductorIdleStrategy = strategy;
            return this;
        }

        public IdleStrategy sharedNetworkIdleStrategy() {
            return this.sharedNetworkIdleStrategy;
        }

        public Context sharedNetworkIdleStrategy(IdleStrategy strategy) {
            this.sharedNetworkIdleStrategy = strategy;
            return this;
        }

        public IdleStrategy sharedIdleStrategy() {
            return this.sharedIdleStrategy;
        }

        public Context sharedIdleStrategy(IdleStrategy strategy) {
            this.sharedIdleStrategy = strategy;
            return this;
        }

        public SendChannelEndpointSupplier sendChannelEndpointSupplier() {
            return this.sendChannelEndpointSupplier;
        }

        public Context sendChannelEndpointSupplier(SendChannelEndpointSupplier supplier) {
            this.sendChannelEndpointSupplier = supplier;
            return this;
        }

        public ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier() {
            return this.receiveChannelEndpointSupplier;
        }

        public Context receiveChannelEndpointSupplier(ReceiveChannelEndpointSupplier supplier) {
            this.receiveChannelEndpointSupplier = supplier;
            return this;
        }

        public ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals() {
            return this.receiveChannelEndpointThreadLocals;
        }

        public Context receiveChannelEndpointThreadLocals(ReceiveChannelEndpointThreadLocals threadLocals) {
            this.receiveChannelEndpointThreadLocals = threadLocals;
            return this;
        }

        public MutableDirectBuffer tempBuffer() {
            return this.tempBuffer;
        }

        public Context tempBuffer(MutableDirectBuffer tempBuffer) {
            this.tempBuffer = tempBuffer;
            return this;
        }

        public FlowControlSupplier unicastFlowControlSupplier() {
            return this.unicastFlowControlSupplier;
        }

        public Context unicastFlowControlSupplier(FlowControlSupplier flowControlSupplier) {
            this.unicastFlowControlSupplier = flowControlSupplier;
            return this;
        }

        public FlowControlSupplier multicastFlowControlSupplier() {
            return this.multicastFlowControlSupplier;
        }

        public Context multicastFlowControlSupplier(FlowControlSupplier flowControlSupplier) {
            this.multicastFlowControlSupplier = flowControlSupplier;
            return this;
        }

        public long flowControlReceiverTimeoutNs() {
            return this.flowControlReceiverTimeoutNs;
        }

        public Context flowControlReceiverTimeoutNs(long timeoutNs) {
            this.flowControlReceiverTimeoutNs = timeoutNs;
            return this;
        }

        @Deprecated
        public byte[] applicationSpecificFeedback() {
            return this.applicationSpecificFeedback;
        }

        @Deprecated
        public Context applicationSpecificFeedback(byte[] asfBytes) {
            this.applicationSpecificFeedback = asfBytes;
            return this;
        }

        public CongestionControlSupplier congestionControlSupplier() {
            return this.congestionControlSupplier;
        }

        public Context congestControlSupplier(CongestionControlSupplier supplier) {
            this.congestionControlSupplier = supplier;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public Context errorLog(DistinctErrorLog errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public boolean useConcurrentCountersManager() {
            return this.useConcurrentCountersManager;
        }

        public Context useConcurrentCountersManager(boolean useConcurrentCountersManager) {
            this.useConcurrentCountersManager = useConcurrentCountersManager;
            return this;
        }

        public CountersManager countersManager() {
            return this.countersManager;
        }

        public Context countersManager(CountersManager countersManager) {
            this.countersManager = countersManager;
            return this;
        }

        public SystemCounters systemCounters() {
            return this.systemCounters;
        }

        public Context systemCounters(SystemCounters systemCounters) {
            this.systemCounters = systemCounters;
            return this;
        }

        LossReport lossReport() {
            return this.lossReport;
        }

        Context lossReport(LossReport lossReport) {
            this.lossReport = lossReport;
            return this;
        }

        public int publicationReservedSessionIdLow() {
            return this.publicationReservedSessionIdLow;
        }

        public Context publicationReservedSessionIdLow(int sessionId) {
            this.publicationReservedSessionIdLow = sessionId;
            return this;
        }

        public int publicationReservedSessionIdHigh() {
            return this.publicationReservedSessionIdHigh;
        }

        public Context publicationReservedSessionIdHigh(int sessionId) {
            this.publicationReservedSessionIdHigh = sessionId;
            return this;
        }

        public FeedbackDelayGenerator retransmitUnicastDelayGenerator() {
            return this.retransmitUnicastDelayGenerator;
        }

        public Context retransmitUnicastDelayGenerator(FeedbackDelayGenerator feedbackDelayGenerator) {
            this.retransmitUnicastDelayGenerator = feedbackDelayGenerator;
            return this;
        }

        public FeedbackDelayGenerator retransmitUnicastLingerGenerator() {
            return this.retransmitUnicastLingerGenerator;
        }

        public Context retransmitUnicastLingerGenerator(FeedbackDelayGenerator feedbackDelayGenerator) {
            this.retransmitUnicastLingerGenerator = feedbackDelayGenerator;
            return this;
        }

        public FeedbackDelayGenerator unicastFeedbackDelayGenerator() {
            return this.unicastFeedbackDelayGenerator;
        }

        public Context unicastFeedbackDelayGenerator(FeedbackDelayGenerator feedbackDelayGenerator) {
            this.unicastFeedbackDelayGenerator = feedbackDelayGenerator;
            return this;
        }

        public FeedbackDelayGenerator multicastFeedbackDelayGenerator() {
            return this.multicastFeedbackDelayGenerator;
        }

        public Context multicastFeedbackDelayGenerator(FeedbackDelayGenerator feedbackDelayGenerator) {
            this.multicastFeedbackDelayGenerator = feedbackDelayGenerator;
            return this;
        }

        public Context terminationHook(Runnable terminationHook) {
            this.terminationHook = terminationHook;
            return this;
        }

        public Runnable terminationHook() {
            return this.terminationHook;
        }

        public Context terminationValidator(TerminationValidator validator) {
            this.terminationValidator = validator;
            return this;
        }

        public TerminationValidator terminationValidator() {
            return this.terminationValidator;
        }

        public int sendToStatusMessagePollRatio() {
            return this.sendToStatusMessagePollRatio;
        }

        public Context sendToStatusMessagePollRatio(int ratio) {
            this.sendToStatusMessagePollRatio = ratio;
            return this;
        }

        public Long receiverGroupTag() {
            return this.receiverGroupTag;
        }

        public Context receiverGroupTag(Long groupTag) {
            this.receiverGroupTag = groupTag;
            return this;
        }

        public long flowControlGroupTag() {
            return this.flowControlGroupTag;
        }

        public Context flowControlGroupTag(long groupTag) {
            this.flowControlGroupTag = groupTag;
            return this;
        }

        public int flowControlGroupMinSize() {
            return this.flowControlGroupMinSize;
        }

        public Context flowControlGroupMinSize(int groupSize) {
            this.flowControlGroupMinSize = groupSize;
            return this;
        }

        public NameResolver nameResolver() {
            return this.nameResolver;
        }

        public Context nameResolver(NameResolver nameResolver) {
            this.nameResolver = nameResolver;
            return this;
        }

        public String resolverName() {
            return this.resolverName;
        }

        public Context resolverName(String resolverName) {
            this.resolverName = resolverName;
            return this;
        }

        public String resolverInterface() {
            return this.resolverInterface;
        }

        public Context resolverInterface(String resolverInterface) {
            this.resolverInterface = resolverInterface;
            return this;
        }

        public String resolverBootstrapNeighbor() {
            return this.resolverBootstrapNeighbor;
        }

        public Context resolverBootstrapNeighbor(String resolverBootstrapNeighbor) {
            this.resolverBootstrapNeighbor = resolverBootstrapNeighbor;
            return this;
        }

        public long reResolutionCheckIntervalNs() {
            return this.reResolutionCheckIntervalNs;
        }

        public Context reResolutionCheckIntervalNs(long reResolutionCheckIntervalNs) {
            this.reResolutionCheckIntervalNs = reResolutionCheckIntervalNs;
            return this;
        }

        public Context conductorCycleThresholdNs(long thresholdNs) {
            this.conductorCycleThresholdNs = thresholdNs;
            return this;
        }

        public long conductorCycleThresholdNs() {
            return this.conductorCycleThresholdNs;
        }

        public Context channelReceiveTimestampClock(EpochNanoClock clock) {
            this.channelReceiveTimestampClock = clock;
            return this;
        }

        public Context senderCycleThresholdNs(long thresholdNs) {
            this.senderCycleThresholdNs = thresholdNs;
            return this;
        }

        public long senderCycleThresholdNs() {
            return this.senderCycleThresholdNs;
        }

        public Context receiverCycleThresholdNs(long thresholdNs) {
            this.receiverCycleThresholdNs = thresholdNs;
            return this;
        }

        public long receiverCycleThresholdNs() {
            return this.receiverCycleThresholdNs;
        }

        public Context nameResolverThresholdNs(long thresholdNs) {
            this.nameResolverThresholdNs = thresholdNs;
            return this;
        }

        public long nameResolverThresholdNs() {
            return this.nameResolverThresholdNs;
        }

        public Context resourceFreeLimit(int resourceFreeLimit) {
            this.resourceFreeLimit = resourceFreeLimit;
            return this;
        }

        public int resourceFreeLimit() {
            return this.resourceFreeLimit;
        }

        public EpochNanoClock channelReceiveTimestampClock() {
            return this.channelReceiveTimestampClock;
        }

        public Context channelSendTimestampClock(EpochNanoClock clock) {
            this.channelSendTimestampClock = clock;
            return this;
        }

        public DutyCycleTracker conductorDutyCycleTracker() {
            return this.conductorDutyCycleTracker;
        }

        public Context conductorDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.conductorDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker senderDutyCycleTracker() {
            return this.senderDutyCycleTracker;
        }

        public Context senderDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.senderDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker receiverDutyCycleTracker() {
            return this.receiverDutyCycleTracker;
        }

        public Context receiverDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.receiverDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker nameResolverTimeTracker() {
            return this.nameResolverTimeTracker;
        }

        public Context nameResolverTimeTracker(DutyCycleTracker dutyCycleTracker) {
            this.nameResolverTimeTracker = dutyCycleTracker;
            return this;
        }

        public String senderWildcardPortRange() {
            return this.senderWildcardPortRange;
        }

        public Context senderWildcardPortRange(String portRange) {
            this.senderWildcardPortRange = portRange;
            return this;
        }

        public String receiverWildcardPortRange() {
            return this.receiverWildcardPortRange;
        }

        public Context receiverWildcardPortRange(String portRange) {
            this.receiverWildcardPortRange = portRange;
            return this;
        }

        public PortManager senderPortManager() {
            return this.senderPortManager;
        }

        public Context senderPortManager(PortManager portManager) {
            this.senderPortManager = portManager;
            return this;
        }

        public PortManager receiverPortManager() {
            return this.receiverPortManager;
        }

        public Context receiverPortManager(PortManager portManager) {
            this.receiverPortManager = portManager;
            return this;
        }

        public Context streamSessionLimit(int sessionLimit) {
            this.streamSessionLimit = sessionLimit;
            return this;
        }

        public int streamSessionLimit() {
            return this.streamSessionLimit;
        }

        public EpochNanoClock channelSendTimestampClock() {
            return this.channelSendTimestampClock;
        }

        @Override
        public Context enableExperimentalFeatures(boolean enableExperimentalFeatures) {
            super.enableExperimentalFeatures(enableExperimentalFeatures);
            return this;
        }

        OneToOneConcurrentArrayQueue<Runnable> receiverCommandQueue() {
            return this.receiverCommandQueue;
        }

        Context receiverCommandQueue(OneToOneConcurrentArrayQueue<Runnable> receiverCommandQueue) {
            this.receiverCommandQueue = receiverCommandQueue;
            return this;
        }

        OneToOneConcurrentArrayQueue<Runnable> senderCommandQueue() {
            return this.senderCommandQueue;
        }

        Context senderCommandQueue(OneToOneConcurrentArrayQueue<Runnable> senderCommandQueue) {
            this.senderCommandQueue = senderCommandQueue;
            return this;
        }

        ManyToOneConcurrentLinkedQueue<Runnable> driverCommandQueue() {
            return this.driverCommandQueue;
        }

        Context driverCommandQueue(ManyToOneConcurrentLinkedQueue<Runnable> queue) {
            this.driverCommandQueue = queue;
            return this;
        }

        ClientProxy clientProxy() {
            return this.clientProxy;
        }

        Context clientProxy(ClientProxy clientProxy) {
            this.clientProxy = clientProxy;
            return this;
        }

        RingBuffer toDriverCommands() {
            return this.toDriverCommands;
        }

        Context toDriverCommands(RingBuffer toDriverCommands) {
            this.toDriverCommands = toDriverCommands;
            return this;
        }

        Context cncByteBuffer(MappedByteBuffer cncByteBuffer) {
            this.cncByteBuffer = cncByteBuffer;
            return this;
        }

        MappedByteBuffer cncByteBuffer() {
            return this.cncByteBuffer;
        }

        LogFactory logFactory() {
            return this.logFactory;
        }

        Context logFactory(LogFactory logFactory) {
            this.logFactory = logFactory;
            return this;
        }

        DataTransportPoller dataTransportPoller() {
            return this.dataTransportPoller;
        }

        Context dataTransportPoller(DataTransportPoller transportPoller) {
            this.dataTransportPoller = transportPoller;
            return this;
        }

        ControlTransportPoller controlTransportPoller() {
            return this.controlTransportPoller;
        }

        Context controlTransportPoller(ControlTransportPoller transportPoller) {
            this.controlTransportPoller = transportPoller;
            return this;
        }

        ReceiverProxy receiverProxy() {
            return this.receiverProxy;
        }

        Context receiverProxy(ReceiverProxy receiverProxy) {
            this.receiverProxy = receiverProxy;
            return this;
        }

        SenderProxy senderProxy() {
            return this.senderProxy;
        }

        Context senderProxy(SenderProxy senderProxy) {
            this.senderProxy = senderProxy;
            return this;
        }

        DriverConductorProxy driverConductorProxy() {
            return this.driverConductorProxy;
        }

        Context driverConductorProxy(DriverConductorProxy driverConductorProxy) {
            this.driverConductorProxy = driverConductorProxy;
            return this;
        }

        int osDefaultSocketRcvbufLength() {
            this.resolveOsSocketBufLengths();
            return this.osDefaultSocketRcvbufLength;
        }

        int osMaxSocketRcvbufLength() {
            this.resolveOsSocketBufLengths();
            return this.osMaxSocketRcvbufLength;
        }

        int osDefaultSocketSndbufLength() {
            this.resolveOsSocketBufLengths();
            return this.osDefaultSocketSndbufLength;
        }

        int osMaxSocketSndbufLength() {
            this.resolveOsSocketBufLengths();
            return this.osMaxSocketSndbufLength;
        }

        void resolveOsSocketBufLengths() {
            if (-1 != this.osMaxSocketRcvbufLength) {
                return;
            }
            try (DatagramChannel probe = DatagramChannel.open();){
                this.osDefaultSocketSndbufLength = probe.getOption(StandardSocketOptions.SO_SNDBUF);
                probe.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)Integer.MAX_VALUE);
                this.osMaxSocketSndbufLength = probe.getOption(StandardSocketOptions.SO_SNDBUF);
                this.osDefaultSocketRcvbufLength = probe.getOption(StandardSocketOptions.SO_RCVBUF);
                probe.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)Integer.MAX_VALUE);
                this.osMaxSocketRcvbufLength = probe.getOption(StandardSocketOptions.SO_RCVBUF);
            }
            catch (IOException ex) {
                throw new AeronException("probe socket: " + ex, ex);
            }
        }

        void concludeNullProperties() {
            if (null == this.tempBuffer) {
                this.tempBuffer = new UnsafeBuffer(new byte[512]);
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.nanoClock) {
                this.nanoClock = SystemNanoClock.INSTANCE;
            }
            if (null == this.cachedEpochClock) {
                this.cachedEpochClock = new CachedEpochClock();
            }
            if (null == this.cachedNanoClock) {
                this.cachedNanoClock = new CachedNanoClock();
            }
            if (null == this.senderCachedNanoClock) {
                this.senderCachedNanoClock = new CachedNanoClock();
            }
            if (null == this.receiverCachedNanoClock) {
                this.receiverCachedNanoClock = new CachedNanoClock();
            }
            if (null == this.unicastFlowControlSupplier) {
                this.unicastFlowControlSupplier = Configuration.unicastFlowControlSupplier();
            }
            if (null == this.multicastFlowControlSupplier) {
                this.multicastFlowControlSupplier = Configuration.multicastFlowControlSupplier();
            }
            if (null == this.sendChannelEndpointSupplier) {
                this.sendChannelEndpointSupplier = Configuration.sendChannelEndpointSupplier();
            }
            if (null == this.receiveChannelEndpointSupplier) {
                this.receiveChannelEndpointSupplier = Configuration.receiveChannelEndpointSupplier();
            }
            if (null == this.dataTransportPoller) {
                this.dataTransportPoller = new DataTransportPoller(this.errorHandler);
            }
            if (null == this.applicationSpecificFeedback) {
                this.applicationSpecificFeedback = Configuration.applicationSpecificFeedback();
            }
            if (null == this.receiverGroupTag && this.applicationSpecificFeedback.length > 0) {
                if (this.applicationSpecificFeedback.length != 8) {
                    throw new IllegalArgumentException("applicationSpecificFeedback length must be equal to 8 bytes: length=" + this.applicationSpecificFeedback.length);
                }
                UnsafeBuffer buffer = new UnsafeBuffer(this.applicationSpecificFeedback);
                this.receiverGroupTag = buffer.getLong(0, ByteOrder.LITTLE_ENDIAN);
            }
            if (null == this.receiveChannelEndpointThreadLocals) {
                this.receiveChannelEndpointThreadLocals = new ReceiveChannelEndpointThreadLocals();
            }
            if (null == this.congestionControlSupplier) {
                this.congestionControlSupplier = Configuration.congestionControlSupplier();
            }
            if (null == this.threadingMode) {
                this.threadingMode = Configuration.threadingMode();
            }
            if (null == this.driverCommandQueue) {
                this.driverCommandQueue = new ManyToOneConcurrentLinkedQueue();
            }
            if (null == this.receiverCommandQueue) {
                this.receiverCommandQueue = new OneToOneConcurrentArrayQueue(1024);
            }
            if (null == this.senderCommandQueue) {
                this.senderCommandQueue = new OneToOneConcurrentArrayQueue(1024);
            }
            if (null == this.retransmitUnicastDelayGenerator) {
                this.retransmitUnicastDelayGenerator = new StaticDelayGenerator(this.retransmitUnicastDelayNs);
            }
            if (null == this.retransmitUnicastLingerGenerator) {
                this.retransmitUnicastLingerGenerator = new StaticDelayGenerator(this.retransmitUnicastLingerNs);
            }
            if (null == this.unicastFeedbackDelayGenerator) {
                this.unicastFeedbackDelayGenerator = new StaticDelayGenerator(this.nakUnicastDelayNs, this.nakUnicastDelayNs * this.nakUnicastRetryDelayRatio);
            }
            if (null == this.multicastFeedbackDelayGenerator) {
                this.multicastFeedbackDelayGenerator = new OptimalMulticastDelayGenerator(this.nakMulticastMaxBackoffNs, this.nakMulticastGroupSize);
            }
            if (null == this.terminationValidator) {
                this.terminationValidator = Configuration.terminationValidator();
            }
            if (null == this.nameResolver) {
                this.nameResolver = DefaultNameResolver.INSTANCE;
            }
            if (null == this.channelReceiveTimestampClock) {
                this.channelReceiveTimestampClock = new SystemEpochNanoClock();
            }
            if (null == this.channelSendTimestampClock) {
                this.channelSendTimestampClock = new SystemEpochNanoClock();
            }
            if (null == this.asyncTaskExecutor) {
                this.asyncTaskExecutor = this.asyncTaskExecutorThreads <= 0 ? Configuration.CALLER_RUNS_TASK_EXECUTOR : Context.newDefaultAsyncTaskExecutor(this.asyncTaskExecutorThreads);
            }
            if (null != this.resolverInterface && Strings.isEmpty(this.resolverName)) {
                throw new ConfigurationException("`resolverName` is required when `resolverInterface` is set");
            }
        }

        private static ThreadPoolExecutor newDefaultAsyncTaskExecutor(int threadCount) {
            AtomicInteger id = new AtomicInteger();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
                Thread thread = new Thread(r, "async-task-executor-" + id.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            });
            executor.prestartAllCoreThreads();
            return executor;
        }

        private void concludeCounters() {
            if (null == this.countersManager) {
                if (this.countersMetaDataBuffer() == null) {
                    this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
                }
                if (this.countersValuesBuffer() == null) {
                    this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
                }
                long reuseTimeoutMs = this.counterFreeToReuseTimeoutNs > 0L ? Math.max(TimeUnit.NANOSECONDS.toMillis(this.counterFreeToReuseTimeoutNs), 1L) : 0L;
                CountersManager countersManager = this.countersManager = this.useConcurrentCountersManager ? new ConcurrentCountersManager(this.countersMetaDataBuffer(), this.countersValuesBuffer(), StandardCharsets.US_ASCII, this.cachedEpochClock, reuseTimeoutMs) : new CountersManager(this.countersMetaDataBuffer(), this.countersValuesBuffer(), StandardCharsets.US_ASCII, this.cachedEpochClock, reuseTimeoutMs);
            }
            if (null == this.systemCounters) {
                this.systemCounters = new SystemCounters(this.countersManager);
            }
            int aeronVersion = SemanticVersion.compose(1, 45, 0);
            this.systemCounters.get(SystemCounterDescriptor.AERON_VERSION).set(aeronVersion);
        }

        private void concludeDependantProperties() {
            this.clientProxy = new ClientProxy(new BroadcastTransmitter(CncFileDescriptor.createToClientsBuffer(this.cncByteBuffer, this.cncMetaDataBuffer)));
            this.toDriverCommands = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            if (null == this.errorLog) {
                this.errorLog = new DistinctErrorLog(CncFileDescriptor.createErrorLogBuffer(this.cncByteBuffer, this.cncMetaDataBuffer), this.epochClock, StandardCharsets.US_ASCII);
            }
            this.errorHandler = CommonContext.setupErrorHandler(this.errorHandler, this.errorLog);
            this.receiverProxy = new ReceiverProxy(this.threadingMode, this.receiverCommandQueue, this.systemCounters.get(SystemCounterDescriptor.RECEIVER_PROXY_FAILS));
            this.senderProxy = new SenderProxy(this.threadingMode, this.senderCommandQueue, this.systemCounters.get(SystemCounterDescriptor.SENDER_PROXY_FAILS));
            this.driverConductorProxy = new DriverConductorProxy(this.threadingMode, this.driverCommandQueue, this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_PROXY_FAILS));
            if (null == this.controlTransportPoller) {
                this.controlTransportPoller = new ControlTransportPoller(this.errorHandler, this.driverConductorProxy);
            }
            if (null == this.logFactory) {
                this.logFactory = new FileStoreLogFactory(this.aeronDirectoryName(), this.filePageSize, this.performStorageChecks, this.lowStorageWarningThreshold, this.errorHandler, this.systemCounters.get(SystemCounterDescriptor.BYTES_CURRENTLY_MAPPED));
            }
            if (null == this.lossReport) {
                long pageAlignedLossReportBufferLength = BitUtil.align(this.lossReportBufferLength, this.filePageSize);
                Configuration.validateValueRange(pageAlignedLossReportBufferLength, 0x100000L, Integer.MAX_VALUE, "lossReportBufferLength");
                this.lossReportBuffer = LossReportUtil.mapLossReport(this.aeronDirectoryName(), (int)pageAlignedLossReportBufferLength);
                this.lossReport = new LossReport(new UnsafeBuffer(this.lossReportBuffer));
            }
            if (null == this.conductorDutyCycleTracker) {
                this.conductorDutyCycleTracker = new DutyCycleStallTracker(this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_MAX_CYCLE_TIME), this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_CYCLE_TIME_THRESHOLD_EXCEEDED), this.conductorCycleThresholdNs);
            }
            if (null == this.senderDutyCycleTracker) {
                this.senderDutyCycleTracker = new DutyCycleStallTracker(this.systemCounters.get(SystemCounterDescriptor.SENDER_MAX_CYCLE_TIME), this.systemCounters.get(SystemCounterDescriptor.SENDER_CYCLE_TIME_THRESHOLD_EXCEEDED), this.senderCycleThresholdNs);
            }
            if (null == this.receiverDutyCycleTracker) {
                this.receiverDutyCycleTracker = new DutyCycleStallTracker(this.systemCounters.get(SystemCounterDescriptor.RECEIVER_MAX_CYCLE_TIME), this.systemCounters.get(SystemCounterDescriptor.RECEIVER_CYCLE_TIME_THRESHOLD_EXCEEDED), this.receiverCycleThresholdNs);
            }
            if (null == this.nameResolverTimeTracker) {
                this.nameResolverTimeTracker = new DutyCycleStallTracker(this.systemCounters.get(SystemCounterDescriptor.NAME_RESOLVER_MAX_TIME), this.systemCounters.get(SystemCounterDescriptor.NAME_RESOLVER_TIME_THRESHOLD_EXCEEDED), this.nameResolverThresholdNs);
            }
            if (null == this.senderPortManager) {
                this.senderPortManager = new WildcardPortManager(WildcardPortManager.parsePortRange(this.senderWildcardPortRange), true);
            }
            if (null == this.receiverPortManager) {
                this.receiverPortManager = new WildcardPortManager(WildcardPortManager.parsePortRange(this.receiverWildcardPortRange), false);
            }
            this.nameResolver.init(this.countersManager, this.countersManager::newCounter);
        }

        private void concludeIdleStrategies() {
            UnsafeBufferStatusIndicator indicator = new UnsafeBufferStatusIndicator(this.countersManager.valuesBuffer(), SystemCounterDescriptor.CONTROLLABLE_IDLE_STRATEGY.id());
            switch (this.threadingMode) {
                case INVOKER: {
                    break;
                }
                case SHARED: {
                    if (null == this.sharedThreadFactory) {
                        this.sharedThreadFactory = Thread::new;
                    }
                    if (null != this.sharedIdleStrategy) break;
                    this.sharedIdleStrategy = Configuration.sharedIdleStrategy(indicator);
                    break;
                }
                case SHARED_NETWORK: {
                    if (null == this.conductorThreadFactory) {
                        this.conductorThreadFactory = Thread::new;
                    }
                    if (null == this.conductorIdleStrategy) {
                        this.conductorIdleStrategy = Configuration.conductorIdleStrategy(indicator);
                    }
                    if (null == this.sharedNetworkThreadFactory) {
                        this.sharedNetworkThreadFactory = Thread::new;
                    }
                    if (null != this.sharedNetworkIdleStrategy) break;
                    this.sharedNetworkIdleStrategy = Configuration.sharedNetworkIdleStrategy(indicator);
                    break;
                }
                case DEDICATED: {
                    if (null == this.conductorThreadFactory) {
                        this.conductorThreadFactory = Thread::new;
                    }
                    if (null == this.senderThreadFactory) {
                        this.senderThreadFactory = Thread::new;
                    }
                    if (null == this.receiverThreadFactory) {
                        this.receiverThreadFactory = Thread::new;
                    }
                    if (null == this.conductorIdleStrategy) {
                        this.conductorIdleStrategy = Configuration.conductorIdleStrategy(indicator);
                    }
                    if (null == this.senderIdleStrategy) {
                        this.senderIdleStrategy = Configuration.senderIdleStrategy(indicator);
                    }
                    if (null != this.receiverIdleStrategy) break;
                    this.receiverIdleStrategy = Configuration.receiverIdleStrategy(indicator);
                }
            }
        }

        public String toString() {
            return "MediaDriver.Context\n{\n    isConcluded=" + this.isConcluded() + "\n    isClosed=" + (1 == this.isClosed) + "\n    cncVersion=" + SemanticVersion.toString(CncFileDescriptor.CNC_VERSION) + "\n    aeronDirectory=" + this.aeronDirectory() + "\n    enabledExperimentalFeatures=" + this.enableExperimentalFeatures() + "\n    aeronDirectoryName='" + this.aeronDirectoryName() + '\'' + "\n    cncFile=" + this.cncFile() + "\n    countersMetaDataBuffer=" + this.countersMetaDataBuffer() + "\n    countersValuesBuffer=" + this.countersValuesBuffer() + "\n    driverTimeoutMs=" + this.driverTimeoutMs() + "\n    printConfigurationOnStart=" + this.printConfigurationOnStart + "\n    useWindowsHighResTimer=" + this.useWindowsHighResTimer + "\n    warnIfDirectoryExists=" + this.warnIfDirectoryExists + "\n    dirDeleteOnStart=" + this.dirDeleteOnStart + "\n    dirDeleteOnShutdown=" + this.dirDeleteOnShutdown + "\n    termBufferSparseFile=" + this.termBufferSparseFile + "\n    performStorageChecks=" + this.performStorageChecks + "\n    spiesSimulateConnection=" + this.spiesSimulateConnection + "\n    reliableStream=" + this.reliableStream + "\n    tetherSubscriptions=" + this.tetherSubscriptions + "\n    rejoinStream=" + this.rejoinStream + "\n    receiverGroupConsideration=" + (Object)((Object)this.receiverGroupConsideration) + "\n    conductorBufferLength=" + this.conductorBufferLength + "\n    toClientsBufferLength=" + this.toClientsBufferLength + "\n    counterValuesBufferLength=" + this.counterValuesBufferLength + "\n    errorBufferLength=" + this.errorBufferLength + "\n    lowStorageWarningThreshold=" + this.lowStorageWarningThreshold + "\n    timerIntervalNs=" + this.timerIntervalNs + "\n    clientLivenessTimeoutNs=" + this.clientLivenessTimeoutNs + "\n    imageLivenessTimeoutNs=" + this.imageLivenessTimeoutNs + "\n    publicationUnblockTimeoutNs=" + this.publicationUnblockTimeoutNs + "\n    publicationConnectionTimeoutNs=" + this.publicationConnectionTimeoutNs + "\n    publicationLingerTimeoutNs=" + this.publicationLingerTimeoutNs + "\n    untetheredWindowLimitTimeoutNs=" + this.untetheredWindowLimitTimeoutNs + "\n    untetheredRestingTimeoutNs=" + this.untetheredRestingTimeoutNs + "\n    retransmitUnicastDelayNs=" + this.retransmitUnicastDelayNs + "\n    retransmitUnicastLingerNs=" + this.retransmitUnicastLingerNs + "\n    nakUnicastDelayNs=" + this.nakUnicastDelayNs + "\n    nakMulticastMaxBackoffNs=" + this.nakMulticastMaxBackoffNs + "\n    nakMulticastGroupSize=" + this.nakMulticastGroupSize + "\n    statusMessageTimeoutNs=" + this.statusMessageTimeoutNs + "\n    counterFreeToReuseTimeoutNs=" + this.counterFreeToReuseTimeoutNs + "\n    conductorCycleThresholdNs=" + this.conductorCycleThresholdNs + "\n    senderCycleThresholdNs=" + this.senderCycleThresholdNs + "\n    receiverCycleThresholdNs=" + this.receiverCycleThresholdNs + "\n    nameResolverThresholdNs=" + this.nameResolverThresholdNs + "\n    publicationTermBufferLength=" + this.publicationTermBufferLength + "\n    ipcTermBufferLength=" + this.ipcTermBufferLength + "\n    publicationTermWindowLength=" + this.publicationTermWindowLength + "\n    ipcPublicationTermWindowLength=" + this.ipcPublicationTermWindowLength + "\n    initialWindowLength=" + this.initialWindowLength + "\n    socketSndbufLength=" + this.socketSndbufLength + "\n    socketRcvbufLength=" + this.socketRcvbufLength + "\n    socketMulticastTtl=" + this.socketMulticastTtl + "\n    mtuLength=" + this.mtuLength + "\n    ipcMtuLength=" + this.ipcMtuLength + "\n    filePageSize=" + this.filePageSize + "\n    publicationReservedSessionIdLow=" + this.publicationReservedSessionIdLow + "\n    publicationReservedSessionIdHigh=" + this.publicationReservedSessionIdHigh + "\n    lossReportBufferLength=" + this.lossReportBufferLength + "\n    epochClock=" + this.epochClock + "\n    nanoClock=" + this.nanoClock + "\n    cachedEpochClock=" + this.cachedEpochClock + "\n    cachedNanoClock=" + this.cachedNanoClock + "\n    threadingMode=" + (Object)((Object)this.threadingMode) + "\n    conductorThreadFactory=" + this.conductorThreadFactory + "\n    senderThreadFactory=" + this.senderThreadFactory + "\n    receiverThreadFactory=" + this.receiverThreadFactory + "\n    sharedThreadFactory=" + this.sharedThreadFactory + "\n    sharedNetworkThreadFactory=" + this.sharedNetworkThreadFactory + "\n    conductorIdleStrategy=" + this.conductorIdleStrategy + "\n    senderIdleStrategy=" + this.senderIdleStrategy + "\n    receiverIdleStrategy=" + this.receiverIdleStrategy + "\n    sharedNetworkIdleStrategy=" + this.sharedNetworkIdleStrategy + "\n    sharedIdleStrategy=" + this.sharedIdleStrategy + "\n    sendChannelEndpointSupplier=" + this.sendChannelEndpointSupplier + "\n    receiveChannelEndpointSupplier=" + this.receiveChannelEndpointSupplier + "\n    receiveChannelEndpointThreadLocals=" + this.receiveChannelEndpointThreadLocals + "\n    tempBuffer=" + this.tempBuffer + "\n    unicastFlowControlSupplier=" + this.unicastFlowControlSupplier + "\n    multicastFlowControlSupplier=" + this.multicastFlowControlSupplier + "\n    applicationSpecificFeedback=" + Arrays.toString(this.applicationSpecificFeedback) + "\n    receiverGroupTag=" + this.receiverGroupTag + "\n    flowControlGroupTag=" + this.flowControlGroupTag + "\n    flowControlGroupMinSize=" + this.flowControlGroupMinSize + "\n    flowControlReceiverTimeoutNs=" + this.flowControlReceiverTimeoutNs + "\n    reResolutionCheckIntervalNs=" + this.reResolutionCheckIntervalNs + "\n    receiverGroupConsideration=" + (Object)((Object)this.receiverGroupConsideration) + "\n    congestionControlSupplier=" + this.congestionControlSupplier + "\n    terminationValidator=" + this.terminationValidator + "\n    terminationHook=" + this.terminationHook + "\n    nameResolver=" + this.nameResolver + "\n    resolverName='" + this.resolverName + '\'' + "\n    resolverInterface='" + this.resolverInterface + '\'' + "\n    resolverBootstrapNeighbor='" + this.resolverBootstrapNeighbor + '\'' + "\n    sendToStatusMessagePollRatio=" + this.sendToStatusMessagePollRatio + "\n    unicastFeedbackDelayGenerator=" + this.unicastFeedbackDelayGenerator + "\n    multicastFeedbackDelayGenerator=" + this.multicastFeedbackDelayGenerator + "\n    retransmitUnicastDelayGenerator=" + this.retransmitUnicastDelayGenerator + "\n    retransmitUnicastLingerGenerator=" + this.retransmitUnicastLingerGenerator + "\n    errorLog=" + this.errorLog + "\n    errorHandler=" + this.errorHandler + "\n    useConcurrentCountersManager=" + this.useConcurrentCountersManager + "\n    countersManager=" + this.countersManager + "\n    systemCounters=" + this.systemCounters + "\n    lossReport=" + this.lossReport + "\n    logFactory=" + this.logFactory + "\n    dataTransportPoller=" + this.dataTransportPoller + "\n    controlTransportPoller=" + this.controlTransportPoller + "\n    driverCommandQueue=" + this.driverCommandQueue + "\n    receiverCommandQueue=" + this.receiverCommandQueue + "\n    senderCommandQueue=" + this.senderCommandQueue + "\n    receiverProxy=" + this.receiverProxy + "\n    senderProxy=" + this.senderProxy + "\n    driverConductorProxy=" + this.driverConductorProxy + "\n    clientProxy=" + this.clientProxy + "\n    toDriverCommands=" + this.toDriverCommands + "\n    lossReportBuffer=" + this.lossReportBuffer + "\n    cncByteBuffer=" + this.cncByteBuffer + "\n    cncMetaDataBuffer=" + this.cncMetaDataBuffer + "\n    channelSendTimestampClock=" + this.channelSendTimestampClock + "\n    channelReceiveTimestampClock=" + this.channelReceiveTimestampClock + "\n    conductorDutyCycleTracker=" + this.conductorDutyCycleTracker + "\n    senderDutyCycleTracker=" + this.senderDutyCycleTracker + "\n    receiverDutyCycleTracker=" + this.receiverDutyCycleTracker + "\n    senderWildcardPortRange=" + this.senderWildcardPortRange + "\n    receiverWildcardPortRange=" + this.receiverWildcardPortRange + "\n    senderPortManager=" + this.senderPortManager + "\n    receiverPortManager=" + this.receiverPortManager + "\n    resourceFreeLimit=" + this.resourceFreeLimit + "\n    asyncTaskExecutorThreads=" + this.asyncTaskExecutorThreads + "\n    asyncTaskExecutor=" + this.asyncTaskExecutor + "\n    maxResend=" + this.maxResend + "\n}";
        }
    }
}

