/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import io.aeron.AeronCounters;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public enum SystemCounterDescriptor {
    BYTES_SENT(0, "Bytes sent"),
    BYTES_RECEIVED(1, "Bytes received"),
    RECEIVER_PROXY_FAILS(2, "Failed offers to ReceiverProxy"),
    SENDER_PROXY_FAILS(3, "Failed offers to SenderProxy"),
    CONDUCTOR_PROXY_FAILS(4, "Failed offers to DriverConductorProxy"),
    NAK_MESSAGES_SENT(5, "NAKs sent"),
    NAK_MESSAGES_RECEIVED(6, "NAKs received"),
    STATUS_MESSAGES_SENT(7, "Status Messages sent"),
    STATUS_MESSAGES_RECEIVED(8, "Status Messages received"),
    HEARTBEATS_SENT(9, "Heartbeats sent"),
    HEARTBEATS_RECEIVED(10, "Heartbeats received"),
    RETRANSMITS_SENT(11, "Retransmits sent"),
    FLOW_CONTROL_UNDER_RUNS(12, "Flow control under runs"),
    FLOW_CONTROL_OVER_RUNS(13, "Flow control over runs"),
    INVALID_PACKETS(14, "Invalid packets"),
    ERRORS(15, "Errors: " + AeronCounters.formatVersionInfo("1.45.0", "724778ac0e")),
    SHORT_SENDS(16, "Short sends"),
    FREE_FAILS(17, "Failed attempts to free log buffers"),
    SENDER_FLOW_CONTROL_LIMITS(18, "Sender flow control limits, i.e. back-pressure events"),
    UNBLOCKED_PUBLICATIONS(19, "Unblocked Publications"),
    UNBLOCKED_COMMANDS(20, "Unblocked Control Commands"),
    POSSIBLE_TTL_ASYMMETRY(21, "Possible TTL Asymmetry"),
    CONTROLLABLE_IDLE_STRATEGY(22, "ControllableIdleStrategy status"),
    LOSS_GAP_FILLS(23, "Loss gap fills"),
    CLIENT_TIMEOUTS(24, "Client liveness timeouts"),
    RESOLUTION_CHANGES(25, "Resolution changes"),
    CONDUCTOR_MAX_CYCLE_TIME(26, "Conductor max cycle time doing its work in ns"),
    CONDUCTOR_CYCLE_TIME_THRESHOLD_EXCEEDED(27, "Conductor work cycle exceeded threshold count"),
    SENDER_MAX_CYCLE_TIME(28, "Sender max cycle time doing its work in ns"),
    SENDER_CYCLE_TIME_THRESHOLD_EXCEEDED(29, "Sender work cycle exceeded threshold count"),
    RECEIVER_MAX_CYCLE_TIME(30, "Receiver max cycle time doing its work in ns"),
    RECEIVER_CYCLE_TIME_THRESHOLD_EXCEEDED(31, "Receiver work cycle exceeded threshold count"),
    NAME_RESOLVER_MAX_TIME(32, "NameResolver max time in ns"),
    NAME_RESOLVER_TIME_THRESHOLD_EXCEEDED(33, "NameResolver exceeded threshold count"),
    AERON_VERSION(34, "Aeron software: " + AeronCounters.formatVersionInfo("1.45.0", "724778ac0e")),
    BYTES_CURRENTLY_MAPPED(35, "Bytes currently mapped"),
    RETRANSMITTED_BYTES(36, "Retransmitted bytes"),
    RETRANSMIT_OVERFLOW(37, "Retransmit Pool Overflow count");

    public static final int SYSTEM_COUNTER_TYPE_ID = 0;
    private static final Int2ObjectHashMap<SystemCounterDescriptor> DESCRIPTOR_BY_ID_MAP;
    private final int id;
    private final String label;

    public static SystemCounterDescriptor get(int id) {
        return DESCRIPTOR_BY_ID_MAP.get(id);
    }

    private SystemCounterDescriptor(int id, String label) {
        this.id = id;
        this.label = label;
    }

    public int id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public AtomicCounter newCounter(CountersManager countersManager) {
        AtomicCounter counter = countersManager.newCounter(this.label, 0, buffer -> buffer.putInt(0, this.id));
        countersManager.setCounterRegistrationId(counter.id(), this.id);
        countersManager.setCounterOwnerId(counter.id(), -1L);
        return counter;
    }

    static {
        DESCRIPTOR_BY_ID_MAP = new Int2ObjectHashMap();
        for (SystemCounterDescriptor descriptor : SystemCounterDescriptor.values()) {
            if (null == DESCRIPTOR_BY_ID_MAP.put(descriptor.id, descriptor)) continue;
            throw new IllegalStateException("Descriptor id already in use: " + descriptor.id);
        }
    }
}

