/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.shadow.net.bytebuddy.matcher;

import io.aeron.shadow.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.aeron.shadow.net.bytebuddy.description.ByteCodeElement;
import io.aeron.shadow.net.bytebuddy.description.type.TypeDescription;
import io.aeron.shadow.net.bytebuddy.matcher.ElementMatcher;
import io.aeron.shadow.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class AccessibilityMatcher<T extends ByteCodeElement>
extends ElementMatcher.Junction.ForNonNullValues<T> {
    private final TypeDescription typeDescription;

    public AccessibilityMatcher(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    @Override
    protected boolean doMatch(T target) {
        return target.isAccessibleTo(this.typeDescription);
    }

    public String toString() {
        return "isAccessibleTo(" + this.typeDescription + ")";
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeDescription.equals(((AccessibilityMatcher)object).typeDescription);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.typeDescription.hashCode();
    }
}

