/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.ErrorCode;
import io.aeron.command.ClientTimeoutFlyweight;
import io.aeron.command.CounterUpdateFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.OperationSucceededFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.command.StaticCounterFlyweight;
import io.aeron.command.SubscriptionReadyFlyweight;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;

class DriverEventsAdapter
implements MessageHandler {
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final SubscriptionReadyFlyweight subscriptionReady = new SubscriptionReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final OperationSucceededFlyweight operationSucceeded = new OperationSucceededFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();
    private final CounterUpdateFlyweight counterUpdate = new CounterUpdateFlyweight();
    private final ClientTimeoutFlyweight clientTimeout = new ClientTimeoutFlyweight();
    private final StaticCounterFlyweight staticCounter = new StaticCounterFlyweight();
    private final CopyBroadcastReceiver receiver;
    private final ClientConductor conductor;
    private final LongHashSet asyncCommandIdSet;
    private final long clientId;
    private long activeCorrelationId;
    private long receivedCorrelationId;
    private boolean isInvalid;

    DriverEventsAdapter(long clientId, CopyBroadcastReceiver receiver, ClientConductor conductor, LongHashSet asyncCommandIdSet) {
        this.clientId = clientId;
        this.receiver = receiver;
        this.conductor = conductor;
        this.asyncCommandIdSet = asyncCommandIdSet;
    }

    int receive(long activeCorrelationId) {
        this.activeCorrelationId = activeCorrelationId;
        this.receivedCorrelationId = -1L;
        try {
            return this.receiver.receive(this);
        }
        catch (IllegalStateException ex) {
            this.isInvalid = true;
            throw ex;
        }
    }

    long receivedCorrelationId() {
        return this.receivedCorrelationId;
    }

    boolean isInvalid() {
        return this.isInvalid;
    }

    long clientId() {
        return this.clientId;
    }

    @Override
    public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        switch (msgTypeId) {
            case 3841: {
                this.errorResponse.wrap(buffer, index);
                long correlationId = this.errorResponse.offendingCommandCorrelationId();
                int errorCodeValue = this.errorResponse.errorCodeValue();
                ErrorCode errorCode = ErrorCode.get(errorCodeValue);
                boolean notProcessed = true;
                if (ErrorCode.CHANNEL_ENDPOINT_ERROR == errorCode) {
                    notProcessed = false;
                    this.conductor.onChannelEndpointError(correlationId, this.errorResponse.errorMessage());
                } else if (correlationId == this.activeCorrelationId) {
                    notProcessed = false;
                    this.receivedCorrelationId = correlationId;
                    this.conductor.onError(correlationId, errorCodeValue, errorCode, this.errorResponse.errorMessage());
                }
                if (!this.asyncCommandIdSet.remove(correlationId) || !notProcessed) break;
                this.conductor.onAsyncError(correlationId, errorCodeValue, errorCode, this.errorResponse.errorMessage());
                break;
            }
            case 3842: {
                this.imageReady.wrap(buffer, index);
                this.conductor.onAvailableImage(this.imageReady.correlationId(), this.imageReady.sessionId(), this.imageReady.subscriptionRegistrationId(), this.imageReady.subscriberPositionId(), this.imageReady.logFileName(), this.imageReady.sourceIdentity());
                break;
            }
            case 3843: {
                this.publicationReady.wrap(buffer, index);
                long correlationId = this.publicationReady.correlationId();
                if (correlationId != this.activeCorrelationId && !this.asyncCommandIdSet.remove(correlationId)) break;
                this.receivedCorrelationId = correlationId;
                this.conductor.onNewPublication(correlationId, this.publicationReady.registrationId(), this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.publicationReady.channelStatusCounterId(), this.publicationReady.logFileName());
                break;
            }
            case 3847: {
                this.subscriptionReady.wrap(buffer, index);
                long correlationId = this.subscriptionReady.correlationId();
                if (correlationId != this.activeCorrelationId && !this.asyncCommandIdSet.remove(correlationId)) break;
                this.receivedCorrelationId = correlationId;
                this.conductor.onNewSubscription(correlationId, this.subscriptionReady.channelStatusCounterId());
                break;
            }
            case 3844: {
                this.operationSucceeded.wrap(buffer, index);
                long correlationId = this.operationSucceeded.correlationId();
                this.asyncCommandIdSet.remove(correlationId);
                if (correlationId != this.activeCorrelationId) break;
                this.receivedCorrelationId = correlationId;
                break;
            }
            case 3845: {
                this.imageMessage.wrap(buffer, index);
                this.conductor.onUnavailableImage(this.imageMessage.correlationId(), this.imageMessage.subscriptionRegistrationId());
                break;
            }
            case 3846: {
                this.publicationReady.wrap(buffer, index);
                long correlationId = this.publicationReady.correlationId();
                if (correlationId != this.activeCorrelationId && !this.asyncCommandIdSet.remove(correlationId)) break;
                this.receivedCorrelationId = correlationId;
                this.conductor.onNewExclusivePublication(correlationId, this.publicationReady.registrationId(), this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.publicationReady.channelStatusCounterId(), this.publicationReady.logFileName());
                break;
            }
            case 3848: {
                this.counterUpdate.wrap(buffer, index);
                int counterId = this.counterUpdate.counterId();
                long correlationId = this.counterUpdate.correlationId();
                if (correlationId == this.activeCorrelationId) {
                    this.receivedCorrelationId = correlationId;
                    this.conductor.onNewCounter(correlationId, counterId);
                    break;
                }
                this.conductor.onAvailableCounter(correlationId, counterId);
                break;
            }
            case 3849: {
                this.counterUpdate.wrap(buffer, index);
                this.conductor.onUnavailableCounter(this.counterUpdate.correlationId(), this.counterUpdate.counterId());
                break;
            }
            case 3850: {
                this.clientTimeout.wrap(buffer, index);
                if (this.clientTimeout.clientId() != this.clientId) break;
                this.conductor.onClientTimeout();
                break;
            }
            case 3851: {
                this.staticCounter.wrap(buffer, index);
                long correlationId = this.staticCounter.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                int counterId = this.staticCounter.counterId();
                this.receivedCorrelationId = correlationId;
                this.conductor.onStaticCounter(correlationId, counterId);
                break;
            }
        }
    }
}

