/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ArchiveEventDissector;
import io.aeron.agent.DissectFunction;
import io.aeron.agent.EventCode;
import io.aeron.agent.EventCodeType;
import java.util.Arrays;
import java.util.function.ToIntFunction;
import org.agrona.MutableDirectBuffer;

public enum ArchiveEventCode implements EventCode
{
    CMD_IN_CONNECT(1, 2, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_CLOSE_SESSION(2, 3, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_START_RECORDING(3, 4, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_STOP_RECORDING(4, 5, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_REPLAY(5, 6, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_STOP_REPLAY(6, 7, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_LIST_RECORDINGS(7, 8, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_LIST_RECORDINGS_FOR_URI(8, 9, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_LIST_RECORDING(9, 10, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_EXTEND_RECORDING(10, 11, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_RECORDING_POSITION(11, 12, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_TRUNCATE_RECORDING(12, 13, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_STOP_RECORDING_SUBSCRIPTION(13, 14, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_STOP_POSITION(14, 15, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_FIND_LAST_MATCHING_RECORD(15, 16, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_LIST_RECORDING_SUBSCRIPTIONS(16, 17, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_START_BOUNDED_REPLAY(17, 18, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_STOP_ALL_REPLAYS(18, 19, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_REPLICATE(19, 50, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_STOP_REPLICATION(20, 51, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_START_POSITION(21, 52, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_DETACH_SEGMENTS(22, 53, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_DELETE_DETACHED_SEGMENTS(23, 54, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_PURGE_SEGMENTS(24, 55, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_ATTACH_SEGMENTS(25, 56, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_MIGRATE_SEGMENTS(26, 57, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_AUTH_CONNECT(27, 58, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_KEEP_ALIVE(28, 61, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_TAGGED_REPLICATE(29, 62, ArchiveEventDissector::dissectControlRequest),
    CMD_OUT_RESPONSE(30, 1, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectControlResponse(buffer, offset, builder)),
    CMD_IN_START_RECORDING2(31, 63, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_EXTEND_RECORDING2(32, 64, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_STOP_RECORDING_BY_IDENTITY(33, 65, ArchiveEventDissector::dissectControlRequest),
    REPLICATION_SESSION_STATE_CHANGE(34, -1, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectReplicationSessionStateChange(buffer, offset, builder)),
    CONTROL_SESSION_STATE_CHANGE(35, -1, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectControlSessionStateChange(buffer, offset, builder)),
    REPLAY_SESSION_ERROR(36, -1, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectReplaySessionError(buffer, offset, builder)),
    CATALOG_RESIZE(37, -1, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectCatalogResize(buffer, offset, builder)),
    CMD_IN_PURGE_RECORDING(38, 104, ArchiveEventDissector::dissectControlRequest),
    CMD_IN_REPLICATE2(39, 66, ArchiveEventDissector::dissectControlRequest),
    RECORDING_SIGNAL(40, 24, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectRecordingSignal(buffer, offset, builder)),
    REPLICATION_SESSION_DONE(41, -1, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectReplicationSessionDone(buffer, offset, builder)),
    CMD_IN_REQUEST_REPLAY_TOKEN(42, 105, ArchiveEventDissector::dissectControlRequest),
    REPLAY_SESSION_STATE_CHANGE(43, -1, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectReplaySessionStateChange(buffer, offset, builder)),
    RECORDING_SESSION_STATE_CHANGE(44, -1, (event, buffer, offset, builder) -> ArchiveEventDissector.dissectRecordingSessionStateChange(buffer, offset, builder)),
    CMD_IN_MAX_RECORDED_POSITION(45, 67, ArchiveEventDissector::dissectControlRequest);

    static final int EVENT_CODE_TYPE;
    private static final ArchiveEventCode[] EVENT_CODE_BY_ID;
    private static final ArchiveEventCode[] EVENT_CODE_BY_TEMPLATE_ID;
    private final int id;
    private final int templateId;
    private final DissectFunction<ArchiveEventCode> dissector;

    private static ArchiveEventCode[] createLookupArray(ArchiveEventCode[] codes, ToIntFunction<ArchiveEventCode> idSupplier) {
        int maxId = Arrays.stream(codes).mapToInt(idSupplier).max().orElse(0);
        if (maxId > 100000) {
            throw new IllegalStateException("length of the lookup array exceeds 100000: " + maxId);
        }
        ArchiveEventCode[] array = new ArchiveEventCode[maxId + 1];
        for (ArchiveEventCode code : codes) {
            int id = idSupplier.applyAsInt(code);
            if (id < 0) continue;
            if (null != array[id]) {
                throw new IllegalArgumentException("id already in use: " + id);
            }
            array[id] = code;
        }
        return array;
    }

    private ArchiveEventCode(int id, int templateId, DissectFunction<ArchiveEventCode> dissector) {
        this.id = id;
        this.templateId = templateId;
        this.dissector = dissector;
    }

    static ArchiveEventCode get(int id) {
        if (id < 0 || id >= EVENT_CODE_BY_ID.length) {
            throw new IllegalArgumentException("no ArchiveEventCode for id: " + id);
        }
        ArchiveEventCode code = EVENT_CODE_BY_ID[id];
        if (null == code) {
            throw new IllegalArgumentException("no ArchiveEventCode for id: " + id);
        }
        return code;
    }

    static ArchiveEventCode getByTemplateId(int templateId) {
        return templateId >= 0 && templateId < EVENT_CODE_BY_TEMPLATE_ID.length ? EVENT_CODE_BY_TEMPLATE_ID[templateId] : null;
    }

    @Override
    public int id() {
        return this.id;
    }

    public int templateId() {
        return this.templateId;
    }

    public int toEventCodeId() {
        return EVENT_CODE_TYPE << 16 | this.id & 0xFFFF;
    }

    public static ArchiveEventCode fromEventCodeId(int eventCodeId) {
        return ArchiveEventCode.get(eventCodeId - (EVENT_CODE_TYPE << 16));
    }

    public void decode(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        this.dissector.dissect(this, buffer, offset, builder);
    }

    static {
        EVENT_CODE_TYPE = EventCodeType.ARCHIVE.getTypeCode();
        ArchiveEventCode[] codes = ArchiveEventCode.values();
        EVENT_CODE_BY_ID = ArchiveEventCode.createLookupArray(codes, ArchiveEventCode::id);
        EVENT_CODE_BY_TEMPLATE_ID = ArchiveEventCode.createLookupArray(codes, ArchiveEventCode::templateId);
    }
}

