/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ArchiveComponentLogger;
import io.aeron.agent.ArchiveEventCode;
import io.aeron.agent.ArchiveEventEncoder;
import io.aeron.agent.CommonEventEncoder;
import io.aeron.agent.EventConfiguration;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import java.util.EnumSet;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public final class ArchiveEventLogger {
    public static final ArchiveEventLogger LOGGER = new ArchiveEventLogger(EventConfiguration.EVENT_RING_BUFFER);
    static final EnumSet<ArchiveEventCode> CONTROL_REQUEST_EVENTS = EnumSet.complementOf(EnumSet.of(ArchiveEventCode.CMD_OUT_RESPONSE, new ArchiveEventCode[]{ArchiveEventCode.REPLICATION_SESSION_STATE_CHANGE, ArchiveEventCode.CONTROL_SESSION_STATE_CHANGE, ArchiveEventCode.REPLAY_SESSION_ERROR, ArchiveEventCode.CATALOG_RESIZE, ArchiveEventCode.RECORDING_SIGNAL, ArchiveEventCode.REPLICATION_SESSION_DONE, ArchiveEventCode.REPLAY_SESSION_STATE_CHANGE, ArchiveEventCode.RECORDING_SESSION_STATE_CHANGE}));
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ManyToOneRingBuffer ringBuffer;

    ArchiveEventLogger(ManyToOneRingBuffer eventRingBuffer) {
        this.ringBuffer = eventRingBuffer;
    }

    public void logControlRequest(DirectBuffer buffer, int offset, int length) {
        this.headerDecoder.wrap(buffer, offset);
        int templateId = this.headerDecoder.templateId();
        ArchiveEventCode eventCode = ArchiveEventCode.getByTemplateId(templateId);
        if (eventCode != null && ArchiveComponentLogger.ENABLED_EVENTS.contains(eventCode)) {
            this.log(eventCode, buffer, offset, length);
        }
    }

    public void logControlResponse(DirectBuffer buffer, int offset, int length) {
        this.log(ArchiveEventCode.CMD_OUT_RESPONSE, buffer, offset, length);
    }

    public void logRecordingSignal(DirectBuffer buffer, int offset, int length) {
        this.log(ArchiveEventCode.RECORDING_SIGNAL, buffer, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Enum<E>> void logReplaySessionStateChange(E oldState, E newState, long sessionId, long recordingId, long position, String reason) {
        int length = ArchiveEventEncoder.replaySessionStateChangeLength(oldState, newState, reason);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ArchiveEventCode.REPLAY_SESSION_STATE_CHANGE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ArchiveEventEncoder.encodeReplaySessionStateChange((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, oldState, newState, sessionId, recordingId, position, reason);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Enum<E>> void logRecordingSessionStateChange(E oldState, E newState, long recordingId, long position, String reason) {
        int length = ArchiveEventEncoder.recordingSessionStateChangeLength(oldState, newState, reason);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ArchiveEventCode.RECORDING_SESSION_STATE_CHANGE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ArchiveEventEncoder.encodeRecordingSessionStateChange((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, oldState, newState, recordingId, position, reason);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Enum<E>> void logReplicationSessionStateChange(E oldState, E newState, long replicationId, long srcRecordingId, long dstRecordingId, long position, String reason) {
        int length = ArchiveEventEncoder.replicationSessionStateChangeLength(oldState, newState, reason);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ArchiveEventCode.RECORDING_SESSION_STATE_CHANGE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ArchiveEventEncoder.encodeReplicationSessionStateChange((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, oldState, newState, replicationId, srcRecordingId, dstRecordingId, position, reason);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Enum<E>> void logControlSessionStateChange(E oldState, E newState, long controlSessionId) {
        int length = ArchiveEventEncoder.sessionStateChangeLength(oldState, newState);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ArchiveEventCode.CONTROL_SESSION_STATE_CHANGE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ArchiveEventEncoder.encodeSessionStateChange((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, oldState, newState, controlSessionId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logReplicationSessionDone(long controlSessionId, long replicationId, long srcRecordingId, long replayPosition, long srcStopPosition, long dstRecordingId, long dstStopPosition, long position, boolean isClosed, boolean isEndOfStream, boolean isSynced) {
        int length = ArchiveEventEncoder.replicationSessionDoneLength();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ArchiveEventCode.REPLICATION_SESSION_DONE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ArchiveEventEncoder.encodeReplicationSessionDone((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, controlSessionId, replicationId, srcRecordingId, replayPosition, srcStopPosition, dstRecordingId, dstStopPosition, position, isClosed, isEndOfStream, isSynced);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logReplaySessionError(long sessionId, long recordingId, String errorMessage) {
        int length = 20 + errorMessage.length();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ArchiveEventCode.REPLAY_SESSION_ERROR.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ArchiveEventEncoder.encodeReplaySessionError((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, sessionId, recordingId, errorMessage);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logCatalogResize(long oldCatalogLength, long newCatalogLength) {
        int length = 16;
        int captureLength = CommonEventEncoder.captureLength(16);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ArchiveEventCode.CATALOG_RESIZE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ArchiveEventEncoder.encodeCatalogResize((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, 16, oldCatalogLength, newCatalogLength);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(ArchiveEventCode eventCode, DirectBuffer buffer, int offset, int length) {
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(eventCode.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                CommonEventEncoder.encode((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, buffer, offset);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }
}

