/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ClusterEventCode;
import io.aeron.agent.ClusterInterceptor;
import io.aeron.agent.ComponentLogger;
import io.aeron.agent.EventCodeType;
import io.aeron.agent.EventConfiguration;
import io.aeron.shadow.net.bytebuddy.agent.builder.AgentBuilder;
import io.aeron.shadow.net.bytebuddy.asm.Advice;
import io.aeron.shadow.net.bytebuddy.matcher.ElementMatchers;
import java.util.EnumSet;
import java.util.Map;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Object2ObjectHashMap;

public class ClusterComponentLogger
implements ComponentLogger {
    static final EnumSet<ClusterEventCode> ENABLED_EVENTS = EnumSet.noneOf(ClusterEventCode.class);
    private static final Object2ObjectHashMap<String, EnumSet<ClusterEventCode>> SPECIAL_EVENTS = new Object2ObjectHashMap();

    @Override
    public int typeCode() {
        return EventCodeType.CLUSTER.getTypeCode();
    }

    @Override
    public void decode(MutableDirectBuffer buffer, int offset, int eventCodeId, StringBuilder builder) {
        ClusterEventCode.get(eventCodeId).decode(buffer, offset, builder);
    }

    @Override
    public AgentBuilder addInstrumentation(AgentBuilder agentBuilder, Map<String, String> configOptions) {
        ENABLED_EVENTS.clear();
        ENABLED_EVENTS.addAll(ClusterComponentLogger.getClusterEventCodes(configOptions.get("aeron.event.cluster.log")));
        ENABLED_EVENTS.removeAll(ClusterComponentLogger.getClusterEventCodes(configOptions.get("aeron.event.cluster.log.disable")));
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.ELECTION_STATE_CHANGE, "Election", ClusterInterceptor.ElectionStateChange.class, "logStateChange");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.TRUNCATE_LOG_ENTRY, "Election", ClusterInterceptor.TruncateLogEntry.class, "onTruncateLogEntry");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.REPLAY_NEW_LEADERSHIP_TERM, "ConsensusModuleAgent", ClusterInterceptor.ReplayNewLeadershipTerm.class, "logOnReplayNewLeadershipTermEvent");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.APPEND_POSITION, "ConsensusModuleAgent", ClusterInterceptor.AppendPosition.class, "logOnAppendPosition");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.COMMIT_POSITION, "ConsensusModuleAgent", ClusterInterceptor.CommitPosition.class, "logOnCommitPosition");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.ADD_PASSIVE_MEMBER, "ConsensusModuleAgent", ClusterInterceptor.AddPassiveMember.class, "logOnAddPassiveMember");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.APPEND_SESSION_CLOSE, "LogPublisher", ClusterInterceptor.AppendSessionClose.class, "logAppendSessionClose");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.CLUSTER_BACKUP_STATE_CHANGE, "ClusterBackupAgent", ClusterInterceptor.ClusterBackupStateChange.class, "logStateChange");
        tempBuilder = ClusterComponentLogger.addClusterConsensusModuleAgentInstrumentation(tempBuilder);
        return tempBuilder;
    }

    @Override
    public void reset() {
        ENABLED_EVENTS.clear();
    }

    private static EnumSet<ClusterEventCode> getClusterEventCodes(String enabledEventCodes) {
        return EventConfiguration.parseEventCodes(ClusterEventCode.class, enabledEventCodes, SPECIAL_EVENTS, ClusterEventCode::get, ClusterEventCode::valueOf);
    }

    private static AgentBuilder addClusterConsensusModuleAgentInstrumentation(AgentBuilder agentBuilder) {
        AgentBuilder tempBuilder = agentBuilder;
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.STATE_CHANGE, "ConsensusModuleAgent", ClusterInterceptor.ConsensusModuleStateChange.class, "logStateChange");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.ROLE_CHANGE, "ConsensusModuleAgent", ClusterInterceptor.ConsensusModuleRoleChange.class, "logRoleChange");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.NEW_LEADERSHIP_TERM, "ConsensusModuleAgent", ClusterInterceptor.NewLeadershipTerm.class, "logOnNewLeadershipTerm");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.CANVASS_POSITION, "ConsensusModuleAgent", ClusterInterceptor.CanvassPosition.class, "logOnCanvassPosition");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.REQUEST_VOTE, "ConsensusModuleAgent", ClusterInterceptor.RequestVote.class, "logOnRequestVote");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.CATCHUP_POSITION, "ConsensusModuleAgent", ClusterInterceptor.CatchupPosition.class, "logOnCatchupPosition");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.STOP_CATCHUP, "ConsensusModuleAgent", ClusterInterceptor.StopCatchup.class, "logOnStopCatchup");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.TERMINATION_POSITION, "ConsensusModuleAgent", ClusterInterceptor.TerminationPosition.class, "logOnTerminationPosition");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.TERMINATION_ACK, "ConsensusModuleAgent", ClusterInterceptor.TerminationAck.class, "logOnTerminationAck");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.SERVICE_ACK, "ConsensusModuleAgent", ClusterInterceptor.ServiceAck.class, "logOnServiceAck");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.REPLICATION_ENDED, "ConsensusModuleAgent", ClusterInterceptor.ReplicationEnded.class, "logReplicationEnded");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.STANDBY_SNAPSHOT_NOTIFICATION, "ConsensusModuleAgent", ClusterInterceptor.StandbySnapshotNotification.class, "logStandbySnapshotNotification");
        tempBuilder = ClusterComponentLogger.addEventInstrumentation(tempBuilder, ClusterEventCode.NEW_ELECTION, "ConsensusModuleAgent", ClusterInterceptor.NewElection.class, "logNewElection");
        return tempBuilder;
    }

    private static AgentBuilder addEventInstrumentation(AgentBuilder agentBuilder, ClusterEventCode code, String typeName, Class<?> interceptorClass, String interceptorMethod) {
        if (!ENABLED_EVENTS.contains(code)) {
            return agentBuilder;
        }
        return agentBuilder.type(ElementMatchers.nameEndsWith(typeName)).transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> builder.visit(Advice.to(interceptorClass).on(ElementMatchers.named(interceptorMethod))));
    }

    static {
        SPECIAL_EVENTS.put("all", EnumSet.allOf(ClusterEventCode.class));
    }
}

