/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ClusterEventDissector;
import io.aeron.agent.DissectFunction;
import io.aeron.agent.EventCode;
import io.aeron.agent.EventCodeType;
import java.util.Arrays;
import org.agrona.MutableDirectBuffer;

public enum ClusterEventCode implements EventCode
{
    ELECTION_STATE_CHANGE(1, (eventCode, buffer, offset, builder) -> ClusterEventDissector.dissectElectionStateChange(buffer, offset, builder)),
    NEW_LEADERSHIP_TERM(2, (eventCode, buffer, offset, builder) -> ClusterEventDissector.dissectNewLeadershipTerm(buffer, offset, builder)),
    STATE_CHANGE(3, ClusterEventDissector::dissectStateChange),
    ROLE_CHANGE(4, ClusterEventDissector::dissectStateChange),
    CANVASS_POSITION(5, ClusterEventDissector::dissectCanvassPosition),
    REQUEST_VOTE(6, ClusterEventDissector::dissectRequestVote),
    CATCHUP_POSITION(7, ClusterEventDissector::dissectCatchupPosition),
    STOP_CATCHUP(8, ClusterEventDissector::dissectStopCatchup),
    TRUNCATE_LOG_ENTRY(9, ClusterEventDissector::dissectTruncateLogEntry),
    REPLAY_NEW_LEADERSHIP_TERM(10, ClusterEventDissector::dissectReplayNewLeadershipTerm),
    APPEND_POSITION(11, ClusterEventDissector::dissectAppendPosition),
    COMMIT_POSITION(12, ClusterEventDissector::dissectCommitPosition),
    ADD_PASSIVE_MEMBER(13, ClusterEventDissector::dissectAddPassiveMember),
    APPEND_SESSION_CLOSE(14, ClusterEventDissector::dissectAppendCloseSession),
    DYNAMIC_JOIN_STATE_CHANGE_UNUSED(15, ClusterEventDissector::dissectNoOp),
    CLUSTER_BACKUP_STATE_CHANGE(16, ClusterEventDissector::dissectStateChange),
    TERMINATION_POSITION(17, ClusterEventDissector::dissectTerminationPosition),
    TERMINATION_ACK(18, ClusterEventDissector::dissectTerminationAck),
    SERVICE_ACK(19, ClusterEventDissector::dissectServiceAck),
    REPLICATION_ENDED(20, ClusterEventDissector::dissectReplicationEnded),
    STANDBY_SNAPSHOT_NOTIFICATION(21, ClusterEventDissector::dissectStandbySnapshotNotification),
    NEW_ELECTION(22, ClusterEventDissector::dissectNewElection);

    static final int EVENT_CODE_TYPE;
    private static final ClusterEventCode[] EVENT_CODE_BY_ID;
    private final int id;
    private final DissectFunction<ClusterEventCode> dissector;

    private ClusterEventCode(int id, DissectFunction<ClusterEventCode> dissector) {
        this.id = id;
        this.dissector = dissector;
    }

    static ClusterEventCode get(int id) {
        if (id < 0 || id >= EVENT_CODE_BY_ID.length) {
            throw new IllegalArgumentException("no ClusterEventCode for id: " + id);
        }
        ClusterEventCode code = EVENT_CODE_BY_ID[id];
        if (null == code) {
            throw new IllegalArgumentException("no ClusterEventCode for id: " + id);
        }
        return code;
    }

    @Override
    public int id() {
        return this.id;
    }

    public int toEventCodeId() {
        return EVENT_CODE_TYPE << 16 | this.id & 0xFFFF;
    }

    public static ClusterEventCode fromEventCodeId(int eventCodeId) {
        return ClusterEventCode.get(eventCodeId - (EVENT_CODE_TYPE << 16));
    }

    public void decode(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        this.dissector.dissect(this, buffer, offset, builder);
    }

    static {
        EVENT_CODE_TYPE = EventCodeType.CLUSTER.getTypeCode();
        ClusterEventCode[] codes = ClusterEventCode.values();
        int maxId = Arrays.stream(codes).mapToInt(ClusterEventCode::id).max().orElse(0);
        EVENT_CODE_BY_ID = new ClusterEventCode[maxId + 1];
        for (ClusterEventCode code : codes) {
            int id = code.id();
            if (null != EVENT_CODE_BY_ID[id]) {
                throw new IllegalArgumentException("id already in use: " + id);
            }
            ClusterEventCode.EVENT_CODE_BY_ID[id] = code;
        }
    }
}

