/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ClusterEventCode;
import io.aeron.agent.CommonEventDissector;
import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;

final class ClusterEventDissector {
    static final String CONTEXT = "CLUSTER";

    private ClusterEventDissector() {
    }

    static void dissectNewLeadershipTerm(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, ClusterEventCode.NEW_LEADERSHIP_TERM, buffer, absoluteOffset, builder);
        long logLeadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long nextLeadershipTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long nextTermBaseLogPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long nextLogPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long leadershipTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long termBaseLogPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long leaderRecordingId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long timestamp = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int leaderId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        int logSessionId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        int appVersion = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        boolean isStartup = 1 == buffer.getByte(absoluteOffset += 4);
        builder.append(": memberId=").append(memberId).append(" logLeadershipTermId=").append(logLeadershipTermId).append(" nextLeadershipTermId=").append(nextLeadershipTermId).append(" nextTermBaseLogPosition=").append(nextTermBaseLogPosition).append(" nextLogPosition=").append(nextLogPosition).append(" leadershipTermId=").append(leadershipTermId).append(" termBaseLogPosition=").append(termBaseLogPosition).append(" logPosition=").append(logPosition).append(" leaderRecordingId=").append(leaderRecordingId).append(" timestamp=").append(timestamp).append(" leaderId=").append(leaderId).append(" logSessionId=").append(logSessionId).append(" appVersion=");
        ClusterEventDissector.appendSemanticVersion(appVersion, builder);
        builder.append(" isStartup=").append(isStartup);
    }

    private static void appendSemanticVersion(int version, StringBuilder builder) {
        builder.append(SemanticVersion.major(version)).append('.').append(SemanticVersion.minor(version)).append('.').append(SemanticVersion.patch(version));
    }

    static void dissectStateChange(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        int memberId = buffer.getInt(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        builder.append(": memberId=").append(memberId);
        builder.append(' ');
        buffer.getStringAscii(absoluteOffset += 4, builder);
    }

    static void dissectNoOp(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
    }

    static void dissectElectionStateChange(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, ClusterEventCode.ELECTION_STATE_CHANGE, buffer, absoluteOffset, builder);
        long candidateTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long leadershipTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long logLeadershipTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long appendPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long catchupPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int leaderId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId).append(' ');
        absoluteOffset += 4 + buffer.getStringAscii(absoluteOffset, builder);
        builder.append(" leaderId=").append(leaderId);
        builder.append(" candidateTermId=").append(candidateTermId);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" logLeadershipTermId=").append(logLeadershipTermId);
        builder.append(" appendPosition=").append(appendPosition);
        builder.append(" catchupPosition=").append(catchupPosition);
        builder.append(" reason=");
        buffer.getStringAscii(absoluteOffset, builder);
    }

    static void dissectCanvassPosition(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long logLeadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long leadershipTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int followerMemberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int protocolVersion = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        builder.append(": memberId=").append(memberId);
        builder.append(" logLeadershipTermId=").append(logLeadershipTermId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" followerMemberId=").append(followerMemberId);
        builder.append(" protocolVersion=");
        ClusterEventDissector.appendSemanticVersion(protocolVersion, builder);
    }

    static void dissectRequestVote(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long logLeadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long candidateTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int candidateId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int protocolVersion = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        builder.append(": memberId=").append(memberId);
        builder.append(" logLeadershipTermId=").append(logLeadershipTermId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" candidateTermId=").append(candidateTermId);
        builder.append(" candidateId=").append(candidateId);
        builder.append(" protocolVersion=");
        ClusterEventDissector.appendSemanticVersion(protocolVersion, builder);
    }

    static void dissectCatchupPosition(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long leadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int followerMemberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        int catchupEndpointLength = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" followerMemberId=").append(followerMemberId);
        builder.append(" catchupEndpoint=");
        buffer.getStringWithoutLengthAscii(absoluteOffset, catchupEndpointLength, builder);
    }

    static void dissectStopCatchup(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long leadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        int followerMemberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        builder.append(": memberId=").append(memberId);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" followerMemberId=").append(followerMemberId);
    }

    static void dissectTruncateLogEntry(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long logLeadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long leadershipTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long candidateTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long commitPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long appendPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long oldPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long newPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        builder.append(": memberId=").append(memberId);
        builder.append(" state=");
        buffer.getStringAscii(absoluteOffset += 4, builder, ByteOrder.LITTLE_ENDIAN);
        builder.append(" logLeadershipTermId=").append(logLeadershipTermId);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" candidateTermId=").append(candidateTermId);
        builder.append(" commitPosition=").append(commitPosition);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" appendPosition=").append(appendPosition);
        builder.append(" oldPosition=").append(oldPosition);
        builder.append(" newPosition=").append(newPosition);
    }

    public static void dissectReplayNewLeadershipTerm(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long leadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long timestamp = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long termBaseLogPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int appVersion = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        boolean isInElection = 0 != buffer.getByte(absoluteOffset += 4);
        int timeUnitLength = buffer.getInt(++absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" isInElection=").append(isInElection);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" termBaseLogPosition=").append(termBaseLogPosition);
        builder.append(" appVersion=").append(appVersion);
        builder.append(" timestamp=").append(timestamp);
        builder.append(" timeUnit=");
        buffer.getStringWithoutLengthAscii(absoluteOffset, timeUnitLength, builder);
    }

    public static void dissectAppendPosition(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long leadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int followerMemberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        short flags = (short)(buffer.getByte(absoluteOffset += 4) & 0xFF);
        builder.append(": memberId=").append(memberId);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" followerMemberId=").append(followerMemberId);
        builder.append(" flags=0b");
        HeaderFlyweight.appendFlagsAsChars(flags, builder);
    }

    public static void dissectCommitPosition(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long leadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int leaderId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        builder.append(": memberId=").append(memberId);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" leaderId=").append(leaderId);
    }

    public static void dissectAddPassiveMember(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long correlationId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" correlationId=").append(correlationId);
        builder.append(" memberEndpoints=");
        buffer.getStringAscii(absoluteOffset, builder, ByteOrder.LITTLE_ENDIAN);
    }

    public static void dissectAppendCloseSession(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long sessionId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long leadershipTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long timestamp = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" sessionId=").append(sessionId);
        builder.append(" closeReason=");
        absoluteOffset += 4 + buffer.getStringAscii(absoluteOffset, builder, ByteOrder.LITTLE_ENDIAN);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" timestamp=").append(timestamp);
        builder.append(" timeUnit=");
        buffer.getStringAscii(absoluteOffset, builder, ByteOrder.LITTLE_ENDIAN);
    }

    public static void dissectTerminationPosition(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long logLeadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long position = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" logLeadershipTermId=").append(logLeadershipTermId);
        builder.append(" logPosition=").append(position);
    }

    public static void dissectTerminationAck(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long logLeadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long position = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int senderMemberId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" logLeadershipTermId=").append(logLeadershipTermId);
        builder.append(" logPosition=").append(position);
        builder.append(" senderMemberId=").append(senderMemberId);
    }

    public static void dissectServiceAck(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long logPosition = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long timestamp = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long ackId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long relevantId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long serviceId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" timestamp=").append(timestamp);
        builder.append(" timeUnit=");
        buffer.getStringAscii(absoluteOffset, builder, ByteOrder.LITTLE_ENDIAN);
        builder.append(" ackId=").append(ackId);
        builder.append(" relevantId=").append(relevantId);
        builder.append(" serviceId=").append(serviceId);
    }

    public static void dissectReplicationEnded(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long srcRecordingId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long dstRecordingId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long position = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        boolean hasSynced = 1 == buffer.getByte(absoluteOffset += 4);
        ++absoluteOffset;
        builder.append(": memberId=").append(memberId);
        builder.append(" purpose=");
        absoluteOffset += buffer.getStringAscii(absoluteOffset, builder, ByteOrder.LITTLE_ENDIAN);
        builder.append(" channel=");
        buffer.getStringAscii(absoluteOffset += 4, builder, ByteOrder.LITTLE_ENDIAN);
        builder.append(" srcRecordingId=").append(srcRecordingId);
        builder.append(" dstRecordingId=").append(dstRecordingId);
        builder.append(" position=").append(position);
        builder.append(" hasSynced=").append(hasSynced);
    }

    public static void dissectStandbySnapshotNotification(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long recordingId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long leadershipTermId = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long termBaseLeadershipPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long timestamp = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int serviceId = buffer.getInt(absoluteOffset += 4, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" recordingId=").append(recordingId);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" termBaseLeadershipPosition=").append(termBaseLeadershipPosition);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" timestamp=").append(timestamp);
        builder.append(" timeUnit=");
        absoluteOffset += buffer.getStringAscii(absoluteOffset, builder, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(" serviceId=").append(serviceId);
        builder.append(" archiveEndpoint=");
        absoluteOffset += buffer.getStringAscii(absoluteOffset, builder, ByteOrder.LITTLE_ENDIAN);
    }

    public static void dissectNewElection(ClusterEventCode eventCode, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int absoluteOffset = offset;
        absoluteOffset += CommonEventDissector.dissectLogHeader(CONTEXT, eventCode, buffer, absoluteOffset, builder);
        long leadershipTermId = buffer.getLong(absoluteOffset, ByteOrder.LITTLE_ENDIAN);
        long logPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        long appendPosition = buffer.getLong(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        int memberId = buffer.getInt(absoluteOffset += 8, ByteOrder.LITTLE_ENDIAN);
        absoluteOffset += 4;
        builder.append(": memberId=").append(memberId);
        builder.append(" leadershipTermId=").append(leadershipTermId);
        builder.append(" logPosition=").append(logPosition);
        builder.append(" appendPosition=").append(appendPosition);
        builder.append(" reason=");
        buffer.getStringAscii(absoluteOffset, builder, ByteOrder.LITTLE_ENDIAN);
    }
}

