/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.CommonEventEncoder;
import io.aeron.cluster.codecs.CloseReason;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.UnsafeBuffer;

final class ClusterEventEncoder {
    static final int MAX_REASON_LENGTH = 300;

    private ClusterEventEncoder() {
    }

    static int encodeOnNewLeadershipTerm(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long logLeadershipTermId, long nextLeadershipTermId, long nextTermBaseLogPosition, long nextLogPosition, long leadershipTermId, long termBaseLogPosition, long logPosition, long leaderRecordingId, long timestamp, int leaderId, int logSessionId, int appVersion, boolean isStartup) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, logLeadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), nextLeadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), nextTermBaseLogPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), nextLogPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), termBaseLogPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), leaderRecordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), timestamp, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), leaderId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), logSessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), appVersion, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putByte(offset + (encodedLength += 4), (byte)(isStartup ? 1 : 0));
        return ++encodedLength;
    }

    static int newLeaderShipTermLength() {
        return 89;
    }

    static <E extends Enum<E>> int encodeStateChange(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, E from, E to) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putInt(offset + encodedLength, memberId, ByteOrder.LITTLE_ENDIAN);
        return CommonEventEncoder.encodeTrailingStateChange(encodingBuffer, offset, encodedLength += 4, captureLength, from, to);
    }

    static <E extends Enum<E>> int stateChangeLength(E from, E to) {
        return CommonEventEncoder.stateTransitionStringLength(from, to) + 4;
    }

    static <E extends Enum<E>> int encodeElectionStateChange(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, E from, E to, int leaderId, long candidateTermId, long leadershipTermId, long logPosition, long logLeadershipTermId, long appendPosition, long catchupPosition, String reason) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, candidateTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), logLeadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), appendPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), catchupPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), leaderId, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 4;
        encodedLength += CommonEventEncoder.encodeStateChange(encodingBuffer, offset + encodedLength, from, to);
        encodedLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, offset + encodedLength, captureLength + 16 - encodedLength, reason);
        return encodedLength;
    }

    static <E extends Enum<E>> int electionStateChangeLength(E from, E to, String reason) {
        return 56 + CommonEventEncoder.stateTransitionStringLength(from, to) + CommonEventEncoder.trailingStringLength(reason, 300);
    }

    static int encodeOnCanvassPosition(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long logLeadershipTermId, long logPosition, long leadershipTermId, int followerMemberId, int protocolVersion) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, logLeadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 8), followerMemberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), protocolVersion, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), memberId, ByteOrder.LITTLE_ENDIAN);
        return encodedLength += 4;
    }

    static int canvassPositionLength() {
        return 36;
    }

    static int encodeOnRequestVote(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long logLeadershipTermId, long logPosition, long candidateTermId, int candidateId, int protocolVersion) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, logLeadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), candidateTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 8), candidateId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), protocolVersion, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), memberId, ByteOrder.LITTLE_ENDIAN);
        return encodedLength += 4;
    }

    static int requestVoteLength() {
        return 36;
    }

    static int encodeOnCatchupPosition(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long leadershipTermId, long logPosition, int followerMemberId, String catchupEndpoint) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), followerMemberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), memberId, ByteOrder.LITTLE_ENDIAN);
        bodyLength += 4;
        bodyLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, bodyOffset + bodyLength, captureLength - bodyLength, catchupEndpoint);
        return logHeaderLength + bodyLength;
    }

    static int catchupPositionLength(String endpoint) {
        return 28 + endpoint.length();
    }

    static int encodeOnStopCatchup(UnsafeBuffer encodingBuffer, int offset, int length, int captureLength, int memberId, long leadershipTermId, int followerMemberId) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), followerMemberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), memberId, ByteOrder.LITTLE_ENDIAN);
        return logHeaderLength + (bodyLength += 4);
    }

    static <E extends Enum<E>> int encodeTruncateLogEntry(UnsafeBuffer encodingBuffer, int offset, int length, int captureLength, int memberId, E state, long logLeadershipTermId, long leadershipTermId, long candidateTermId, long commitPosition, long logPosition, long appendPosition, long oldPosition, long newPosition) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putLong(offset + encodedLength, logLeadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), candidateTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), commitPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), appendPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), oldPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 8), newPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 4;
        encodedLength += encodingBuffer.putStringAscii(offset + encodedLength, CommonEventEncoder.enumName(state), ByteOrder.LITTLE_ENDIAN);
        return encodedLength;
    }

    static int encodeOnReplayNewLeadershipTermEvent(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, boolean isInElection, long leadershipTermId, long logPosition, long timestamp, long termBaseLogPosition, TimeUnit timeUnit, int appVersion) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), timestamp, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), termBaseLogPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), appVersion, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putByte(bodyOffset + (bodyLength += 4), (byte)(isInElection ? 1 : 0));
        String unit = CommonEventEncoder.enumName(timeUnit);
        encodingBuffer.putStringAscii(bodyOffset + ++bodyLength, unit, ByteOrder.LITTLE_ENDIAN);
        return logHeaderLength + (bodyLength += 4 + unit.length());
    }

    static int replayNewLeadershipTermEventLength(TimeUnit timeUnit) {
        return 45 + timeUnit.name().length();
    }

    static int encodeOnAppendPosition(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long leadershipTermId, long logPosition, int followerMemberId, short flags) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), followerMemberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), memberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putByte(bodyOffset + (bodyLength += 4), (byte)flags);
        return logHeaderLength + ++bodyLength;
    }

    static int encodeOnCommitPosition(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long leadershipTermId, long logPosition, int leaderId) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), leaderId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), memberId, ByteOrder.LITTLE_ENDIAN);
        return logHeaderLength + (bodyLength += 4);
    }

    static int addPassiveMemberLength(String endpoints) {
        return 16 + endpoints.length();
    }

    static int encodeOnAddPassiveMember(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long correlationId, String memberEndpoints) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, correlationId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        bodyLength += 4;
        bodyLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, bodyOffset + bodyLength, captureLength - bodyLength, memberEndpoints);
        return logHeaderLength + bodyLength;
    }

    static int appendSessionCloseLength(CloseReason closeReason, TimeUnit timeUnit) {
        return 28 + (4 + CommonEventEncoder.enumName(closeReason).length()) + (4 + CommonEventEncoder.enumName(timeUnit).length());
    }

    static int encodeAppendSessionClose(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long sessionId, CloseReason closeReason, long leadershipTermId, long timestamp, TimeUnit timeUnit) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, sessionId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), timestamp, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        bodyLength += 4;
        bodyLength += encodingBuffer.putStringAscii(bodyOffset + bodyLength, CommonEventEncoder.enumName(closeReason), ByteOrder.LITTLE_ENDIAN);
        bodyLength += encodingBuffer.putStringAscii(bodyOffset + bodyLength, CommonEventEncoder.enumName(timeUnit), ByteOrder.LITTLE_ENDIAN);
        return logHeaderLength + bodyLength;
    }

    static int terminationPositionLength() {
        return 20;
    }

    static int encodeTerminationPosition(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long logLeadershipTermId, long logPosition) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, logLeadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        return logHeaderLength + (bodyLength += 4);
    }

    static int terminationAckLength() {
        return 24;
    }

    static int encodeTerminationAck(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long logLeadershipTermId, long logPosition, int senderMemberId) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, logLeadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), senderMemberId, ByteOrder.LITTLE_ENDIAN);
        return logHeaderLength + (bodyLength += 4);
    }

    static int serviceAckLength(TimeUnit timeUnit) {
        return 40 + (4 + CommonEventEncoder.enumName(timeUnit).length());
    }

    public static int encodeServiceAck(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long logPosition, long timestamp, TimeUnit timeUnit, long ackId, long relevantId, int serviceId) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), timestamp, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), ackId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), relevantId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), serviceId, ByteOrder.LITTLE_ENDIAN);
        bodyLength += 4;
        bodyLength += encodingBuffer.putStringAscii(bodyOffset + bodyLength, CommonEventEncoder.enumName(timeUnit), ByteOrder.LITTLE_ENDIAN);
        return logHeaderLength + bodyLength;
    }

    static int replicationEndedLength(String purpose, String controlUri) {
        return 29 + (4 + purpose.length()) + (4 + controlUri.length());
    }

    static int encodeReplicationEnded(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, String purpose, String channel, long srcRecordingId, long dstRecordingId, long position, boolean hasSynced) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, srcRecordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), dstRecordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), position, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putByte(bodyOffset + (bodyLength += 4), (byte)(hasSynced ? 1 : 0));
        ++bodyLength;
        bodyLength += encodingBuffer.putStringAscii(bodyOffset + bodyLength, purpose, ByteOrder.LITTLE_ENDIAN);
        bodyLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, bodyOffset + bodyLength, captureLength - bodyLength, channel);
        return logHeaderLength + bodyLength;
    }

    static int standbySnapshotNotificationLength(TimeUnit timeUnit, String archiveEndpoint) {
        return 64 + timeUnit.name().length() + archiveEndpoint.length();
    }

    static int encodeStandbySnapshotNotification(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long recordingId, long leadershipTermId, long termBaseLogPosition, long logPosition, long timestamp, TimeUnit timeUnit, int serviceId, String archiveEndpoint) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, recordingId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), termBaseLogPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), timestamp, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 4), serviceId, ByteOrder.LITTLE_ENDIAN);
        bodyLength += 4;
        bodyLength += encodingBuffer.putStringAscii(bodyOffset + bodyLength, timeUnit.name(), ByteOrder.LITTLE_ENDIAN);
        bodyLength += CommonEventEncoder.encodeTrailingString(encodingBuffer, bodyOffset + bodyLength, captureLength - bodyLength, archiveEndpoint);
        return logHeaderLength + bodyLength;
    }

    static int newElectionLength(String reason) {
        return 28 + CommonEventEncoder.trailingStringLength(reason, 300);
    }

    static int encodeNewElection(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, int memberId, long leadershipTermId, long logPosition, long appendPosition, String reason) {
        int logHeaderLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        int bodyOffset = offset + logHeaderLength;
        int bodyLength = 0;
        encodingBuffer.putLong(bodyOffset + bodyLength, leadershipTermId, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), logPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(bodyOffset + (bodyLength += 8), appendPosition, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(bodyOffset + (bodyLength += 8), memberId, ByteOrder.LITTLE_ENDIAN);
        CommonEventEncoder.encodeTrailingString(encodingBuffer, bodyOffset + (bodyLength += 4), captureLength - bodyLength, reason);
        return logHeaderLength + bodyLength;
    }
}

