/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ClusterEventCode;
import io.aeron.agent.ClusterEventEncoder;
import io.aeron.agent.CommonEventEncoder;
import io.aeron.agent.EventConfiguration;
import io.aeron.cluster.codecs.CloseReason;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public final class ClusterEventLogger {
    public static final ClusterEventLogger LOGGER = new ClusterEventLogger(EventConfiguration.EVENT_RING_BUFFER);
    private final ManyToOneRingBuffer ringBuffer;

    ClusterEventLogger(ManyToOneRingBuffer eventRingBuffer) {
        this.ringBuffer = eventRingBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnNewLeadershipTerm(int memberId, long logLeadershipTermId, long nextLeadershipTermId, long nextTermBaseLogPosition, long nextLogPosition, long leadershipTermId, long termBaseLogPosition, long logPosition, long leaderRecordingId, long timestamp, int leaderId, int logSessionId, int appVersion, boolean isStartup) {
        int length = ClusterEventEncoder.newLeaderShipTermLength();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.NEW_LEADERSHIP_TERM.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnNewLeadershipTerm((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, logLeadershipTermId, nextLeadershipTermId, nextTermBaseLogPosition, nextLogPosition, leadershipTermId, termBaseLogPosition, logPosition, leaderRecordingId, timestamp, leaderId, logSessionId, appVersion, isStartup);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Enum<E>> void logStateChange(ClusterEventCode eventCode, int memberId, E oldState, E newState) {
        int length = ClusterEventEncoder.stateChangeLength(oldState, newState);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(eventCode.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeStateChange((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, oldState, newState);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Enum<E>> void logElectionStateChange(int memberId, E oldState, E newState, int leaderId, long candidateTermId, long leadershipTermId, long logPosition, long logLeadershipTermId, long appendPosition, long catchupPosition, String reason) {
        int length = ClusterEventEncoder.electionStateChangeLength(oldState, newState, reason);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.ELECTION_STATE_CHANGE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeElectionStateChange((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, oldState, newState, leaderId, candidateTermId, leadershipTermId, logPosition, logLeadershipTermId, appendPosition, catchupPosition, reason);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnCanvassPosition(int memberId, long logLeadershipTermId, long logPosition, long leadershipTermId, int followerMemberId, int protocolVersion) {
        int length = ClusterEventEncoder.canvassPositionLength();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.CANVASS_POSITION.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnCanvassPosition((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, logLeadershipTermId, logPosition, leadershipTermId, followerMemberId, protocolVersion);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnRequestVote(int memberId, long logLeadershipTermId, long logPosition, long candidateTermId, int candidateId, int protocolVersion) {
        int length = ClusterEventEncoder.requestVoteLength();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.REQUEST_VOTE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnRequestVote((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, logLeadershipTermId, logPosition, candidateTermId, candidateId, protocolVersion);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnCatchupPosition(int memberId, long leadershipTermId, long logPosition, int followerMemberId, String catchupEndpoint) {
        int length = ClusterEventEncoder.catchupPositionLength(catchupEndpoint);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.CATCHUP_POSITION.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnCatchupPosition((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, leadershipTermId, logPosition, followerMemberId, catchupEndpoint);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnStopCatchup(int memberId, long leadershipTermId, int followerMemberId) {
        int length = 16;
        int encodedLength = CommonEventEncoder.encodedLength(16);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.STOP_CATCHUP.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnStopCatchup((UnsafeBuffer)ringBuffer.buffer(), index, 16, 16, memberId, leadershipTermId, followerMemberId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Enum<E>> void logOnTruncateLogEntry(int memberId, E state, long logLeadershipTermId, long leadershipTermId, long candidateTermId, long commitPosition, long logPosition, long appendPosition, long oldPosition, long newPosition) {
        int length = 4 + CommonEventEncoder.enumName(state).length() + 4 + 64;
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.TRUNCATE_LOG_ENTRY.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeTruncateLogEntry((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, state, logLeadershipTermId, leadershipTermId, candidateTermId, commitPosition, logPosition, appendPosition, oldPosition, newPosition);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnReplayNewLeadershipTermEvent(int memberId, boolean isInElection, long leadershipTermId, long logPosition, long timestamp, long termBaseLogPosition, TimeUnit timeUnit, int appVersion) {
        int length = ClusterEventEncoder.replayNewLeadershipTermEventLength(timeUnit);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.REPLAY_NEW_LEADERSHIP_TERM.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnReplayNewLeadershipTermEvent((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, isInElection, leadershipTermId, logPosition, timestamp, termBaseLogPosition, timeUnit, appVersion);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnAppendPosition(int memberId, long leadershipTermId, long logPosition, int followerMemberId, short flags) {
        int length = 25;
        int encodedLength = CommonEventEncoder.encodedLength(25);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.APPEND_POSITION.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnAppendPosition((UnsafeBuffer)ringBuffer.buffer(), index, 25, 25, memberId, leadershipTermId, logPosition, followerMemberId, flags);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnCommitPosition(int memberId, long leadershipTermId, long logPosition, int leaderId) {
        int length = 24;
        int encodedLength = CommonEventEncoder.encodedLength(24);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.COMMIT_POSITION.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnCommitPosition((UnsafeBuffer)ringBuffer.buffer(), index, 24, 24, memberId, leadershipTermId, logPosition, leaderId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnAddPassiveMember(int memberId, long correlationId, String memberEndpoints) {
        int length = ClusterEventEncoder.addPassiveMemberLength(memberEndpoints);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.ADD_PASSIVE_MEMBER.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeOnAddPassiveMember((UnsafeBuffer)ringBuffer.buffer(), index, length, length, memberId, correlationId, memberEndpoints);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAppendSessionClose(int memberId, long sessionId, CloseReason closeReason, long leadershipTermId, long timestamp, TimeUnit timeUnit) {
        int length = ClusterEventEncoder.appendSessionCloseLength(closeReason, timeUnit);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.APPEND_SESSION_CLOSE.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeAppendSessionClose((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, sessionId, closeReason, leadershipTermId, timestamp, timeUnit);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTerminationPosition(int memberId, long logLeadershipTermId, long logPosition) {
        int length = ClusterEventEncoder.terminationPositionLength();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.TERMINATION_POSITION.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeTerminationPosition((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, logLeadershipTermId, logPosition);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTerminationAck(int memberId, long logLeadershipTermId, long logPosition, int senderMemberId) {
        int length = ClusterEventEncoder.terminationAckLength();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.TERMINATION_ACK.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeTerminationAck((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, logLeadershipTermId, logPosition, senderMemberId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logServiceAck(int memberId, long logPosition, long timestamp, TimeUnit timeUnit, long ackId, long relevantId, int serviceId) {
        int length = ClusterEventEncoder.serviceAckLength(timeUnit);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.SERVICE_ACK.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeServiceAck((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, logPosition, timestamp, timeUnit, ackId, relevantId, serviceId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logReplicationEnded(int memberId, String purpose, String channel, long srcRecordingId, long dstRecordingId, long position, boolean hasSynced) {
        int length = ClusterEventEncoder.replicationEndedLength(purpose, channel);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.REPLICATION_ENDED.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeReplicationEnded((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, purpose, channel, srcRecordingId, dstRecordingId, position, hasSynced);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logStandbySnapshotNotification(int memberId, long recordingId, long leadershipTermId, long termBaseLogPosition, long logPosition, long timestamp, TimeUnit timeUnit, int serviceId, String archiveEndpoint) {
        int length = ClusterEventEncoder.standbySnapshotNotificationLength(timeUnit, archiveEndpoint);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.STANDBY_SNAPSHOT_NOTIFICATION.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeStandbySnapshotNotification((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, recordingId, leadershipTermId, termBaseLogPosition, logPosition, timestamp, timeUnit, serviceId, archiveEndpoint);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logNewElection(int memberId, long leadershipTermId, long logPosition, long appendPosition, String reason) {
        int length = ClusterEventEncoder.newElectionLength(reason);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(ClusterEventCode.NEW_ELECTION.toEventCodeId(), encodedLength);
        if (index > 0) {
            try {
                ClusterEventEncoder.encodeNewElection((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, memberId, leadershipTermId, logPosition, appendPosition, reason);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }
}

