/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.ClusterEventCode;
import io.aeron.agent.ClusterEventLogger;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.shadow.net.bytebuddy.asm.Advice;
import java.util.concurrent.TimeUnit;

class ClusterInterceptor {
    ClusterInterceptor() {
    }

    static class NewElection {
        NewElection() {
        }

        @Advice.OnMethodEnter
        static void logNewElection(int memberId, long leadershipTermId, long logPosition, long appendPosition, String reason) {
            ClusterEventLogger.LOGGER.logNewElection(memberId, leadershipTermId, logPosition, appendPosition, reason);
        }
    }

    static class StandbySnapshotNotification {
        StandbySnapshotNotification() {
        }

        @Advice.OnMethodEnter
        static void logStandbySnapshotNotification(int memberId, long recordingId, long leadershipTermId, long termBaseLogPosition, long logPosition, long timestamp, TimeUnit timeUnit, int serviceId, String archiveEndpoint) {
            ClusterEventLogger.LOGGER.logStandbySnapshotNotification(memberId, recordingId, leadershipTermId, termBaseLogPosition, logPosition, timestamp, timeUnit, serviceId, archiveEndpoint);
        }
    }

    static class ReplicationEnded {
        ReplicationEnded() {
        }

        @Advice.OnMethodEnter
        static void logReplicationEnded(int memberId, String purpose, String channel, long srcRecordingId, long dstRecordingId, long position, boolean hasSynced) {
            ClusterEventLogger.LOGGER.logReplicationEnded(memberId, purpose, channel, srcRecordingId, dstRecordingId, position, hasSynced);
        }
    }

    static class ServiceAck {
        ServiceAck() {
        }

        @Advice.OnMethodEnter
        static void logOnServiceAck(int memberId, long logPosition, long timestamp, TimeUnit timeUnit, long ackId, long relevantId, int serviceId) {
            ClusterEventLogger.LOGGER.logServiceAck(memberId, logPosition, timestamp, timeUnit, ackId, relevantId, serviceId);
        }
    }

    static class TerminationAck {
        TerminationAck() {
        }

        @Advice.OnMethodEnter
        static void logOnTerminationAck(int memberId, long leadershipTermId, long position, int senderMemberId) {
            ClusterEventLogger.LOGGER.logTerminationAck(memberId, leadershipTermId, position, senderMemberId);
        }
    }

    static class TerminationPosition {
        TerminationPosition() {
        }

        @Advice.OnMethodEnter
        static void logOnTerminationPosition(int memberId, long leadershipTermId, long position) {
            ClusterEventLogger.LOGGER.logTerminationPosition(memberId, leadershipTermId, position);
        }
    }

    static class ClusterBackupStateChange {
        ClusterBackupStateChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logStateChange(E oldState, E newState, long nowMs) {
            ClusterEventLogger.LOGGER.logStateChange(ClusterEventCode.CLUSTER_BACKUP_STATE_CHANGE, -1, oldState, newState);
        }
    }

    static class AppendSessionClose {
        AppendSessionClose() {
        }

        @Advice.OnMethodEnter
        static void logAppendSessionClose(int memberId, long sessionId, CloseReason closeReason, long leadershipTermId, long timestamp, TimeUnit timeUnit) {
            ClusterEventLogger.LOGGER.logAppendSessionClose(memberId, sessionId, closeReason, leadershipTermId, timestamp, timeUnit);
        }
    }

    static class AddPassiveMember {
        AddPassiveMember() {
        }

        @Advice.OnMethodEnter
        static void logOnAddPassiveMember(int memberId, long correlationId, String passiveMember) {
            ClusterEventLogger.LOGGER.logOnAddPassiveMember(memberId, correlationId, passiveMember);
        }
    }

    static class CommitPosition {
        CommitPosition() {
        }

        @Advice.OnMethodEnter
        static void logOnCommitPosition(int memberId, long leadershipTermId, long logPosition, int leaderMemberId) {
            ClusterEventLogger.LOGGER.logOnCommitPosition(memberId, leadershipTermId, logPosition, leaderMemberId);
        }
    }

    static class AppendPosition {
        AppendPosition() {
        }

        @Advice.OnMethodEnter
        static void logOnAppendPosition(int memberId, long leadershipTermId, long logPosition, int followerMemberId, short flags) {
            ClusterEventLogger.LOGGER.logOnAppendPosition(memberId, leadershipTermId, logPosition, followerMemberId, flags);
        }
    }

    static class ReplayNewLeadershipTerm {
        ReplayNewLeadershipTerm() {
        }

        @Advice.OnMethodEnter
        static void logOnReplayNewLeadershipTermEvent(int memberId, boolean isInElection, long leadershipTermId, long logPosition, long timestamp, long termBaseLogPosition, TimeUnit timeUnit, int appVersion) {
            ClusterEventLogger.LOGGER.logOnReplayNewLeadershipTermEvent(memberId, isInElection, leadershipTermId, logPosition, timestamp, termBaseLogPosition, timeUnit, appVersion);
        }
    }

    static class TruncateLogEntry {
        TruncateLogEntry() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void onTruncateLogEntry(int memberId, E state, long logLeadershipTermId, long leadershipTermId, long candidateTermId, long commitPosition, long logPosition, long appendPosition, long oldPosition, long newPosition) {
            ClusterEventLogger.LOGGER.logOnTruncateLogEntry(memberId, state, logLeadershipTermId, leadershipTermId, candidateTermId, commitPosition, logPosition, appendPosition, oldPosition, newPosition);
        }
    }

    static class StopCatchup {
        StopCatchup() {
        }

        @Advice.OnMethodEnter
        static void logOnStopCatchup(int memberId, long leadershipTermId, int followerMemberId) {
            ClusterEventLogger.LOGGER.logOnStopCatchup(memberId, leadershipTermId, followerMemberId);
        }
    }

    static class CatchupPosition {
        CatchupPosition() {
        }

        @Advice.OnMethodEnter
        static void logOnCatchupPosition(int memberId, long leadershipTermId, long logPosition, int followerMemberId, String catchupEndpoint) {
            ClusterEventLogger.LOGGER.logOnCatchupPosition(memberId, leadershipTermId, logPosition, followerMemberId, catchupEndpoint);
        }
    }

    static class RequestVote {
        RequestVote() {
        }

        @Advice.OnMethodEnter
        static void logOnRequestVote(int memberId, long logLeadershipTermId, long logPosition, long candidateTermId, int candidateId, int protocolVersion) {
            ClusterEventLogger.LOGGER.logOnRequestVote(memberId, logLeadershipTermId, logPosition, candidateTermId, candidateId, protocolVersion);
        }
    }

    static class CanvassPosition {
        CanvassPosition() {
        }

        @Advice.OnMethodEnter
        static void logOnCanvassPosition(int memberId, long logLeadershipTermId, long logPosition, long leadershipTermId, int followerMemberId, int protocolVersion) {
            ClusterEventLogger.LOGGER.logOnCanvassPosition(memberId, logLeadershipTermId, logPosition, leadershipTermId, followerMemberId, protocolVersion);
        }
    }

    static class ConsensusModuleRoleChange {
        ConsensusModuleRoleChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logRoleChange(int memberId, E oldRole, E newRole) {
            ClusterEventLogger.LOGGER.logStateChange(ClusterEventCode.ROLE_CHANGE, memberId, oldRole, newRole);
        }
    }

    static class ConsensusModuleStateChange {
        ConsensusModuleStateChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logStateChange(int memberId, E oldState, E newState) {
            ClusterEventLogger.LOGGER.logStateChange(ClusterEventCode.STATE_CHANGE, memberId, oldState, newState);
        }
    }

    static class NewLeadershipTerm {
        NewLeadershipTerm() {
        }

        @Advice.OnMethodEnter
        static void logOnNewLeadershipTerm(int memberId, long logLeadershipTermId, long nextLeadershipTermId, long nextTermBaseLogPosition, long nextLogPosition, long leadershipTermId, long termBaseLogPosition, long logPosition, long leaderRecordingId, long timestamp, int leaderId, int logSessionId, int appVersion, boolean isStartup) {
            ClusterEventLogger.LOGGER.logOnNewLeadershipTerm(memberId, logLeadershipTermId, nextLeadershipTermId, nextTermBaseLogPosition, nextLogPosition, leadershipTermId, termBaseLogPosition, logPosition, leaderRecordingId, timestamp, leaderId, logSessionId, appVersion, isStartup);
        }
    }

    static class ElectionStateChange {
        ElectionStateChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logStateChange(int memberId, E oldState, E newState, int leaderId, long candidateTermId, long leadershipTermId, long logPosition, long logLeadershipTermId, long appendPosition, long catchupPosition, String reason) {
            ClusterEventLogger.LOGGER.logElectionStateChange(memberId, oldState, newState, leaderId, candidateTermId, leadershipTermId, logPosition, logLeadershipTermId, appendPosition, catchupPosition, reason);
        }
    }
}

