/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.CollectingEventLogReaderAgentMBean;
import io.aeron.agent.ComponentLogger;
import io.aeron.agent.EventConfiguration;
import io.aeron.agent.EventLogReaderAgent;
import io.aeron.agent.LogUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public final class CollectingEventLogReaderAgent
implements Agent,
CollectingEventLogReaderAgentMBean {
    public static final String LOGGING_MBEAN_NAME = "io.aeron:type=logging";
    private final Int2ObjectHashMap<ComponentLogger> loggers = new Int2ObjectHashMap();
    private String startMessage;
    private final ManyToOneRingBuffer ringBuffer = EventConfiguration.EVENT_RING_BUFFER;
    private final ExpandableArrayBuffer collectingBuffer = new ExpandableArrayBuffer();
    private final MessageHandler messageHandler = this::onMessage;
    private final Object mutex = new Object();
    private final StringBuilder decodeBuffer = new StringBuilder(EventConfiguration.MAX_EVENT_LENGTH);
    private volatile State state = State.IGNORING;
    private int bufferPosition = 0;

    CollectingEventLogReaderAgent(String fileName, List<ComponentLogger> loggers) {
        for (ComponentLogger componentLogger : loggers) {
            this.loggers.put(componentLogger.typeCode(), componentLogger);
        }
    }

    @Override
    public void onStart() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName oName = new ObjectName(LOGGING_MBEAN_NAME);
            mBeanServer.registerMBean(this, oName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    @Override
    public String roleName() {
        return "inmemory-event-log-reader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doWork() {
        Object object = this.mutex;
        synchronized (object) {
            return this.ringBuffer.read(this.messageHandler, 20);
        }
    }

    private void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        if (this.state == State.IGNORING) {
            return;
        }
        int position = this.bufferPosition;
        this.collectingBuffer.putInt(position, msgTypeId);
        this.collectingBuffer.putInt(position += 4, length);
        this.collectingBuffer.putBytes(position += 4, buffer, index, length);
        this.bufferPosition = position += length;
    }

    @Override
    public void setCollecting(boolean isCollecting) {
        this.state = isCollecting ? State.COLLECTING : State.IGNORING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCollecting(String name) {
        Object object = this.mutex;
        synchronized (object) {
            this.resetWritePosition();
            this.writeLogStartMessage(name);
            this.state = State.COLLECTING;
        }
    }

    @Override
    public boolean isCollecting() {
        return this.state == State.COLLECTING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.state = State.IGNORING;
            this.resetWritePosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(String filename) {
        Object object = this.mutex;
        synchronized (object) {
            this.doOutputToFile(filename);
        }
    }

    private void resetWritePosition() {
        this.bufferPosition = 0;
    }

    private void writeLogStartMessage(String name) {
        long timestampNs = System.nanoTime();
        this.decodeBuffer.setLength(0);
        LogUtil.appendTimestamp(this.decodeBuffer, timestampNs);
        this.startMessage = this.decodeBuffer.append(" [").append(LocalDateTime.now()).append("] ").append(name).toString();
    }

    private void doOutputToFile(String filename) {
        System.out.println("Dumping to file: " + filename);
        try (PrintStream out = new PrintStream(filename);){
            int length;
            int terminalPosition = this.bufferPosition;
            out.println(this.startMessage);
            for (int readingPosition = 0; readingPosition < terminalPosition; readingPosition += length) {
                int msgTypeId = this.collectingBuffer.getInt(readingPosition);
                length = this.collectingBuffer.getInt(readingPosition += 4);
                int eventCodeTypeId = msgTypeId >> 16;
                int eventCodeId = msgTypeId & 0xFFFF;
                this.decodeBuffer.setLength(0);
                EventLogReaderAgent.decodeLogEvent(this.collectingBuffer, readingPosition += 4, eventCodeTypeId, eventCodeId, this.loggers, this.decodeBuffer);
                out.print(this.decodeBuffer);
            }
            this.bufferPosition = 0;
        }
        catch (IOException ex) {
            System.err.println("Failed to write to output log: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    static enum State {
        COLLECTING,
        IGNORING;

    }
}

