/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.LogUtil;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.agrona.MutableDirectBuffer;

final class CommonEventDissector {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSSZ");

    private CommonEventDissector() {
    }

    static void dissectLogStartMessage(long timestampNs, long timestampMs, ZoneId zone, StringBuilder builder) {
        LogUtil.appendTimestamp(builder, timestampNs);
        builder.append("log started ").append(DATE_TIME_FORMATTER.format(OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestampMs), zone)));
    }

    static int dissectLogHeader(String context, Enum<?> code, MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int encodedLength = 0;
        int captureLength = buffer.getInt(offset + encodedLength, ByteOrder.LITTLE_ENDIAN);
        int bufferLength = buffer.getInt(offset + (encodedLength += 4), ByteOrder.LITTLE_ENDIAN);
        long timestampNs = buffer.getLong(offset + (encodedLength += 4), ByteOrder.LITTLE_ENDIAN);
        LogUtil.appendTimestamp(builder, timestampNs);
        builder.append(context).append(": ").append(code.name()).append(" [").append(captureLength).append('/').append(bufferLength).append(']');
        return encodedLength += 8;
    }

    static int dissectSocketAddress(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int encodedLength = 0;
        int port = buffer.getInt(offset + encodedLength, ByteOrder.LITTLE_ENDIAN);
        encodedLength += 4;
        encodedLength += CommonEventDissector.dissectInetAddress(buffer, offset + encodedLength, builder);
        builder.append(':').append(port);
        return encodedLength;
    }

    static int dissectInetAddress(MutableDirectBuffer buffer, int offset, StringBuilder builder) {
        int encodedLength = 0;
        int addressLength = buffer.getInt(offset + encodedLength);
        encodedLength += 4;
        if (4 == addressLength) {
            int i = offset + encodedLength;
            builder.append(buffer.getByte(i) & 0xFF).append('.').append(buffer.getByte(i + 1) & 0xFF).append('.').append(buffer.getByte(i + 2) & 0xFF).append('.').append(buffer.getByte(i + 3) & 0xFF);
        } else if (16 == addressLength) {
            int i = offset + encodedLength;
            builder.append('[').append(Integer.toHexString(buffer.getByte(i) << 8 & 0xFF00 | buffer.getByte(i + 1) & 0xFF)).append(':').append(Integer.toHexString(buffer.getByte(i + 2) << 8 & 0xFF00 | buffer.getByte(i + 3) & 0xFF)).append(':').append(Integer.toHexString(buffer.getByte(i + 4) << 8 & 0xFF00 | buffer.getByte(i + 5) & 0xFF)).append(':').append(Integer.toHexString(buffer.getByte(i + 6) << 8 & 0xFF00 | buffer.getByte(i + 7) & 0xFF)).append(':').append(Integer.toHexString(buffer.getByte(i + 8) << 8 & 0xFF00 | buffer.getByte(i + 9) & 0xFF)).append(':').append(Integer.toHexString(buffer.getByte(i + 10) << 8 & 0xFF00 | buffer.getByte(i + 11) & 0xFF)).append(':').append(Integer.toHexString(buffer.getByte(i + 12) << 8 & 0xFF00 | buffer.getByte(i + 13) & 0xFF)).append(':').append(Integer.toHexString(buffer.getByte(i + 14) << 8 & 0xFF00 | buffer.getByte(i + 15) & 0xFF)).append(']');
        } else {
            builder.append("unknown-address");
        }
        return encodedLength += addressLength;
    }
}

