/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventConfiguration;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.UnsafeBuffer;

final class CommonEventEncoder {
    static final int LOG_HEADER_LENGTH = 16;
    static final int MAX_CAPTURE_LENGTH = EventConfiguration.MAX_EVENT_LENGTH - 16;
    static final String STATE_SEPARATOR = " -> ";

    private CommonEventEncoder() {
    }

    static int encodeLogHeader(MutableDirectBuffer encodingBuffer, int offset, int captureLength, int length) {
        return CommonEventEncoder.internalEncodeLogHeader(encodingBuffer, offset, captureLength, length, SystemNanoClock.INSTANCE);
    }

    static int internalEncodeLogHeader(MutableDirectBuffer encodingBuffer, int offset, int captureLength, int length, NanoClock nanoClock) {
        if (captureLength < 0 || captureLength > length || captureLength > MAX_CAPTURE_LENGTH) {
            throw new IllegalArgumentException("invalid input: captureLength=" + captureLength + ", length=" + length);
        }
        int encodedLength = 0;
        encodingBuffer.putInt(offset + encodedLength, captureLength, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putInt(offset + (encodedLength += 4), length, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putLong(offset + (encodedLength += 4), nanoClock.nanoTime(), ByteOrder.LITTLE_ENDIAN);
        return encodedLength += 8;
    }

    static int encodeSocketAddress(UnsafeBuffer encodingBuffer, int offset, InetSocketAddress address) {
        int encodedLength = 0;
        encodingBuffer.putInt(offset + encodedLength, address.getPort(), ByteOrder.LITTLE_ENDIAN);
        byte[] addressBytes = address.getAddress().getAddress();
        encodingBuffer.putInt(offset + (encodedLength += 4), addressBytes.length, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putBytes(offset + (encodedLength += 4), addressBytes);
        return encodedLength += addressBytes.length;
    }

    static int encodeInetAddress(UnsafeBuffer encodingBuffer, int offset, InetAddress address) {
        int encodedLength = 0;
        if (null != address) {
            byte[] addressBytes = address.getAddress();
            encodingBuffer.putInt(offset + encodedLength, addressBytes.length, ByteOrder.LITTLE_ENDIAN);
            encodingBuffer.putBytes(offset + (encodedLength += 4), addressBytes);
            encodedLength += addressBytes.length;
        } else {
            encodingBuffer.putInt(offset, 0);
            encodedLength += 4;
        }
        return encodedLength;
    }

    static int encodeTrailingString(UnsafeBuffer encodingBuffer, int offset, int remainingCapacity, String value) {
        int maxLength = remainingCapacity - 4;
        if (value.length() <= maxLength) {
            return encodingBuffer.putStringAscii(offset, value, ByteOrder.LITTLE_ENDIAN);
        }
        encodingBuffer.putInt(offset, maxLength, ByteOrder.LITTLE_ENDIAN);
        encodingBuffer.putStringWithoutLengthAscii(offset + 4, value, 0, maxLength - 3);
        encodingBuffer.putStringWithoutLengthAscii(offset + 4 + maxLength - 3, "...");
        return remainingCapacity;
    }

    static int encode(UnsafeBuffer encodingBuffer, int offset, int captureLength, int length, DirectBuffer srcBuffer, int srcOffset) {
        int encodedLength = CommonEventEncoder.encodeLogHeader(encodingBuffer, offset, captureLength, length);
        encodingBuffer.putBytes(offset + encodedLength, srcBuffer, srcOffset, captureLength);
        return encodedLength + captureLength;
    }

    static <E extends Enum<E>> int encodeStateChange(UnsafeBuffer encodingBuffer, int offset, E from, E to) {
        int encodedLength = 0;
        String fromName = CommonEventEncoder.enumName(from);
        String toName = CommonEventEncoder.enumName(to);
        encodingBuffer.putInt(offset, fromName.length() + STATE_SEPARATOR.length() + toName.length(), ByteOrder.LITTLE_ENDIAN);
        encodedLength += 4;
        encodedLength += encodingBuffer.putStringWithoutLengthAscii(offset + encodedLength, fromName);
        encodedLength += encodingBuffer.putStringWithoutLengthAscii(offset + encodedLength, STATE_SEPARATOR);
        encodedLength += encodingBuffer.putStringWithoutLengthAscii(offset + encodedLength, toName);
        return encodedLength;
    }

    static <E extends Enum<E>> int encodeTrailingStateChange(UnsafeBuffer encodingBuffer, int offset, int runningEncodedLength, int captureLength, E from, E to) {
        int encodedLength = runningEncodedLength;
        encodingBuffer.putInt(offset + encodedLength, captureLength - (runningEncodedLength - 16 + 4), ByteOrder.LITTLE_ENDIAN);
        encodedLength += 4;
        String fromName = CommonEventEncoder.enumName(from);
        String toName = CommonEventEncoder.enumName(to);
        encodedLength += encodingBuffer.putStringWithoutLengthAscii(offset + encodedLength, fromName);
        encodedLength += encodingBuffer.putStringWithoutLengthAscii(offset + encodedLength, STATE_SEPARATOR);
        encodedLength += encodingBuffer.putStringWithoutLengthAscii(offset + encodedLength, toName);
        return encodedLength;
    }

    static int captureLength(int length) {
        return Math.min(length, MAX_CAPTURE_LENGTH);
    }

    static int encodedLength(int captureLength) {
        return 16 + captureLength;
    }

    static int socketAddressLength(InetSocketAddress address) {
        return 4 + CommonEventEncoder.inetAddressLength(address.getAddress());
    }

    static int inetAddressLength(InetAddress address) {
        return 4 + (null != address ? address.getAddress().length : 0);
    }

    static int trailingStringLength(String s, int maxLength) {
        return 4 + Math.min(s.length(), maxLength);
    }

    static <E extends Enum<E>> int stateTransitionStringLength(E from, E to) {
        return 4 + CommonEventEncoder.enumName(from).length() + STATE_SEPARATOR.length() + CommonEventEncoder.enumName(to).length();
    }

    static <E extends Enum<E>> String enumName(E state) {
        return null == state ? "null" : state.name();
    }
}

