/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.CommonEventEncoder;
import io.aeron.agent.DriverComponentLogger;
import io.aeron.agent.DriverEventCode;
import io.aeron.agent.DriverEventEncoder;
import io.aeron.agent.EventConfiguration;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public final class DriverEventLogger {
    public static final DriverEventLogger LOGGER = new DriverEventLogger(EventConfiguration.EVENT_RING_BUFFER);
    public static final int MAX_HOST_NAME_LENGTH = 256;
    public static final int MAX_CHANNEL_URI_LENGTH = 4096;
    private final ManyToOneRingBuffer ringBuffer;

    DriverEventLogger(ManyToOneRingBuffer ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(DriverEventCode code, DirectBuffer buffer, int offset, int length) {
        if (DriverComponentLogger.ENABLED_EVENTS.contains(code)) {
            int captureLength = CommonEventEncoder.captureLength(length);
            int encodedLength = CommonEventEncoder.encodedLength(captureLength);
            ManyToOneRingBuffer ringBuffer = this.ringBuffer;
            int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(code), encodedLength);
            if (index > 0) {
                try {
                    CommonEventEncoder.encode((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, buffer, offset);
                }
                finally {
                    ringBuffer.commit(index);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logFrameIn(DirectBuffer buffer, int offset, int frameLength, InetSocketAddress dstAddress) {
        int length = frameLength + CommonEventEncoder.socketAddressLength(dstAddress);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.FRAME_IN), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encode((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, buffer, offset, dstAddress);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logFrameOut(ByteBuffer buffer, InetSocketAddress dstAddress) {
        int length = buffer.remaining() + CommonEventEncoder.socketAddressLength(dstAddress);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.FRAME_OUT), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encode((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, buffer, buffer.position(), dstAddress);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logPublicationRemoval(String channel, int sessionId, int streamId) {
        int length = 12 + channel.length();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.REMOVE_PUBLICATION_CLEANUP), encodedLength);
        if (index > 0) {
            try {
                UnsafeBuffer buffer = (UnsafeBuffer)ringBuffer.buffer();
                DriverEventEncoder.encodePublicationRemoval(buffer, index, captureLength, length, channel, sessionId, streamId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSubscriptionRemoval(String channel, int streamId, long subscriptionId) {
        int length = 16 + channel.length();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.REMOVE_SUBSCRIPTION_CLEANUP), encodedLength);
        if (index > 0) {
            try {
                UnsafeBuffer buffer = (UnsafeBuffer)ringBuffer.buffer();
                DriverEventEncoder.encodeSubscriptionRemoval(buffer, index, captureLength, length, channel, streamId, subscriptionId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logImageRemoval(String channel, int sessionId, int streamId, long correlationId) {
        int length = 20 + channel.length();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.REMOVE_IMAGE_CLEANUP), encodedLength);
        if (index > 0) {
            try {
                UnsafeBuffer buffer = (UnsafeBuffer)ringBuffer.buffer();
                DriverEventEncoder.encodeImageRemoval(buffer, index, captureLength, length, channel, sessionId, streamId, correlationId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logString(DriverEventCode code, String value) {
        int length = value.length() + 4;
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(code), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encode((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, value);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Enum<E>> void logUntetheredSubscriptionStateChange(E oldState, E newState, long subscriptionId, int streamId, int sessionId) {
        int length = DriverEventEncoder.untetheredSubscriptionStateChangeLength(oldState, newState);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.UNTETHERED_SUBSCRIPTION_STATE_CHANGE), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encodeUntetheredSubscriptionStateChange((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, oldState, newState, subscriptionId, streamId, sessionId);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAddress(DriverEventCode code, InetSocketAddress address) {
        int length = CommonEventEncoder.socketAddressLength(address);
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(code), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encode((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, address);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logResolve(String resolverName, long durationNs, String name, boolean isReResolution, InetAddress address) {
        int length = 9 + CommonEventEncoder.trailingStringLength(resolverName, 256) + CommonEventEncoder.trailingStringLength(name, 256) + CommonEventEncoder.inetAddressLength(address);
        int encodedLength = CommonEventEncoder.encodedLength(length);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.NAME_RESOLUTION_RESOLVE), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encodeResolve((UnsafeBuffer)ringBuffer.buffer(), index, length, length, resolverName, durationNs, name, isReResolution, address);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logLookup(String resolverName, long durationNs, String name, boolean isReLookup, String resolvedName) {
        int length = 8 + CommonEventEncoder.trailingStringLength(resolverName, 256) + CommonEventEncoder.trailingStringLength(name, 256) + 1 + CommonEventEncoder.trailingStringLength(resolvedName, 256);
        int encodedLength = CommonEventEncoder.encodedLength(length);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.NAME_RESOLUTION_LOOKUP), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encodeLookup((UnsafeBuffer)ringBuffer.buffer(), index, length, length, resolverName, durationNs, name, isReLookup, resolvedName);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logHostName(long durationNs, String hostName) {
        int length = 8 + CommonEventEncoder.trailingStringLength(hostName, 256);
        int encodedLength = CommonEventEncoder.encodedLength(length);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.NAME_RESOLUTION_HOST_NAME), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encodeHostName((UnsafeBuffer)ringBuffer.buffer(), index, length, length, durationNs, hostName);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logFlowControlReceiver(DriverEventCode code, long receiverId, int sessionId, int streamId, String channel, int receiverCount) {
        int length = 24 + channel.length();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(code), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encodeFlowControlReceiver((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, receiverId, sessionId, streamId, channel, receiverCount);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSendNakMessage(InetSocketAddress controlAddress, int sessionId, int streamId, int termId, int termOffset, int nakLength, String channel) {
        int length = CommonEventEncoder.socketAddressLength(controlAddress) + 24 + channel.length();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.SEND_NAK_MESSAGE), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encodeSendNakMessage((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, controlAddress, sessionId, streamId, termId, termOffset, nakLength, channel);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logResend(int sessionId, int streamId, int termId, int termOffset, int resendLength, String channel) {
        int length = 24 + channel.length();
        int captureLength = CommonEventEncoder.captureLength(length);
        int encodedLength = CommonEventEncoder.encodedLength(captureLength);
        ManyToOneRingBuffer ringBuffer = this.ringBuffer;
        int index = ringBuffer.tryClaim(DriverEventLogger.toEventCodeId(DriverEventCode.RESEND), encodedLength);
        if (index > 0) {
            try {
                DriverEventEncoder.encodeResend((UnsafeBuffer)ringBuffer.buffer(), index, captureLength, length, sessionId, streamId, termId, termOffset, resendLength, channel);
            }
            finally {
                ringBuffer.commit(index);
            }
        }
    }

    static int toEventCodeId(DriverEventCode code) {
        return DriverEventCode.EVENT_CODE_TYPE << 16 | code.id() & 0xFFFF;
    }
}

