/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.DriverEventCode;
import io.aeron.agent.DriverEventLogger;
import io.aeron.shadow.net.bytebuddy.asm.Advice;
import java.net.InetAddress;
import java.net.InetSocketAddress;

class DriverInterceptor {
    DriverInterceptor() {
    }

    static class FlowControl {
        FlowControl() {
        }

        static class ReceiverRemoved {
            ReceiverRemoved() {
            }

            @Advice.OnMethodEnter
            static void receiverRemoved(long receiverId, int sessionId, int streamId, String channel, int receiverCount) {
                DriverEventLogger.LOGGER.logFlowControlReceiver(DriverEventCode.FLOW_CONTROL_RECEIVER_REMOVED, receiverId, sessionId, streamId, channel, receiverCount);
            }
        }

        static class ReceiverAdded {
            ReceiverAdded() {
            }

            @Advice.OnMethodEnter
            static void receiverAdded(long receiverId, int sessionId, int streamId, String channel, int receiverCount) {
                DriverEventLogger.LOGGER.logFlowControlReceiver(DriverEventCode.FLOW_CONTROL_RECEIVER_ADDED, receiverId, sessionId, streamId, channel, receiverCount);
            }
        }
    }

    static class NameResolution {
        NameResolution() {
        }

        static class HostName {
            HostName() {
            }

            @Advice.OnMethodEnter
            static void logHostName(long durationNs, String hostName) {
                DriverEventLogger.LOGGER.logHostName(durationNs, hostName);
            }
        }

        static class Lookup {
            Lookup() {
            }

            @Advice.OnMethodEnter
            static void logLookup(String resolverName, long durationNs, String name, boolean isReLookup, String resolvedName) {
                DriverEventLogger.LOGGER.logLookup(resolverName, durationNs, name, isReLookup, resolvedName);
            }
        }

        static class Resolve {
            Resolve() {
            }

            @Advice.OnMethodEnter
            static void logResolve(String resolverName, long durationNs, String name, boolean isReResolution, InetAddress address) {
                DriverEventLogger.LOGGER.logResolve(resolverName, durationNs, name, isReResolution, address);
            }
        }

        static class NeighborRemoved {
            NeighborRemoved() {
            }

            @Advice.OnMethodEnter
            static void neighborRemoved(long nowMs, InetSocketAddress address) {
                DriverEventLogger.LOGGER.logAddress(DriverEventCode.NAME_RESOLUTION_NEIGHBOR_REMOVED, address);
            }
        }

        static class NeighborAdded {
            NeighborAdded() {
            }

            @Advice.OnMethodEnter
            static void neighborAdded(long nowMs, InetSocketAddress address) {
                DriverEventLogger.LOGGER.logAddress(DriverEventCode.NAME_RESOLUTION_NEIGHBOR_ADDED, address);
            }
        }
    }

    static class UntetheredSubscriptionStateChange {
        UntetheredSubscriptionStateChange() {
        }

        @Advice.OnMethodEnter
        static <E extends Enum<E>> void logStateChange(E oldState, E newState, long subscriptionId, int streamId, int sessionId) {
            DriverEventLogger.LOGGER.logUntetheredSubscriptionStateChange(oldState, newState, subscriptionId, streamId, sessionId);
        }
    }
}

