/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ClusterBackup;

class LogSourceValidator {
    private final ClusterBackup.SourceType sourceType;

    LogSourceValidator(ClusterBackup.SourceType sourceType) {
        this.sourceType = sourceType;
    }

    boolean isAcceptable(long leaderMemberId, long memberId) {
        switch (this.sourceType) {
            case LEADER: {
                return -1L != leaderMemberId && leaderMemberId == memberId;
            }
            case FOLLOWER: {
                return -1L == leaderMemberId || leaderMemberId != memberId;
            }
            case ANY: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown sourceType=" + (Object)((Object)this.sourceType));
    }
}

