/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.cluster.MultipleRecordingReplication;
import io.aeron.cluster.RecordingLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;

class SnapshotReplication
implements AutoCloseable {
    private final ArrayList<RecordingLog.Snapshot> snapshotsPending = new ArrayList();
    private final MultipleRecordingReplication multipleRecordingReplication;

    SnapshotReplication(AeronArchive archive, int srcControlStreamId, String srcControlChannel, String replicationChannel) {
        this(archive, srcControlStreamId, srcControlChannel, replicationChannel, TimeUnit.SECONDS.toNanos(10L), TimeUnit.SECONDS.toNanos(1L));
    }

    SnapshotReplication(AeronArchive archive, int srcControlStreamId, String srcControlChannel, String replicationChannel, long replicationProgressTimeoutNs, long replicationProgressIntervalNs) {
        this.multipleRecordingReplication = MultipleRecordingReplication.newInstance(archive, srcControlStreamId, srcControlChannel, replicationChannel, replicationProgressTimeoutNs, replicationProgressIntervalNs);
    }

    void addSnapshot(RecordingLog.Snapshot snapshot) {
        this.snapshotsPending.add(snapshot);
        this.multipleRecordingReplication.addRecording(snapshot.recordingId, -1L, -1L);
    }

    int poll(long nowNs) {
        return this.multipleRecordingReplication.poll(nowNs);
    }

    void onSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        this.multipleRecordingReplication.onSignal(correlationId, recordingId, position, signal);
    }

    boolean isComplete() {
        return this.multipleRecordingReplication.isComplete();
    }

    List<RecordingLog.Snapshot> snapshotsRetrieved() {
        ArrayList<RecordingLog.Snapshot> snapshots = new ArrayList<RecordingLog.Snapshot>();
        int n = this.snapshotsPending.size();
        for (int i = 0; i < n; ++i) {
            RecordingLog.Snapshot pendingSnapshot = this.snapshotsPending.get(i);
            long dstRecordingId = this.multipleRecordingReplication.completedDstRecordingId(pendingSnapshot.recordingId);
            snapshots.add(SnapshotReplication.retrievedSnapshot(pendingSnapshot, dstRecordingId));
        }
        return snapshots;
    }

    static RecordingLog.Snapshot retrievedSnapshot(RecordingLog.Snapshot pending, long recordingId) {
        return new RecordingLog.Snapshot(recordingId, pending.leadershipTermId, pending.termBaseLogPosition, pending.logPosition, pending.timestamp, pending.serviceId);
    }

    @Override
    public void close() {
        CloseHelper.close(this.multipleRecordingReplication);
    }
}

