/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.client;

import io.aeron.Publication;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.SessionMessageHeaderEncoder;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class IngressSessionDecorator {
    public static final int HEADER_LENGTH = 32;
    private final SessionMessageHeaderEncoder sessionMessageHeaderEncoder = new SessionMessageHeaderEncoder();
    private final UnsafeBuffer headerBuffer = new UnsafeBuffer(new byte[32]);

    public IngressSessionDecorator() {
        this(-1L, -1L);
    }

    public IngressSessionDecorator(long clusterSessionId, long leadershipTermId) {
        this.sessionMessageHeaderEncoder.wrapAndApplyHeader(this.headerBuffer, 0, new MessageHeaderEncoder()).leadershipTermId(leadershipTermId).clusterSessionId(clusterSessionId).timestamp(-1L);
    }

    public IngressSessionDecorator clusterSessionId(long clusterSessionId) {
        this.sessionMessageHeaderEncoder.clusterSessionId(clusterSessionId);
        return this;
    }

    public IngressSessionDecorator leadershipTermId(long leadershipTermId) {
        this.sessionMessageHeaderEncoder.leadershipTermId(leadershipTermId);
        return this;
    }

    public long offer(Publication publication, DirectBuffer buffer, int offset, int length) {
        return publication.offer(this.headerBuffer, 0, 32, buffer, offset, length, null);
    }
}

