/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.FlowControl;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.MaxMulticastFlowControl;
import io.aeron.driver.MinMulticastFlowControl;
import io.aeron.driver.TaggedMulticastFlowControl;
import io.aeron.driver.media.UdpChannel;
import org.agrona.LangUtil;

public class DefaultMulticastFlowControlSupplier
implements FlowControlSupplier {
    @Override
    public FlowControl newInstance(UdpChannel udpChannel, int streamId, long registrationId) {
        String fcStr = udpChannel.channelUri().get("fc");
        if (null != fcStr) {
            String strategyStr;
            int delimiter = fcStr.indexOf(44);
            switch (strategyStr = -1 == delimiter ? fcStr : fcStr.substring(0, delimiter)) {
                case "max": {
                    return MaxMulticastFlowControl.INSTANCE;
                }
                case "min": {
                    return new MinMulticastFlowControl();
                }
                case "tagged": {
                    return new TaggedMulticastFlowControl();
                }
            }
            throw new IllegalArgumentException("unsupported multicast flow control strategy: fc=" + fcStr);
        }
        if (MaxMulticastFlowControl.class.getName().equals(Configuration.MULTICAST_FLOW_CONTROL_STRATEGY)) {
            return MaxMulticastFlowControl.INSTANCE;
        }
        if (MinMulticastFlowControl.class.getName().equals(Configuration.MULTICAST_FLOW_CONTROL_STRATEGY)) {
            return new MinMulticastFlowControl();
        }
        if (TaggedMulticastFlowControl.class.getName().equals(Configuration.MULTICAST_FLOW_CONTROL_STRATEGY)) {
            return new TaggedMulticastFlowControl();
        }
        FlowControl flowControl = null;
        try {
            flowControl = (FlowControl)Class.forName(Configuration.MULTICAST_FLOW_CONTROL_STRATEGY).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return flowControl;
    }

    public String toString() {
        return "DefaultMulticastFlowControlSupplier{flowControlClass=" + Configuration.MULTICAST_FLOW_CONTROL_STRATEGY + "}";
    }
}

