/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class ResolutionEntryFlyweight
extends HeaderFlyweight {
    public static final byte RES_TYPE_NAME_TO_IP4_MD = 1;
    public static final byte RES_TYPE_NAME_TO_IP6_MD = 2;
    public static final int ADDRESS_LENGTH_IP4 = 4;
    public static final int ADDRESS_LENGTH_IP6 = 16;
    public static final short SELF_FLAG = 128;
    public static final int RES_TYPE_FIELD_OFFSET = 0;
    public static final int RES_FLAGS_FIELD_OFFSET = 1;
    public static final int UDP_PORT_FIELD_OFFSET = 2;
    public static final int AGE_IN_MS_FIELD_OFFSET = 4;
    public static final int ADDRESS_FIELD_OFFSET = 8;
    public static final int MAX_NAME_LENGTH = 512;

    public ResolutionEntryFlyweight() {
    }

    public ResolutionEntryFlyweight(UnsafeBuffer buffer) {
        super(buffer);
    }

    public ResolutionEntryFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public ResolutionEntryFlyweight resType(byte type) {
        this.putByte(0, type);
        return this;
    }

    public byte resType() {
        return this.getByte(0);
    }

    @Override
    public ResolutionEntryFlyweight flags(short flags) {
        this.putByte(1, (byte)flags);
        return this;
    }

    @Override
    public short flags() {
        return (short)(this.getByte(1) & 0xFF);
    }

    public ResolutionEntryFlyweight udpPort(int udpPort) {
        this.putShort(2, (short)udpPort, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int udpPort() {
        return this.getShort(2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public ResolutionEntryFlyweight ageInMs(int ageInMs) {
        this.putInt(4, ageInMs, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int ageInMs() {
        return this.getInt(4, ByteOrder.LITTLE_ENDIAN);
    }

    public ResolutionEntryFlyweight putAddress(byte[] address) {
        switch (this.resType()) {
            case 1: {
                if (4 != address.length) {
                    throw new IllegalArgumentException("Invalid address length: " + address.length);
                }
                this.putBytes(8, address, 0, 4);
                break;
            }
            case 2: {
                if (16 != address.length) {
                    throw new IllegalArgumentException("Invalid address length: " + address.length);
                }
                this.putBytes(8, address, 0, 16);
                break;
            }
            default: {
                throw new IllegalStateException("unknown RES_TYPE=" + this.resType());
            }
        }
        return this;
    }

    public int getAddress(byte[] dstBuffer) {
        switch (this.resType()) {
            case 1: {
                if (4 > dstBuffer.length) {
                    throw new IllegalArgumentException("Insufficient length: " + dstBuffer.length);
                }
                this.getBytes(8, dstBuffer, 0, 4);
                return 4;
            }
            case 2: {
                if (16 > dstBuffer.length) {
                    throw new IllegalArgumentException("Insufficient length: " + dstBuffer.length);
                }
                this.getBytes(8, dstBuffer, 0, 16);
                return 16;
            }
        }
        throw new IllegalStateException("unknown RES_TYPE=" + this.resType());
    }

    public void appendAddress(Appendable appendable) {
        try {
            switch (this.resType()) {
                case 1: {
                    int i = 8;
                    appendable.append(String.valueOf(this.getByte(8) & 0xFF)).append('.').append(String.valueOf(this.getByte(9) & 0xFF)).append('.').append(String.valueOf(this.getByte(10) & 0xFF)).append('.').append(String.valueOf(this.getByte(11) & 0xFF));
                    break;
                }
                case 2: {
                    int i = 8;
                    appendable.append(Integer.toHexString(this.getByte(8) << 8 & 0xFF00 | this.getByte(9) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(10) << 8 & 0xFF00 | this.getByte(11) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(12) << 8 & 0xFF00 | this.getByte(13) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(14) << 8 & 0xFF00 | this.getByte(15) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(16) << 8 & 0xFF00 | this.getByte(17) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(18) << 8 & 0xFF00 | this.getByte(19) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(20) << 8 & 0xFF00 | this.getByte(21) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(22) << 8 & 0xFF00 | this.getByte(23) & 0xFF));
                    break;
                }
                default: {
                    appendable.append("unknown RES_TYPE=").append(String.valueOf(this.resType()));
                    break;
                }
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public ResolutionEntryFlyweight putName(byte[] name) {
        int nameOffset = ResolutionEntryFlyweight.nameOffset(this.resType());
        this.putShort(nameOffset, (short)name.length, ByteOrder.LITTLE_ENDIAN);
        this.putBytes(nameOffset + 2, name);
        return this;
    }

    public int getName(byte[] dstBuffer) {
        int nameOffset = ResolutionEntryFlyweight.nameOffset(this.resType());
        short nameLength = this.getShort(nameOffset, ByteOrder.LITTLE_ENDIAN);
        if (nameLength > dstBuffer.length) {
            throw new IllegalArgumentException("Insufficient length: " + dstBuffer.length);
        }
        this.getBytes(nameOffset + 2, dstBuffer, 0, (int)nameLength);
        return nameLength;
    }

    public void appendName(StringBuilder appendable) {
        int nameOffset = ResolutionEntryFlyweight.nameOffset(this.resType());
        short nameLength = this.getShort(nameOffset, ByteOrder.LITTLE_ENDIAN);
        this.getStringWithoutLengthAscii(nameOffset + 2, nameLength, appendable);
    }

    public int entryLength() {
        int nameOffset = ResolutionEntryFlyweight.nameOffset(this.resType());
        return BitUtil.align(nameOffset + 2 + this.getShort(nameOffset, ByteOrder.LITTLE_ENDIAN), 8);
    }

    public static int nameOffset(byte resType) {
        switch (resType) {
            case 1: {
                return 12;
            }
            case 2: {
                return 24;
            }
        }
        throw new IllegalStateException("unknown RES_TYPE=" + resType);
    }

    public static int entryLengthRequired(byte resType, int nameLength) {
        return BitUtil.align(ResolutionEntryFlyweight.nameOffset(resType) + 2 + nameLength, 8);
    }

    public static int addressLength(byte resType) {
        switch (resType) {
            case 1: {
                return 4;
            }
            case 2: {
                return 16;
            }
        }
        throw new IllegalStateException("unknown RES_TYPE=" + resType);
    }

    public static boolean isAnyLocalAddress(byte[] address, int addressLength) {
        if (addressLength == 4) {
            return 0 == address[0] && 0 == address[1] && 0 == address[2] && 0 == address[3];
        }
        if (addressLength == 16) {
            byte val = 0;
            for (int i = 0; i < 16; ++i) {
                val = (byte)(val | address[i]);
            }
            return 0 == val;
        }
        return false;
    }
}

