/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.archive.codecs;

/**
 * Language independent boolean type.
 */
public enum BooleanType
{
    FALSE((short)0),

    TRUE((short)1),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL((short)255);

    private final short value;

    BooleanType(final short value)
    {
        this.value = value;
    }

    public short value()
    {
        return value;
    }

    public static BooleanType get(final short value)
    {
        switch (value)
        {
            case 0: return FALSE;
            case 1: return TRUE;
        }

        if ((short)255 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
