/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.archive.codecs;

/**
 * Control protocol response code.
 */
public enum ControlResponseCode
{
    OK(0),

    ERROR(1),

    RECORDING_UNKNOWN(2),

    SUBSCRIPTION_UNKNOWN(3),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ControlResponseCode(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static ControlResponseCode get(final int value)
    {
        switch (value)
        {
            case 0: return OK;
            case 1: return ERROR;
            case 2: return RECORDING_UNKNOWN;
            case 3: return SUBSCRIPTION_UNKNOWN;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
