/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;

/**
 * Used in the catalog to describe the recording descriptor entry which follows.
 */
@SuppressWarnings("all")
public class RecordingDescriptorHeaderDecoder
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 21;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 2;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RecordingDescriptorHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public RecordingDescriptorHeaderDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int lengthId()
    {
        return 1;
    }

    public static int lengthSinceVersion()
    {
        return 0;
    }

    public static int lengthEncodingOffset()
    {
        return 0;
    }

    public static int lengthEncodingLength()
    {
        return 4;
    }

    public static String lengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static int lengthNullValue()
    {
        return -2147483648;
    }

    public static int lengthMinValue()
    {
        return -2147483647;
    }

    public static int lengthMaxValue()
    {
        return 2147483647;
    }

    public int length()
    {
        return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int validId()
    {
        return 2;
    }

    public static int validSinceVersion()
    {
        return 0;
    }

    public static int validEncodingOffset()
    {
        return 4;
    }

    public static int validEncodingLength()
    {
        return 1;
    }

    public static String validMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static byte validNullValue()
    {
        return (byte)-128;
    }

    public static byte validMinValue()
    {
        return (byte)-127;
    }

    public static byte validMaxValue()
    {
        return (byte)127;
    }

    public byte valid()
    {
        return buffer.getByte(offset + 4);
    }


    public static int reservedId()
    {
        return 3;
    }

    public static int reservedSinceVersion()
    {
        return 0;
    }

    public static int reservedEncodingOffset()
    {
        return 31;
    }

    public static int reservedEncodingLength()
    {
        return 1;
    }

    public static String reservedMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static byte reservedNullValue()
    {
        return (byte)-128;
    }

    public static byte reservedMinValue()
    {
        return (byte)-127;
    }

    public static byte reservedMaxValue()
    {
        return (byte)127;
    }

    public byte reserved()
    {
        return buffer.getByte(offset + 31);
    }



    public String toString()
    {
        return appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[RecordingDescriptorHeader](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("length=");
        builder.append(length());
        builder.append('|');
        builder.append("valid=");
        builder.append(valid());
        builder.append('|');
        builder.append("reserved=");
        builder.append(reserved());

        limit(originalLimit);

        return builder;
    }
}
