/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.archive.codecs;

/**
 * Source location for recorded stream.
 */
public enum SourceLocation
{
    LOCAL((short)0),

    REMOTE((short)1),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL((short)255);

    private final short value;

    SourceLocation(final short value)
    {
        this.value = value;
    }

    public short value()
    {
        return value;
    }

    public static SourceLocation get(final short value)
    {
        switch (value)
        {
            case 0: return LOCAL;
            case 1: return REMOTE;
        }

        if ((short)255 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
