/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

/**
 * Language independent boolean type.
 */
public enum BooleanType
{
    FALSE(0),

    TRUE(1),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    BooleanType(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static BooleanType get(final int value)
    {
        switch (value)
        {
            case 0: return FALSE;
            case 1: return TRUE;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
