/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

/**
 * Type of Cluster Change Event.
 */
public enum ChangeType
{
    JOIN(0),

    QUIT(1),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ChangeType(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static ChangeType get(final int value)
    {
        switch (value)
        {
            case 0: return JOIN;
            case 1: return QUIT;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
