/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

/**
 * Reason why a session was closed.
 */
public enum CloseReason
{
    CLIENT_ACTION(0),

    SERVICE_ACTION(1),

    TIMEOUT(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    CloseReason(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static CloseReason get(final int value)
    {
        switch (value)
        {
            case 0: return CLIENT_ACTION;
            case 1: return SERVICE_ACTION;
            case 2: return TIMEOUT;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
