/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

/**
 * Action to be taken by cluster nodes.
 */
public enum ClusterAction
{
    SUSPEND(0),

    RESUME(1),

    SNAPSHOT(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ClusterAction(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static ClusterAction get(final int value)
    {
        switch (value)
        {
            case 0: return SUSPEND;
            case 1: return RESUME;
            case 2: return SNAPSHOT;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
