/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

/**
 * Type the time unit used for timestamps.
 */
public enum ClusterTimeUnit
{
    MILLIS(0),

    MICROS(1),

    NANOS(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ClusterTimeUnit(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static ClusterTimeUnit get(final int value)
    {
        switch (value)
        {
            case 0: return MILLIS;
            case 1: return MICROS;
            case 2: return NANOS;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
