/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;

/**
 * Serialised state of the Consensus Module.
 */
@SuppressWarnings("all")
public class ConsensusModuleEncoder
{
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 105;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 4;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ConsensusModuleEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public ConsensusModuleEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public ConsensusModuleEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int nextSessionIdId()
    {
        return 1;
    }

    public static int nextSessionIdSinceVersion()
    {
        return 0;
    }

    public static int nextSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int nextSessionIdEncodingLength()
    {
        return 8;
    }

    public static String nextSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static long nextSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ConsensusModuleEncoder nextSessionId(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int nextServiceSessionIdId()
    {
        return 2;
    }

    public static int nextServiceSessionIdSinceVersion()
    {
        return 3;
    }

    public static int nextServiceSessionIdEncodingOffset()
    {
        return 8;
    }

    public static int nextServiceSessionIdEncodingLength()
    {
        return 8;
    }

    public static String nextServiceSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "optional";
        }

        return "";
    }

    public static long nextServiceSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextServiceSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextServiceSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ConsensusModuleEncoder nextServiceSessionId(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int logServiceSessionIdId()
    {
        return 3;
    }

    public static int logServiceSessionIdSinceVersion()
    {
        return 3;
    }

    public static int logServiceSessionIdEncodingOffset()
    {
        return 16;
    }

    public static int logServiceSessionIdEncodingLength()
    {
        return 8;
    }

    public static String logServiceSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "optional";
        }

        return "";
    }

    public static long logServiceSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logServiceSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logServiceSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ConsensusModuleEncoder logServiceSessionId(final long value)
    {
        buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int pendingMessageCapacityId()
    {
        return 4;
    }

    public static int pendingMessageCapacitySinceVersion()
    {
        return 3;
    }

    public static int pendingMessageCapacityEncodingOffset()
    {
        return 24;
    }

    public static int pendingMessageCapacityEncodingLength()
    {
        return 4;
    }

    public static String pendingMessageCapacityMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "optional";
        }

        return "";
    }

    public static int pendingMessageCapacityNullValue()
    {
        return 0;
    }

    public static int pendingMessageCapacityMinValue()
    {
        return -2147483647;
    }

    public static int pendingMessageCapacityMaxValue()
    {
        return 2147483647;
    }

    public ConsensusModuleEncoder pendingMessageCapacity(final int value)
    {
        buffer.putInt(offset + 24, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }



    public String toString()
    {
        return appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        ConsensusModuleDecoder writer = new ConsensusModuleDecoder();
        writer.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return writer.appendTo(builder);
    }
}
