/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

/**
 * Type of event for a response.
 */
public enum EventCode
{
    OK(0),

    ERROR(1),

    REDIRECT(2),

    AUTHENTICATION_REJECTED(3),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    EventCode(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static EventCode get(final int value)
    {
        switch (value)
        {
            case 0: return OK;
            case 1: return ERROR;
            case 2: return REDIRECT;
            case 3: return AUTHENTICATION_REJECTED;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
