/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;

/**
 * Event to indicate a new leader has been elected for the cluster.
 */
@SuppressWarnings("all")
public class NewLeaderEventDecoder
{
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 6;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 4;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final NewLeaderEventDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public NewLeaderEventDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int leadershipTermIdId()
    {
        return 1;
    }

    public static int leadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static long leadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long leadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long leadershipTermId()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int clusterSessionIdId()
    {
        return 2;
    }

    public static int clusterSessionIdSinceVersion()
    {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset()
    {
        return 8;
    }

    public static int clusterSessionIdEncodingLength()
    {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static long clusterSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long clusterSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long clusterSessionId()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int leaderMemberIdId()
    {
        return 3;
    }

    public static int leaderMemberIdSinceVersion()
    {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset()
    {
        return 16;
    }

    public static int leaderMemberIdEncodingLength()
    {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static int leaderMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int leaderMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue()
    {
        return 2147483647;
    }

    public int leaderMemberId()
    {
        return buffer.getInt(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int memberEndpointsId()
    {
        return 4;
    }

    public static int memberEndpointsSinceVersion()
    {
        return 0;
    }

    public static String memberEndpointsCharacterEncoding()
    {
        return "US-ASCII";
    }

    public static String memberEndpointsMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "unix";
            case TIME_UNIT: return "nanosecond";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static int memberEndpointsHeaderLength()
    {
        return 4;
    }

    public int memberEndpointsLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int getMemberEndpoints(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getMemberEndpoints(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapMemberEndpoints(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String memberEndpoints()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        final String value;
        try
        {
            value = new String(tmp, "US-ASCII");
        }
        catch (final java.io.UnsupportedEncodingException ex)
        {
            throw new RuntimeException(ex);
        }

        return value;
    }

    public int getMemberEndpoints(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }


    public String toString()
    {
        return appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[NewLeaderEvent](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("leadershipTermId=");
        builder.append(leadershipTermId());
        builder.append('|');
        builder.append("clusterSessionId=");
        builder.append(clusterSessionId());
        builder.append('|');
        builder.append("leaderMemberId=");
        builder.append(leaderMemberId());
        builder.append('|');
        builder.append("memberEndpoints=");
        builder.append('\'' + memberEndpoints() + '\'');

        limit(originalLimit);

        return builder;
    }
}
