/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;

/**
 * A leader has been successfully elected and has begun a new term.
 */
@SuppressWarnings("all")
public class NewLeadershipTermDecoder
{
    public static final int BLOCK_LENGTH = 44;
    public static final int TEMPLATE_ID = 53;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 4;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final NewLeadershipTermDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public NewLeadershipTermDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int logLeadershipTermIdId()
    {
        return 1;
    }

    public static int logLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static long logLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logLeadershipTermId()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int leadershipTermIdId()
    {
        return 2;
    }

    public static int leadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset()
    {
        return 8;
    }

    public static int leadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static long leadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long leadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long leadershipTermId()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int logPositionId()
    {
        return 3;
    }

    public static int logPositionSinceVersion()
    {
        return 0;
    }

    public static int logPositionEncodingOffset()
    {
        return 16;
    }

    public static int logPositionEncodingLength()
    {
        return 8;
    }

    public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static long logPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logPosition()
    {
        return buffer.getLong(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int timestampId()
    {
        return 4;
    }

    public static int timestampSinceVersion()
    {
        return 0;
    }

    public static int timestampEncodingOffset()
    {
        return 24;
    }

    public static int timestampEncodingLength()
    {
        return 8;
    }

    public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static long timestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long timestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public long timestamp()
    {
        return buffer.getLong(offset + 24, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int leaderMemberIdId()
    {
        return 5;
    }

    public static int leaderMemberIdSinceVersion()
    {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset()
    {
        return 32;
    }

    public static int leaderMemberIdEncodingLength()
    {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static int leaderMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int leaderMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue()
    {
        return 2147483647;
    }

    public int leaderMemberId()
    {
        return buffer.getInt(offset + 32, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int logSessionIdId()
    {
        return 6;
    }

    public static int logSessionIdSinceVersion()
    {
        return 0;
    }

    public static int logSessionIdEncodingOffset()
    {
        return 36;
    }

    public static int logSessionIdEncodingLength()
    {
        return 4;
    }

    public static String logSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static int logSessionIdNullValue()
    {
        return -2147483648;
    }

    public static int logSessionIdMinValue()
    {
        return -2147483647;
    }

    public static int logSessionIdMaxValue()
    {
        return 2147483647;
    }

    public int logSessionId()
    {
        return buffer.getInt(offset + 36, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int appVersionId()
    {
        return 7;
    }

    public static int appVersionSinceVersion()
    {
        return 0;
    }

    public static int appVersionEncodingOffset()
    {
        return 40;
    }

    public static int appVersionEncodingLength()
    {
        return 4;
    }

    public static String appVersionMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "optional";
        }

        return "";
    }

    public static int appVersionNullValue()
    {
        return 0;
    }

    public static int appVersionMinValue()
    {
        return 1;
    }

    public static int appVersionMaxValue()
    {
        return 16777215;
    }

    public int appVersion()
    {
        return buffer.getInt(offset + 40, java.nio.ByteOrder.LITTLE_ENDIAN);
    }



    public String toString()
    {
        return appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[NewLeadershipTerm](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("logLeadershipTermId=");
        builder.append(logLeadershipTermId());
        builder.append('|');
        builder.append("leadershipTermId=");
        builder.append(leadershipTermId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(logPosition());
        builder.append('|');
        builder.append("timestamp=");
        builder.append(timestamp());
        builder.append('|');
        builder.append("leaderMemberId=");
        builder.append(leaderMemberId());
        builder.append('|');
        builder.append("logSessionId=");
        builder.append(logSessionId());
        builder.append('|');
        builder.append("appVersion=");
        builder.append(appVersion());

        limit(originalLimit);

        return builder;
    }
}
